<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.createRecoveryPoint" bundle="exchange" />
		<cv-help-component ng-if="exchMbCreateRecoveryPointCtrl.showIndexServerDetails" help-text="<cv:msg key="help.text.create.exchange.recovery.point" bundle="exchange"/>" ></cv-help-component>
	</h1>
</div>
<form name="createRecoveryPointForm" class="form-horizontal bootstrap-wrapper" novalidate data-cv-submit="exchMbCreateRecoveryPointCtrl.doCreateRecoveryPoint()" autocomplete="off">
	<div class="panel-body">
		<div class="form-group row">
			<div class="col-xs-12">
				<label><cv:msg key="info.recoveryPointCreation" bundle="exchange"></cv:msg></label>
			</div>
		</div>
	</div>
	<div ng-if="exchMbCreateRecoveryPointCtrl.showIndexServerDetails">
		<div class="panel-body padding-top-0">
			<div class="form-group row plain-accordion">
				<div class="cv-accordion-header">
					<span class="cv-accordion-text"><cv:msg key="label.associatedIndexServerOverview" bundle="exchange" /></span>
				</div>
			</div>
			<div class="form-group row">
				<span class="col-xs-12 col-md-4" id="indexServer"><cv-help-text help-label="label.indexServer" help-text="help.recoverPointsIndexServer"/></span>
				<span class="col-xs-12 col-md-8" data-ng-bind="exchMbCreateRecoveryPointCtrl.currentIndexServer.mediaAgentName"></span>
			</div>
		</div>
	<!-- <div class="padding-bottom-30"> --> 
		<cv-plain-accordion accordion-label="label.updateIndexServer">
			<div class="panel panel-default">
				<div class="padding-left-15 padding-right-15">
						<div class="form-group row" id="changeIndexServer">
							<label class="col-xs-12 col-md-4"><cv-help-text help-label="label.indexServer" help-text="help.recoverPointsIndexServer"/></label>
							<div class="col-xs-12 col-md-8">
								<div class="input-group">
									<isteven-multi-select
									input-model="exchMbCreateRecoveryPointCtrl.indexServerList"
									output-model="exchMbCreateRecoveryPointCtrl.indexServerResult"
									tick-property="selected"
									button-label="mediaAgentName"
									class="isteven-multi-select "
									item-label="mediaAgentName"
									id="indexServer"
									selection-mode="single" required> </isteven-multi-select>
									<span class="input-group-btn">
										<button id="exchMbCreateRecoveryPointCtrl_button_#3718" type="button"
											data-ng-click="exchMbCreateRecoveryPointCtrl.createNewIndexServer()"
											class="icon-style cv-material-button browse">
											<div class="cv-material-button-icon cursor-pointer">
												<svg height="20" id="cv_cc" viewBox="0 0 448 448" width="20" xmlns="http://www.w3.org/2000/svg">
													<path d="m408 184h-136c-4.417969 0-8-3.582031-8-8v-136c0-22.089844-17.910156-40-40-40s-40 17.910156-40 40v136c0 4.417969-3.582031 8-8 8h-136c-22.089844 0-40 17.910156-40 40s17.910156 40 40 40h136c4.417969 0 8 3.582031 8 8v136c0 22.089844 17.910156 40 40 40s40-17.910156 40-40v-136c0-4.417969 3.582031-8 8-8h136c22.089844 0 40-17.910156 40-40s-17.910156-40-40-40zm0 0"/>
												</svg>
											</div>
											<div class="cv-material-button-tooltip">
												<cv:msg key="label.newExchangeIndexServer" bundle="exchange" />
											</div>
										</button>
									</span>
								</div>
							</div>
						</div>
				</div>
			</div>
		</cv-plain-accordion>
	</div>
	<div class="padding-top-10">
		<div class="modal-footer" ng-if="exchMbCreateRecoveryPointCtrl.showIndexServerDetails">
			<button id="exchDbCreateRecoveryPointOptions_button_#7979" type="button"
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="exchMbCreateRecoveryPointCtrl.cancelModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="exchDbCreateRecoveryPointOptions_button_#3028" class="btn btn-primary cvBusyOnAjax" type="submit">
				<cv:msg key="Submit" bundle="messages" />
			</button>
		</div>
		<div class="modal-footer" ng-if="!exchMbCreateRecoveryPointCtrl.showIndexServerDetails">
			<button id="exchDbCreateRecoveryPointOptions_button_#7979" type="button"
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="exchMbCreateRecoveryPointCtrl.cancelModal()">
				<cv:msg key="button.no" bundle="messages" />
			</button>
			<button id="exchDbCreateRecoveryPointOptions_button_#3028" class="btn btn-primary cvBusyOnAjax" type="submit">
				<cv:msg key="button.yes" bundle="messages" />
			</button>
		</div>
	</div>
</form>
