<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.infrastructurePane" bundle="exchange" />	</h1>
</div>
<div class="setup-content">
	<div class="bootstrap-wrapper form-panel-holder form-horizontal margin-top-0">
		<form name="editInfrastructureSettingsForm"	data-cv-submit="editInfraSettingsCtrl.saveInfo()" novalidate autocomplete="off" class="form-horizontal">
			<div class="panel-body padding-bottom-0" ng-if="!editInfraSettingsCtrl.editAccessNodesInfoOnly">
				<div class="form-group row">
					<label class="col-xs-12 col-md-4"><cv:msg key="label.mailboxPlan" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-8">
						<isteven-multi-select
							input-model="editInfraSettingsCtrl.planList"
							output-model="editInfraSettingsCtrl.selectedPlanList"
							id="planName"
							button-label="planName"
							item-label="planName"
							tick-property="selected"
							class="isteven-multi-select user-group-select"
							helper-elements="none"
							selection-mode="single"
							on-close="editInfraSettingsCtrl.parseIStevenOutput()"
							translation="editInfraSettingsCtrl.localLangPlan"
							group-property="msGroup">
						</isteven-multi-select>
					</div>
				</div>
				<div data-ng-if="editInfraSettingsCtrl.infraStructureSettings.isInfrastructureConfigured" class="text-muted col-xs-12 col-md-offset-4 col-md-8 tile-content-link">
					<cv:msg key="label.infrastructureInheritedFromPlan" bundle="exchange" />
				</div>
				<div class="form-group row" ng-if="!editInfraSettingsCtrl.infraStructureSettings.isInfrastructureConfigured">
					<label class="col-xs-12 col-md-4" id="indexServer"><cv:msg key="label.indexServer" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-8">
						<select id="indexServer" name="indexServer"
							data-ng-model="editInfraSettingsCtrl.infraStructureSettings.indexServer"
							data-ng-change="editInfraSettingsCtrl.indexServerChanged()"
							data-ng-options="indexServer.mediaAgentName for indexServer in editInfraSettingsCtrl.indexServersList track by indexServer.mediaAgentId"
							required>
							<option value=""><cv:msg key="label.selectIndexServer" bundle="exchange" /></option>
						</select>
						<div class="help-block"
							 data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.indexServer)">
							<cv:msg key="error.selectIndexServer" bundle="exchange" />
						</div>
					</div>
				</div>
			</div>
			<div>
				<div class="panel-body">
					<h4 class="text-left" data-ng-if="!editInfraSettingsCtrl.editAccessNodesInfoOnly"><cv:msg key="label.accessNodeSettings" bundle="exchange" /></h4>
					<div class="form-group row">
						<label class="col-xs-12 col-md-4" for="accessNodes"><cv:msg
								key="label.accessNodes" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-8">
							<isteven-multi-select
				   				  input-model="editInfraSettingsCtrl.proxyServers"
				   				  output-model="editInfraSettingsCtrl.selectedProxyList"
				  				  button-label="clientName"
								  item-label="clientName"
				   				  tick-property="selected"
				   				  class="isteven-multi-select user-group-select"
				   				  id="accessNodes"
				   				  name="accessNodes"
				   				  helper-elements="all none reset filter"
				   				  max-labels="2"
				   				  translation="editInfraSettingsCtrl.localLang"
								  on-select-none="editInfraSettingsCtrl.processAccessNodeSelection()"
                    			  on-select-all="editInfraSettingsCtrl.processAccessNodeSelection()"
                    			  on-reset="editInfraSettingsCtrl.processAccessNodeSelection()"
							  	  on-item-click="editInfraSettingsCtrl.processAccessNodeSelection()"
				   				  group-property="msGroup">
							</isteven-multi-select>
							<div class="help-block"
								data-ng-show="editInfraSettingsCtrl.accessNodeRequired && editInfraSettingsCtrl.selectedProxyList.length === 0">
								<cv:msg key="label.selectAccessNodes" bundle="exchange" />
							</div>
						</div>
					</div>
					<div class="form-group row" ng-if="editInfraSettingsCtrl.selectedProxyList.length > 1 || editInfraSettingsCtrl.copyOfInfraStructureSettings.jobResulsDir.path || editInfraSettingsCtrl.requiresLSADetails">
						<label class="col-xs-12 col-md-4"><cv:msg key="label.jobResultsDirectory" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-8">
							<input type="text" id="jobResultsDirectory" name="jobResultsDirectory"
									data-ng-required="editInfraSettingsCtrl.selectedProxyList.length >1 || editInfraSettingsCtrl.requiresLSADetails || editInfraSettingsCtrl.copyOfInfraStructureSettings.jobResulsDir.path"
									data-ng-pattern="editInfraSettingsCtrl.REGEX.WINDOWS_NETWORK_PATH"
									data-ng-model="editInfraSettingsCtrl.infraStructureSettings.jobResulsDir.path" />
							<div class="help-block"
								 data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.jobResultsDirectory) &&  !editInfrastructureSettingsForm.jobResultsDirectory.$error.pattern">
								<cv:msg key="error.noJobResultsDirectory" bundle="exchange" />
							</div>
							<div class="help-block"
								data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.jobResultsDirectory) &&  editInfrastructureSettingsForm.jobResultsDirectory.$error.pattern ">
								<cv:msg key="error.invalidNetworkPath" bundle="exchange" />
							</div>
						</div>
					</div>
					<div  ng-if="editInfraSettingsCtrl.selectedProxyList.length > 1 || editInfraSettingsCtrl.requiresLSADetails || editInfraSettingsCtrl.copyOfInfraStructureSettings.jobResulsDir.path">
						<div class="form-group row plain-accordion">
							<div class="cv-accordion-header">
								<span class="cv-accordion-text"><cv:msg key="label.sharePathAccount" bundle="exchange" /></span>
							</div>
						</div>
                        <div class="form-group row">
                            <label class="col-xs-12 col-md-4" for="username"><cv:msg key="label.userName" bundle="exchange" /></label>
                            <div class="col-xs-12 col-md-8">
                               <input type="text" name="username" id="username"  data-ng-model="editInfraSettingsCtrl.infraStructureSettings.serviceAccount.userAccount.userName" data-ng-required="editInfraSettingsCtrl.selectedProxyList.length > 0 || editInfraSettingsCtrl.isClientGroupSelected"/>
							   <div class="help-block"
									data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.username)">
									<cv:msg key="error.userName" bundle="exchange" />
								</div>
							</div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xs-12 col-lg-4" for="password"><cv:msg key="label.password" bundle="exchange" /></label>
                            <div class="col-xs-12 col-lg-8">
								<input type="password" name="password" id="password" data-ng-model="editInfraSettingsCtrl.infraStructureSettings.serviceAccount.userAccount.password" data-ng-required="editInfraSettingsCtrl.passwordRequired"/>
							   <div class="help-block"
									data-ng-show="cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.password)">
									<cv:msg key="error.password" bundle="exchange" />
								</div>
							</div>
                        </div>
                        <div class="form-group row">
                            <label class="col-xs-12 col-lg-4" for="confirmPassword"><cv:msg key="label.confirmPassword" bundle="exchange" /></label>
                            <div class="col-xs-12 col-lg-8">
                                <input type="password" name="confirmPassword" id="confirmPassword"
                                    data-ng-model="editInfraSettingsCtrl.infraStructureSettings.serviceAccount.userAccount.confirmPassword"
                                    data-cv-equals="{{editInfraSettingsCtrl.infraStructureSettings.serviceAccount.userAccount.password}}"
                                    data-ng-required="editInfraSettingsCtrl.passwordRequired" />
                                <div class="help-block"
                                    data-ng-show="editInfrastructureSettingsForm.confirmPassword.$error.cvEquals && cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.confirmPassword)">
                                    <cv:msg key="error.mismatchedPassword" bundle="exchange" />
                                </div>
								<div class="help-block"
									data-ng-show="!editInfrastructureSettingsForm.confirmPassword.$error.cvEquals && cv.editInfrastructureSettingsForm.needsAttention(editInfrastructureSettingsForm.confirmPassword)">
									<cv:msg key="error.noConfirmPassword" bundle="exchange" />
								</div>
                            </div>
						</div>
						<div class="form-group margin-top-10 margin-bottom-10 margin-left-10 margin-right-10">    
							<div class="col-xs-12 col-md-12 margin-bottom-10">
								<!--Progress stepper--START-->
								<cv-progress-stepper
									data-ng-if="editInfraSettingsCtrl.showStepper"
									input-model="editInfraSettingsCtrl.progressStepperModel"> 
								</cv-progress-stepper>
								<!--Progress stepper--END-->
								<div class="margin-left-10 margin-right-10">
									<div class="row" data-ng-if="editInfraSettingsCtrl.moveJobResultsDirectoryError.length">
										<div class="help-block margin-top-20"> 
											<label data-ng-bind="editInfraSettingsCtrl.moveJobResultsDirectoryError"></label> 
										</div>
									</div>

									<div data-ng-if="editInfraSettingsCtrl.showJobResultsOverride" class="row margin-top-10 italic text-align-left">
										<cv:msg key="confirm.jobResultsOverride" bundle="office365" />
										<a class="margin-left-5" data-ng-click="editInfraSettingsCtrl.overrideJobResultsStep(true)">
											<cv:msg key="button.yes" bundle="messages"></cv:msg>
										</a>
										<a class="margin-left-5" data-ng-click="editInfraSettingsCtrl.overrideJobResultsStep(false)">
											<cv:msg key="button.no" bundle="messages"></cv:msg>
										</a>
									</div>
									<div data-ng-if="editInfraSettingsCtrl.showJobResultsWarning" class="row plain-accordion float-left margin-top-10">
										<div class="cv-accordion-header input-group">
											<span class="padding-15 k-icon k-i-warning red-font fa-2x"></span>
											<div class="cv-accordion-header text-align-left">
												<cv:msg key="warning.jobResultsOverride" bundle="office365" />
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
                    </div>
				</div>
			</div>
			<cv-plain-accordion accordion-label="label.advancedOptions" data-ng-if="(editInfraSettingsCtrl.infraStructureSettings.isUserMailboxPresent || editInfraSettingsCtrl.infraStructureSettings.isJournalMailboxPresent) && !editInfraSettingsCtrl.editAccessNodesInfoOnly">
				<div class="panel-body">
					<div class="form-group row" data-ng-if="editInfraSettingsCtrl.infraStructureSettings.isUserMailboxPresent && !editInfraSettingsCtrl.infraStructureSettings.isInfrastructureConfigured">
						<label class="col-xs-12 col-md-4" id="recallService"><cv:msg key="label.recallService" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-8">
							<input type="text" data-ng-model="editInfraSettingsCtrl.infraStructureSettings.recallService"/>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-xs-12 col-md-4" id="maxStream"><cv:msg key="label.maxStream" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-8">
							<input type="number" id="maxStream" name ="maxStream" data-ng-model="editInfraSettingsCtrl.infraStructureSettings.maxStream" min="0" max="9999" pattern="[0-9]*">
							<div class="help-block" data-ng-show="editInfrastructureSettingsForm.maxStream.$invalid">
                                <cv:msg key="error.max.streams.that.can.be.used" bundle="exchange" />
                            </div>
						</div>
					</div>
				</div>
			</cv-plain-accordion>
			<div class="modal-footer">
				<button id="editInfrastructureSettings_button_#1521" type="button" class="btn btn-default cvBusyOnAjax" data-ng-disabled="editInfraSettingsCtrl.savingInfo || !editInfraSettingsCtrl.enableCloseButton"
					data-ng-click="editInfraSettingsCtrl.closeModal()" data-ng-if="editInfraSettingsCtrl.showCloseButton">
					<cv:msg key="label.close" bundle="messagesJs" />
				</button>
				<button id="editInfrastructureSettings_button_#1508" type="button" class="btn btn-default cvBusyOnAjax" data-ng-disabled="editInfraSettingsCtrl.savingInfo"
				data-ng-click="editInfraSettingsCtrl.cancel()" data-ng-if="!editInfraSettingsCtrl.showCloseButton" >
					<cv:msg key="action.cancel" bundle="profiles" />
				</button>
				<button id="editInfrastructureSettings_button_#3190" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="editInfraSettingsCtrl.savingInfo" data-ng-if="!editInfraSettingsCtrl.showCloseButton">
					<cv:msg key="action.save" bundle="profiles" />
				</button>
			</div>
		</form>
	</div>
</div>
