<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<meta http-equiv="Content-Security-Policy"
	content="default-src *; style-src 'self' 'unsafe-inline'; script-src 'self' 'unsafe-inline' 'unsafe-eval' http://www.google.com">
<div>
	<div class="row bootstrap-wrapper">
		<div class="col-xs-8 col-lg-offset-2">
			<h1>
				<cv:msg key="header.office365Client" bundle="exchange" />
			</h1>
			<form class="form-horizontal create-office365Attributes-form"
				data-cv-submit="addOffice365.next(addOffice365Form)" novalidate
				name="addOffice365Form" autocomplete="off">
				<!-- Step 1: General -->
				<div class="panel panel-default">
					<div class="panel-body">
						<div class="form-group">
							<label class="col-xs-12 col-lg-3" for="appName"><cv:msg
									key="label.name" bundle="exchange" /></label>
							<div class="col-xs-12 col-lg-9">
								<input type="text" name="appName" id="appName"
									placeholder='<cv:msg key="label.exchAppNamePlaceholder" bundle="exchange" />'
									data-ng-disabled="addOffice365.office365Attributes.disableClientName"
									data-ng-pattern="/^[a-zA-Z0-9_-]*$/"
									data-ng-model="addOffice365.office365Attributes.exchangeAttributes.clientName"
									required autofocus />
								<div class="help-block"
									data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.appName)">
									<cv:msg key="error.noServerName" bundle="exchange" />
								</div>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-lg-3" for="serverPlan"><cv:msg
									key="label.serverPlan" bundle="exchange" /></label>
							<div class="col-xs-12 col-lg-9">
								<select id="serverPlan" name="serverPlan"
									data-ng-options="plan.planSummary.plan.planId as plan.planSummary.plan.planName for plan in addOffice365.serverPlanList | orderBy: 'planSummary.plan.planName'"
									required
									data-ng-model="addOffice365.office365Attributes.exchangeAttributes.planId"
									data-ng-change="addOffice365.checkPlanPoolConfiguration()">
									<option value="" disabled selected><cv:msg
											key="label.selectServerPlan" bundle="exchange" /></option>
								</select>
								<div class="help-block"
									data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.serverPlan)">
									<cv:msg key="error.selectPlan" bundle="exchange" />
								</div>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-lg-3" for="serviceType"><cv:msg
									key="label.office365AppSelectionLabel" bundle="exchange" /></label>
							<div class="col-xs-12 col-lg-9">
								<div class="multiple-checkbox-group">
									<input
										data-ng-model="addOffice365.office365Attributes.generalAttributes.exchangeOnline"
										id="exchange" class="" type="checkbox" checked /> <label
										for="exchange"><cv:msg
											key="label.office365Exchange" bundle="exchange" /></label>
								</div>
								<div class="multiple-checkbox-group">
									<input
										data-ng-model="addOffice365.office365Attributes.generalAttributes.sharepointOnline"
										id="sharepoint" class="" type="checkbox" /> <label
										for="sharepoint"><cv:msg
											key="label.office365SharePoint" bundle="exchange" /></label>
								</div>
								<div class="multiple-checkbox-group">
									<input
										data-ng-model="addOffice365.office365Attributes.generalAttributes.oneDriveForBusiness"
										id="onedrive" class="" type="checkbox" /> <label
										for="onedrive"><cv:msg
											key="label.office365OneDrive" bundle="exchange" /></label>
								</div>
							</div>
						</div>
					</div>
				</div>
				<!-- End Step 1 -->
				<uib-accordion close-others="oneAtATime"> <!-- Step 2: Infrastructure Setting -->
				<div data-ng-if="addOffice365.isInfrastructurePoolConfigured"
					class="text-muted">
					<cv:msg key="label.infrastructureInherited" bundle="exchange" />
				</div>
				<div uib-accordion-group class="panel-default"
					data-is-open="addOffice365.infraSettings"
					data-is-disabled="!addOffice365.showInfrastructureTab">
					<uib-accordion-heading class="panel-info">
					<cv:msg key="label.infrastructurePane" bundle="exchange" /> <i
						class="float-right glyphicon"
						data-ng-class="{'glyphicon-chevron-down': addOffice365.infraSettings, 'glyphicon-chevron-right': !addOffice365.infraSettings}"></i>
					</uib-accordion-heading>
					<div class="form-group">
						<!--  Index Server -->
						<label class="col-xs-12 col-lg-3" for="indexServer"><cv:msg
								key="label.indexServer" bundle="exchange" /> <cv-help-component
								help-text='<cv:msg key="info.indexServer" bundle="exchange" />'></cv-help-component></label>
						<div class="col-xs-12 col-lg-9">
							<div
								data-ng-if="addOffice365.indexServerOption === 'createNew' && addOffice365.indexServerList.length > 1">
								<a data-ng-click="addOffice365.setUseExistingIndexServer()"
									class="float-right">Use existing</a>
							</div>
							<div
								data-ng-if="addOffice365.indexServerOption === 'useExisting'">
										<select name="indexServer" id="indexServer" required
											data-ng-options="indexServer.mediaAgentName for indexServer in addOffice365.indexServerList | orderBy: 'mediaAgentName'"
											data-ng-required="addOffice365.indexServerOption === 'useExisting'"
											data-ng-model="addOffice365.office365Attributes.exchangeAttributes.indexServer"
											data-ng-change="addOffice365.createNewIndexServer()">
											<option value="" disabled selected><cv:msg
													key="label.selectIndexServer" bundle="exchange" /></option>
										</select>
										<div
											data-ng-if="addOffice365Form.$submitted || addOffice365.onSaveIndexServerCheck"
											class="help-block"
											data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.indexServer)">
											<cv:msg key="error.selectIndexServer" bundle="exchange" />
										</div>
							</div>
							<div data-ng-if="addOffice365.indexServerOption === 'createNew'">
								<div class="form-group">
									<label class="col-xs-12 col-lg-3 less-margin" for="mediaAgent"><span
										class="label-spacer"><cv:msg key="label.client"
												bundle="profiles" /></span> </label>
									<div class="col-xs-12 col-lg-9">
										<select id="mediaAgent" name="mediaAgent" required
											data-ng-model="addOffice365.office365Attributes.newIndexServerOptions.cloudClient"
											data-ng-required="addOffice365.indexServerOption === 'createNew'"
											data-ng-options="agent.clientName for agent in addOffice365.cloudClients track by agent.clientId"
											class="no-float-auto tile-large-width">
											<option value="" disabled selected><cv:msg
													key="placeholder.selectNode" bundle="profiles" /></option>
										</select>
										<div data-ng-if="addOffice365Form.$submitted"
											class="help-block"
											data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.mediaAgent)">
											<cv:msg key="placeholder.selectNode" bundle="profiles" />
										</div>
									</div>
								</div>
								<div class="form-group">
									<div class="col-xs-12 col-lg-3">
										<label class="less-margin"><span class="label-spacer"><cv:msg
													key="label.indexDirectory" bundle="profiles" /></span> </label>
									</div>
									<div class="col-xs-12 col-lg-9">
										<div class="input-group">
											<input type="text" name="mountPath" id="mountPath"
											data-ng-disabled="!addOffice365.office365Attributes.newIndexServerOptions.cloudClient"
											data-ng-model="addOffice365.office365Attributes.newIndexServerOptions.mountPath"
											required data-ng-pattern='pathPattern' />
											<span class="input-group-btn">
												<button id="createOffice365App_button_#4208" type="button" data-ng-click="addOffice365.browse()" 
													data-ng-disabled="!addOffice365.office365Attributes.newIndexServerOptions.cloudClient"
													class="btn btn-default">
													<cv:msg key="Browse" bundle="storage" />
												</button>
											</span>
										</div>
									</div>
								</div>
								<div data-ng-if="addOffice365Form.$submitted" class="help-block"
									data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.mountPath)">
									<cv:msg key="error.noIndexDirectory" bundle="exchange" />
								</div>
							</div>
						</div>
					</div>
					<!--  Index Server -->
					<!--  Access Nodes -->
					<div class="form-group">
						<label class="col-xs-12 col-lg-3" for="accessNodes"><cv:msg
								key="label.accessNodes" bundle="exchange" /> <cv-help-component
								help-text='<cv:msg key="info.accessNode" bundle="exchange" />'></cv-help-component></label>
						<div class="col-xs-12 col-lg-9">
							<isteven-multi-select input-model="addOffice365.nodeList"
								output-model="addOffice365.office365Attributes.exchangeAttributes.memberServers.memberServers"
								button-label="clientName" item-label="clientName"
								tick-property="selected" data-ng-required="true"
								class="isteven-multi-select user-group-select" id="accessNodes"
								name="accessNodes" helper-elements="all none reset filter"
								max-labels="5" required translation="addOffice365.localLang"
								group-property="msGroup"> </isteven-multi-select>
								<span class="help-block" data-ng-show=""><cv:msg
									key="error.selectNodes" bundle="exchange" /></span>
						</div>
					</div>
					<!--  Access Nodes -->
					<!--  Shared Path -->
					<div class="form-group"
						data-ng-if="addOffice365.office365Attributes.exchangeAttributes.memberServers.memberServers.length > 1">
						<label class="col-xs-12 col-lg-3" for="jobResultDirectory"><cv:msg
								key="label.jobResultsDirectory" bundle="exchange" /> <cv-help-component
								help-text='<cv:msg key="info.jobResultsDir" bundle="exchange" />'></cv-help-component></label>
						<div class="col-xs-12 col-lg-9">
							<input type="text" id="jobResultDirectory"
								name="jobResultDirectory"
								placeholder='<cv:msg key="label.help.jobResultsDirectory" bundle="exchange" />'
								data-ng-model="addOffice365.office365Attributes.exchangeAttributes.jobResulsDir.path"
								data-ng-required="addOffice365.office365Attributes.exchangeAttributes.memberServers.memberServers.length > 1"
								data-ng-pattern="addOffice365.REGEX.WINDOWS_NETWORK_PATH" />
							<span class="help-block"
								data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.jobResultDirectory) || addOffice365Form.jobResultDirectory.$error.pattern">
								<cv:msg key="error.validUNCPath" bundle="exchange" />
							</span>
						</div>
					</div>
					<!--  Shared Path -->
					<div class="form-group"
						data-ng-if="addOffice365.office365Attributes.exchangeAttributes.memberServers.memberServers.length > 1">
						<label class="col-xs-12 col-lg-3" for="serviceAccounts"><cv:msg
								key="label.sharePathAccount" bundle="exchange" /></label>
						<div class="col-xs-12 col-lg-9">
							<h5>
								<a id="addLocalAccount" name="addLocalAccount"
									data-ng-if="!addOffice365.office365Attributes.hasAccountType('SYSTEM_ACCOUNT')"
									data-ng-click="addOffice365.openAddServiceAccountModal( param1, param2, addOffice365.isInfrastructurePoolConfigured, true, false, false)"
									class="float-left"><cv:msg key="label.add"
										bundle="exchange" /></a>
							</h5>
							<a class="float-left"
								data-ng-repeat="userAccount in addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts"
								data-ng-if="addOffice365.office365Attributes.hasAccountType('SYSTEM_ACCOUNT') && addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].serviceType === 'SYSTEM_ACCOUNT'"
								data-ng-click="addOffice365.openAddServiceAccountModal(addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index],
								$index, addOffice365.isInfrastructurePoolConfigured, true,
								false, false)">{{addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].userAccount.userName}}
							</a>
							<div class="help-block"
								data-ng-show="addOffice365.office365Attributes.exchangeAttributes.memberServers.memberServers.length > 1 && !addOffice365.office365Attributes.hasAccountType('SYSTEM_ACCOUNT')">
								<cv:msg key="error.addSharedPathAccount" bundle="exchange" />
							</div>
						</div>
					</div>
				</div>
				<!-- Connection Settings-->
				<div uib-accordion-group class="panel-default"
					data-is-open="addOffice365.connectionSettings">
					<uib-accordion-heading> <cv:msg
						key="label.configPaneOffice365" bundle="exchange" /> <i
						class="float-right glyphicon"
						data-ng-class="{'glyphicon-chevron-down': addOffice365.connectionSettings, 'glyphicon-chevron-right': !addOffice365.connectionSettings}"></i>
					</uib-accordion-heading>
					<div class="panel-body">
						<div class="form-group">
							<label class="col-xs-12 col-lg-3" for="region"><cv:msg
									key="label.region" bundle="exchange" /></label>
							<div class="col-xs-12 col-lg-9">
								<select id="region" name="region" required
									data-ng-model="addOffice365.office365Attributes.exchangeAttributes.onePassProp.cloudRegion">
									<option value="DEFAULT" selected="selected"><cv:msg
											key="label.defaultRegion" bundle="exchange" /></option>
									<option value="CHINA"><cv:msg key="label.china"
											bundle="exchange" /></option>
									<option value="GERMANY"><cv:msg key="label.germany"
											bundle="exchange" /></option>
									<option value="US_GOVERNMENT"><cv:msg
											key="label.usgovt" bundle="exchange" /></option>
								</select>
							</div>
						</div>
						<!-- Global login -->
						<div
							data-ng-if="addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually">
							<div class="form-group">
								<label class="col-xs-12 col-lg-3" for="globalAppEmptyLabel"></label>
								<div class="col-xs-12 col-lg-9">
									<a
										data-ng-click="addOffice365.switchBWGlobalAppManualApp(false)"
										class="float-right"><cv:msg
											key="label.createAppUsingGlobalAdminLogin" bundle="exchange" /></a>
								</div>
							</div>
						</div>
						<div
							data-ng-if="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually">
							<div class="form-group">
								<label class="col-xs-12 col-lg-3" for="globalUserName"><cv:msg
										key="label.globalUsername" bundle="exchange"></cv:msg></label>
								<div class="col-xs-12 col-lg-9">
									<input type="email" id="globalUserName" name="globalUserName"
										data-ng-required="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually"
										data-ng-model="addOffice365.office365Attributes.globalAdminAccount.adminCredential.userName"
										placeholder='<cv:msg key="label.globalUsername" bundle="exchange" />' />
									<span class="help-block"
										data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.globalUserName)">
										<cv:msg key="error.globalAppUsernameError" bundle="exchange" />
									</span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-lg-3" for="globalPassword"><cv:msg
										key="label.password" bundle="exchange"></cv:msg></label>
								<div class="col-xs-12 col-lg-9">
									<input type="password" id="globalPassword"
										name="globalPassword"
										data-ng-required="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually"
										data-ng-model="addOffice365.office365Attributes.globalAdminAccount.adminCredential.password"
										placeholder='<cv:msg key="label.password" bundle="exchange" />' />
									<span class="help-block"
										data-ng-show="cv.addOffice365Form.needsAttention(addOffice365Form.globalPassword)">
										<cv:msg key="error.password" bundle="exchange" />
									</span>
								</div>
							</div>
							<div class="form-group">
								<label class="col-xs-12 col-lg-3" for=""></label>
								<div class="col-xs-12 col-lg-9">
									<span class="input-group-btn">
										<button id="createOffice365App_button_#7110" class="btn btn-primary" type="button" 
											data-ng-disabled="addOffice365.azureAppCreationInProgress"
											data-ng-click="addOffice365.createAzureAppFromGlobalLogin()">
											<cv:msg key="label.createApp" bundle="exchange" />
											<i data-ng-if="addOffice365.azureAppCreationInProgress"
												class="fa fa-spinner fa-spin"></i>
										</button> <a
										data-ng-click="addOffice365.switchBWGlobalAppManualApp(true)"
										class="float-right"><cv:msg key="label.addAppManually"
												bundle="exchange" /></a>
									</span>
									<span
										data-ng-class="addOffice365.isAzureAppAuthorized ? 'text-success complete' : 'text-danger incomplete'">
											<%-- <cv:msg key="label.needAtLeastOneOfTheFollowing"
														bundle="exchange" /> --%>
											{{addOffice365.isAzureAppAuthorizedNote}}
									</span>
									<span class="help-block"
										data-ng-show="addOffice365.globalLoginFailure">
										<cv:msg key="error.appCreationFailed" bundle="exchange" />
									</span>
								</div>
							</div>
						</div>
						<!-- Global login -->
						<div
							data-ng-if="!addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually && addOffice365.office365Attributes.generalAttributes.isGlobalLoginTrue === true &&
							addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureDetails.azureAppKeyID.length > 0">
							<div class="form-group">
								<label class="col-xs-12 col-lg-3" for="serviceAccounts"><cv:msg
										key="label.applicationId" bundle="exchange" /></label>
								<div class="col-xs-12 col-lg-9">
									<table class="table table-borderless table-striped">
										<tbody>
											<tr>
												<td><button id="createOffice365App_button_#4947" type="button" 
														class="btn btn-link float-left"
														data-ng-click="addOffice365.openAddAzureAppModal(addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureDetails)">{{addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureDetails.azureAppKeyID}}</button></td>
											</tr>
										</tbody>
									</table>
								</div>
							</div>
						</div>
						<div
							data-ng-if="addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually &&
							addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureDetails.azureAppKeyID.length > 0">
							<div class="form-group">
								<label class="col-xs-12 col-lg-3" for="serviceAccounts"><cv:msg
										key="label.applicationId" bundle="exchange" /></label>
								<div class="col-xs-12 col-lg-9">
									<table class="table table-borderless table-striped">
										<tbody>
											<tr>
												<td><button id="createOffice365App_button_#5744" type="button" 
														class="btn btn-link float-left"
														data-ng-click="addOffice365.openAddAzureAppModal(addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureDetails)">{{addOffice365.office365Attributes.exchangeAttributes.onePassProp.azureDetails.azureAppKeyID}}</button></td>
											</tr>
										</tbody>
									</table>
								</div>
							</div>
						</div>
						<!-- Service Accounts -->
						<div class="form-group"
							data-ng-if="addOffice365.office365Attributes.generalAttributes.addAppServiceAccountManually">
							<label class="col-xs-12 col-lg-3" for="serviceAccounts"><cv:msg
									key="label.office365ServiceAccts" bundle="exchange" /></label>
							<div class="col-xs-12 col-lg-9">
								<table class="table table-borderless table-striped">
									<tbody>
										<tr
											data-ng-repeat="userAccount in addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts"
											data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].serviceType === 'EXCHANGE_ONLINE'">
											<td
												data-ng-if="addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].serviceType === 'EXCHANGE_ONLINE'"><button id="createOffice365App_button_#4930" 
													type="button" class="btn btn-link float-left"
													data-ng-click="addOffice365.openAddServiceAccountModal(addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index], $index, addOffice365.isInfrastructurePoolConfigured, false, true, false)">{{addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index].exchangeAdminSmtpAddress}}</button></td>
											<td><button id="createOffice365App_button_#0299" type="button" 
													class="btn btn-link float-right"
													data-ng-click="addOffice365.deleteAccountConfirmation(addOffice365.office365Attributes.exchangeAttributes.onePassProp.accounts.adminAccounts[$index], $index)">
													<span class="glyphicon glyphicon-remove"></span>
												</button></td>
										</tr>
									</tbody>
								</table>
								<a
									data-ng-click="addOffice365.openAddServiceAccountModal( param1, param2, addOffice365.isInfrastructurePoolConfigured, false, true, true)"
									class="float-right"><cv:msg key="label.addMoreAccounts"
										bundle="exchange" /></a>
								<div
									data-ng-if="!addOffice365.office365Attributes.hasAccountType('EXCHANGE_ONLINE')"
									class="text-muted">
									<div>
										<cv:msg key="label.needAtLeastOneOfTheFollowing"
											bundle="exchange" />
									</div>
									<ul>
										<li
											data-ng-class="addOffice365.office365Attributes.hasAccountType('EXCHANGE_ONLINE') ? 'text-success complete' : 'text-danger incomplete'"
											data-ng-if="addOffice365.isOffice365"><cv:msg
												key="label.needExchangeOnline" bundle="exchange" /></li>
									</ul>
								</div>
								<span class="help-block"
									data-ng-show="addOffice365.azureAppNotSet">
									<cv:msg key="error.azureAppNotSet" bundle="exchange" />
								</span>
							</div>
						</div>
					</div>
				</div>
				</uib-accordion>
				<!--  Service Accounts -->
				<!-- Buttons -->
				<div class="button-container">
					<button id="createOffice365App_button_#9256" type="submit" class="btn btn-primary" 
						data-ng-disabled="addOffice365.processingRequest">
						<cv:msg key="action.save" bundle="exchange" />
						<i data-ng-if="addOffice365.processingRequest"
							class="fa fa-spinner fa-spin"></i>
					</button>
				</div>
				<!-- Buttons -->
			</form>
		</div>
	</div>
	<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>
</div>