<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>{{addContentStoreMBCtrl.title}}</h1>
</div>
<div class="bootstrap-wrapper form-horizontal">
	<p class="{{addContentStoreMBCtrl.serverMessage.type}} serverMessage">{{addContentStoreMBCtrl.serverMessage.message}}</p>
	<form name="addContentStoreMailboxForm" novalidate data-cv-submit="addContentStoreMBCtrl.addContentStore()" autocomplete="off">
		<div ng-if="!addContentStoreMBCtrl.editMode || !addContentStoreMBCtrl.editSettings.editMailboxPlan">
			<div class="panel-body">
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="name"><cv:msg key="label.displayName" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="text" name="name" id="name" data-ng-model="addContentStoreMBCtrl.model.name" required autofocus />
						<span class="help-block" data-ng-show="cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.name)"><cv:msg key="error.noName" bundle="exchange" /></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="smtpAddress"><cv:msg key="label.mailboxSMTPAddress" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="text" name="smtpAddress" id="smtpAddress" data-ng-model="addContentStoreMBCtrl.model.smtpAddress" required data-ng-pattern="addContentStoreMBCtrl.emailPattern"/>
						<span class="help-block" data-ng-show="addContentStoreMailboxForm.smtpAddress.$error.required && cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.smtpAddress)"><cv:msg key="error.noSmtpAddress" bundle="exchange"/></span>
						<span class="help-block" data-ng-show="addContentStoreMailboxForm.smtpAddress.$error.pattern && cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.smtpAddress)"><cv:msg key="error.invalidSMTPAddress" bundle="exchange"/></span>
					</div>
				</div>
				<div class="form-group" ng-if="!addContentStoreMBCtrl.editMode">
					<label class="col-xs-12 col-md-5 col-lg-5" for="exchangePlan"><cv:msg key="label.exchangePlan" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<select name="exchangePlan" id="exchangePlan" data-ng-options="plan.planSummary.plan.planName for plan in addContentStoreMBCtrl.exchangePlanList | orderBy: 'planSummary.plan.planName'"
							data-ng-model="addContentStoreMBCtrl.model.plan" ng-required="addContentStoreMBCtrl.requiresPlan">
							<option value=""><cv:msg key="label.selectExchangePlan" bundle="exchange" /></option>
					</select>
					<span class="help-block" data-ng-show="cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.exchangePlan)"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
					</div>
				</div>
				<div class="form-group" data-ng-if="addContentStoreMBCtrl.editMode">
					<label class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.removeAssociation" bundle="exchange" /></label>
					<toggle-control class="col-xs-12 col-md-7 col-lg-7" status="false" data-ng-click="addContentStoreMBCtrl.removeAssociation('DISABLE')"></toggle-control>
				</div>
			</div>
			<cv-plain-accordion accordion-label="label.infrastructurePane" collapsed="addContentStoreMBCtrl.accordion.collapsed">
				<div class="panel-body">
					<div class="form-group">
						<label class="col-xs-12 col-md-5 col-lg-5" for="accessNode"><cv:msg key="label.contentStoreMailServer" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<isteven-multi-select id="addContentStoreMailbox_isteven-multi-select_#2672" 
								translation="addContentStoreMBCtrl.localLang"
								input-model="addContentStoreMBCtrl.accessNodeList"
								output-model="addContentStoreMBCtrl.model.infraSettings.accessNodes"
								helper-elements="all none reset filter"
								button-label="accessNode"
								item-label="accessNode"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								on-select-none="addContentStoreMBCtrl.validateNodeSelection(false)"
								on-select-all="addContentStoreMBCtrl.validateNodeSelection(false)"
								on-reset="addContentStoreMBCtrl.validateNodeSelection(true)"
								on-item-click="addContentStoreMBCtrl.validateCacheLocations(data)"
								max-labels="2" ng-cloak>s
							</isteven-multi-select>
							<span class="help-block" data-ng-show="addContentStoreMBCtrl.showNodesErrorMessage "><cv:msg key="error.selectContentStoreServer" bundle="exchange"/></span>
						</div>
					</div>
					<div ng-if="addContentStoreMBCtrl.model.infraSettings.accessNodes.length < 2">
						<div class="form-group">
							<label class="col-xs-12 col-md-5 col-lg-5" for="mountPath1"><cv:msg key="label.cacheLocation" bundle="exchange" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<div class="input-group" ng-if="addContentStoreMBCtrl.model.infraSettings.accessNodes.length < 2">
									<input type="text" name="mountPath1" id="mountPath1" data-ng-model="addContentStoreMBCtrl.model.infraSettings.cache[0].location" class="gen-thresholdValue" value="Upload file" data-ng-required="addContentStoreMBCtrl.isMailServerCacheValid" readonly="readonly"/>
									<span class="input-group-btn vertical-align-bottom">
										<button id="addContentStoreMailbox_button_#6855" type="button" data-ng-disabled="!addContentStoreMBCtrl.model.infraSettings.accessNodes.length"  data-ng-click="addContentStoreMBCtrl.browse(0)" class="btn btn-default browse-btn">Browse</button> 
									</span>
								</div>
							</div>
						</div>
					</div>
					<div ng-if="addContentStoreMBCtrl.model.infraSettings.accessNodes.length > 1">
						<div class="form-group">
								<label class="col-xs-12 col-md-5 col-lg-5" for="mountPath1"><cv:msg key="label.cacheLocation" bundle="exchange" /></label>
						</div>
						<div class="form-group">
							<div class="col-md-offset-1 col-lg-offset-1 col-xs-12 col-md-11 col-lg-11">
								<div ng-repeat="node in addContentStoreMBCtrl.model.infraSettings.accessNodes">
									<div add-cache-location  accessnode="{{node.accessNode}}" cachelocation="addContentStoreMBCtrl.model.infraSettings.cache" counter="{{$index}}"  browse="addContentStoreMBCtrl.browse(counter)"></div>
								</div>
							</div>
						</div>
					</div>
					<div class="form-group">
						<div class="col-xs-12 col-md-offset-5 col-lg-offset-5">
							<span class="help-block" data-ng-show="addContentStoreMBCtrl.isMailServerCacheValid"><cv:msg key="error.selectMailServerAndCache" bundle="exchange" /></span>
						</div>
					</div>
				</div>
			</cv-plain-accordion>
			<cv-plain-accordion accordion-label="label.networkSettings">
				<div class="panel-body">
					<div class="form-group">
						<div class="col-xs-12">
							<label>
								<toggle-control name="autoIPDetection" id="autoIPDetection"  status="addContentStoreMBCtrl.model.infraSettings.enableAutoIPDetection" data-ng-click="addContentStoreMBCtrl.setDetectIPOffice365()"></toggle-control>
								<span><cv-help-text help-label="label.detectIPforOffice365" help-text="label.detectwhitelistIPaddresses"/></span>
							</label>
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-md-5 col-lg-5" for="whiteListIPs"><cv-help-text help-label="label.whitelistIPaddresses" help-text="info.listOfIPaddresses"/></label>
						<div ng-init="addContentStoreMBCtrl.model.IPAddress=''" class="col-xs-12 col-md-7 col-lg-7 host-name-input-wrapper">
							<input class="display-inline" ng-blur="addContentStoreMBCtrl.addIPAddress()" type="text" name="whiteListIPs" id="path" data-ng-model="addContentStoreMBCtrl.model.IPAddress"  
								data-ng-pattern="addContentStoreMBCtrl.IPPattern" autocompletetype="disable" autocomplete="off"  placeholder='<cv:msg key="label.enterIPAddress" bundle="exchange"/>'>
							<span ng-disabled="!addContentStoreMBCtrl.model.IPAddress">
								<span  class="k-icon k-i-plus cursor-pointer" id="add-host-name" title="Add" ng-click="addContentStoreMBCtrl.addIPAddress()"></span>
							</span>
							<div class="cv-help-block"  data-ng-if="addContentStoreMBCtrl.model.errors.showIPErrorMsg">{{addContentStoreMBCtrl.model.errors.IPErrorMsg}}</div>
							<span class="help-block" data-ng-show="addContentStoreMailboxForm.whiteListIPs.$error.pattern"><cv:msg key="error.invalidIPAddress" bundle="exchange" /></span>
							<div ng-repeat="ipAddress in addContentStoreMBCtrl.model.IPAddressList" class="info-tag">
								<div class="cv-flex">
									<span title="{{ipAddress}}" class="crop" ng-bind="ipAddress"></span>
									<span>
										<a class="close-icon k-icon k-i-close cursor-pointer" ng-click="addContentStoreMBCtrl.removeIPAddress($index)"></a>
									</span>
								</div>
							</div>
						</div>
					</div>
				</div>
			</cv-plain-accordion>
			<cv-plain-accordion accordion-label="label.certificateSettings">
				<div class="panel-body">
					<div class="form-group">
						<label class="col-xs-12 col-md-5 col-lg-5" for="certificatefile"><cv:msg key="label.certificateFile" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<span name="apply-license-upload" class="btn btn-default btn-file btn-file-fullWidth">
									<span class="btn-upload-text"><cv:msg key="info.uploadFile" bundle="exchange"/></span>
									<input type="file" id="certificatefile" name="certificatefile" files-input ng-model="addContentStoreMBCtrl.model.infraSettings.certificateInfo" data-ng-change="addContentStoreMBCtrl.onFileInputChange()" data-ng-required="addContentStoreMBCtrl.isCertificateDetailsPresent"/>
							</span>
							<span class="help-block" data-ng-show="cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.certificatefile)"><cv:msg key="error.noFileUploaded" bundle="exchange" /></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-md-5 col-lg-5" for="certificateFilePassword"><cv:msg key="label.password" bundle="exchange" /></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input type="password" name="certificateFilePassword" id="certificateFilePassword" autocomplete="false" placeholder='<cv:msg key="label.passwordForCertificateFile" bundle="exchange"/>' data-ng-model="addContentStoreMBCtrl.model.infraSettings.password" data-ng-required="addContentStoreMBCtrl.isCertificateDetailsPresent" />
							<span class="help-block" data-ng-show="cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.certificateFilePassword)"><cv:msg key="error.noPassword" bundle="exchange" /></span>
						</div>
					</div>
				</div>
			</cv-plain-accordion>
		</div>
		<div class="panel-body" ng-if="addContentStoreMBCtrl.editMode && addContentStoreMBCtrl.editSettings.editMailboxPlan">
			<div class="form-group">
				<label class="col-xs-12 col-md-5 col-lg-5" for="exchangePlan"><cv:msg key="label.exchangePlan" bundle="exchange" /></label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<select name="exchangePlan" id="exchangePlan" data-ng-options="plan.planSummary.plan.planName for plan in addContentStoreMBCtrl.exchangePlanList | orderBy: 'planSummary.plan.planName'"
						data-ng-model="addContentStoreMBCtrl.model.plan" ng-required="addContentStoreMBCtrl.requiresPlan">
						<option value=""><cv:msg key="label.selectExchangePlan" bundle="exchange" /></option>
				</select>
				<span class="help-block" data-ng-show="cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.exchangePlan)"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
				</div>
			</div>
		</div>
	<div class="button-container">
		<button id="addContentStoreMailbox_button_#6199" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="addContentStoreMBCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
		<button id="addContentStoreMailbox_button_#1015" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
	</div>
</form>
</div>
