<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div data-ng-controller="exchDbSeverSelectionController as exchDbSCServSelCtrl">
	<div class="setup-title">
		<h1>
			<cv:msg key="header.server.details" bundle="exchange"/>
			<cv-help-component help-text="<cv:msg key="label.exdb.server.selection.help.text" bundle="exchange"/>"></cv-help-component>
		</h1>
	</div>
	<div class="setup-content exch-db-server-selection">
		<div class="{{exchDbSCServSelCtrl.addServSelectionMessage.type}} serverMessage">{{exchDbSCServSelCtrl.addServSelectionMessage.message}}</div>
		<form name="exDbSCServSelForm" novalidate data-cv-submit="exchDbSCServSelCtrl.modifyExDbSCWithServSel()" autocomplete="off">
			<div class="cv-modal-wrapper">
				<!-- Begin Radio Button Grps-->
				<label class="cv-label" for="serverSelection" class="storage-type"><cv:msg key="label.server.selection" bundle="exchange"/></label>
				<div class="cv-inline-wrapper exdb-padleft">
					<label for="typeOfServSelAutomatic" class="inline-label no-margin">
						<input type="radio" id="typeOfServSelAutomatic" class="no-float-auto" data-ng-model="exchDbSCServSelCtrl.typeOfServSel" value="{{exchDbSCServSelCtrl.serverTypeAuto}}" name="typeOfServerSelection"
						data-ng-click="exchDbSCServSelCtrl.resetErrorMessage()">
						<cv:msg key="label.server.selection.automatic" bundle="exchange"/>
					</label>
					<label for="typeOfServSelManual" class="inline-label">
						<input type="radio" id="typeOfServSelManual" class="no-float-auto" data-ng-model="exchDbSCServSelCtrl.typeOfServSel" value="{{exchDbSCServSelCtrl.serverTypeManual}}" name="typeOfServerSelection"
						data-ng-click="exchDbSCServSelCtrl.loadDBServerAssocsToGrid()">
						<cv:msg key="label.server.selection.manual" bundle="exchange"/>
					</label>
				</div>
			</div>
			<!-- Begin Radio Button Grps -->
			<!-- Begin checkbox section for Automatic Server selection -->
			<div class="cv-modal-wrapper" data-ng-show="exchDbSCServSelCtrl.typeOfServSel === exchDbSCServSelCtrl.serverTypeAuto">
				<label class="dag-option-checkbox-label" for="dagOptions" class="storage-type"><cv:msg key="label.dag.options" bundle="exchange"/></label>
				<div class="cv-inline-wrapper">
					<div class="modal-wrapper line-height-1">
						<input id="passiveCopy" type="checkbox" data-ng-model="exchDbSCServSelCtrl.passiveCopySel" data-ng-change="exchDbSCServSelCtrl.resetLastPerfIfPassiveDeselected()" />
							<label for="passiveCopy" class="checkbox-label">
								<cv:msg key="label.backup.from.passive.copy" bundle="exchange"/>
							</label>
					</div>
					<div class="modal-wrapper line-height-1">
						<input id="activeCopy" type="checkbox" data-ng-model="exchDbSCServSelCtrl.activeCopySel" data-ng-disabled="exchDbSCServSelCtrl.passiveCopySel == false"/>
							<label for="activeCopy" class="checkbox-label">
								<cv:msg key="label.backup.active.copy.if.no.passive" bundle="exchange"/>
							</label>
					</div>
					<div class="modal-wrapper line-height-1">
						<input id="lastPreference" type="checkbox" data-ng-model="exchDbSCServSelCtrl.useLastActivation" data-ng-disabled="exchDbSCServSelCtrl.passiveCopySel == false"/>
							<label for="lastPreference" class="checkbox-label">
								<cv:msg key="label.use.last.activation.preference" bundle="exchange"/>
							</label>
					</div>
				</div>
			</div>
			<!-- End checkbox section for Automatic Server selection -->
			<!-- Begin checkbox section for Manual Server selection -->
			<div class="cv-modal-wrapper exdb-padding" data-ng-show="exchDbSCServSelCtrl.typeOfServSel === exchDbSCServSelCtrl.serverTypeManual">
				<!--  <div data-ui-grid="exchDbSCServSelCtrl.dbServerGridOptions" data-ui-grid-edit class="grid-style users-grid"></div>-->
				<cv-grid cv-grid-options="exchDbSCServSelCtrl.dbServerAssocGridOptions" data-ng-hide="exchDbSCServSelCtrl.noMoreServerSelAvailable"></cv-grid>
			</div>
			<!-- Begin checkbox section for Manual Server selection -->
			<div class="button-container" data-ng-show="exchDbSCServSelCtrl.bIsEdit === true">
				<!-- <button id="exchDbSCServerSelection_button_#8185" type="button" class="btn btn-primary cvBusyOnAjax float-left" data-ng-if="exchDbSCServSelCtrl.typeOfServSel === exchDbSCServSelCtrl.serverTypeManual" 
				data-ng-click="exchDbSCServSelCtrl.discoverDbServers()"><cv:msg key="label.button.discover" bundle="exchange"/></button> -->
				<button id="exchDbSCServerSelection_button_#3050" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="exchDbSCServSelCtrl.updateExDbSCCancelled()"><cv:msg key="Cancel" bundle="messages"/></button> 
				<button id="exchDbSCServerSelection_button_#1010" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="exchDbSCServSelCtrl.typeOfServSel === exchDbSCServSelCtrl.serverTypeManual && exchDbSCServSelCtrl.noMoreServerSelAvailable"><cv:msg key="Save" bundle="messages"/></button> 
			</div>
			<div class="button-container exchange-button-container-right" data-ng-show="exchDbSCServSelCtrl.bIsEdit === false">
				<button id="exchDbSCServerSelection_button_#3798" type="button" data-ng-click="exchDbSCServSelCtrl.goPreviousStep()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="previous" bundle="messages" /></button> 
				<button id="exchDbSCServerSelection_button_#3196" type="button" data-ng-click="exchDbSCServSelCtrl.addNewSubclient()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button> 
			</div>
		</form>
	</div>
</div>
