<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div data-ng-controller="exchDbAdditionalSettingsController as exchDbAddSettingsCtrl">
	<div class="setup-title">
		<h1>
			<cv:msg key="header.settings" bundle="exchange"/>
			<cv-help-component help-text="<cv:msg key="label.exdb.additonal.settings.help.text" bundle="exchange"/>"></cv-help-component>
		</h1>
	</div>
	<div class="setup-content">
		<div class="{{exchDbAddSettingsCtrl.addSettingsMessage.type}} serverMessage">{{exchDbAddSettingsCtrl.addSettingsMessage.message}}</div>
		<form name="exDbSCAddSettingsForm" novalidate data-cv-submit="exchDbAddSettingsCtrl.modifyExDbSCWithAddSettings()" autocomplete="off">
			<!-- Begin Max streams that can be selected -->
			<div class="cv-modal-wrapper">
				<label class="cv-label ellipsis-content" for="maxStreamsUsed"><cv:msg key="label.max.streams.that.can.be.used" bundle="exchange"/></label>
				<div class="cv-inline-wrapper">
					<input id="maxStreamsUsed" name="maxStreamsUsed" type="number" min="1" data-ng-model="exchDbAddSettingsCtrl.noOfStreams" class="storage-retention-input"/>
				</div>
				<span class="help-block-top" data-ng-show="cv.exDbSCAddSettingsForm.needsAttention(exDbSCAddSettingsForm.maxStreamsUsed)"><cv:msg key="error.max.streams.that.can.be.used" bundle="exchange"/></span>
			</div>
			<!-- End Max streams that can be selected -->
			<!-- Begin Optimize message recovery -->
			<div class="cv-modal-wrapper">
				<input type="checkbox" id="optimizeMessageRecovery" data-ng-model="exchDbAddSettingsCtrl.bOptimizeMessageRecovery" data-ng-change="exchDbAddSettingsCtrl.evaluateBlockLevelStatus()"/>
					<label for="optimizeMessageRecovery" class="margin-left-10"><cv:msg key="label.optimize.message.level.recovery" bundle="exchange"/></label>
			</div>
			<div class="cv-modal-wrapper" data-ng-show="exchDbAddSettingsCtrl.showBlockLevelMessage">
				<p class="small-info-text text-left"><cv:msg key="info.block.level.backup" bundle="exchange" /></p>
			</div>
			<!-- End Optimize message recovery-->
			<div class="button-container" data-ng-show="exchDbAddSettingsCtrl.bIsEdit === true">
					<button id="exchDbSCAddSettings_button_#0875" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="exchDbAddSettingsCtrl.updateExDbSCCancelled()"><cv:msg key="Cancel" bundle="messages"/></button> 
					<button id="exchDbSCAddSettings_button_#5185" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages"/></button> 
			</div>
			<div class="button-container" data-ng-show="exchDbAddSettingsCtrl.bIsEdit === false">
				<button id="exchDbSCAddSettings_button_#2406" type="button" data-ng-click="exchDbAddSettingsCtrl.goPreviousStep()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="previous" bundle="messages" /></button> 
				<button id="exchDbSCAddSettings_button_#4016" type="button" data-ng-click="exchDbAddSettingsCtrl.saveAddSettings()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Next" bundle="messages" /></button> 
			</div>
		</form>
	</div>
</div>
