<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvEnum name="App.ExchangeVersion"></cv:cvEnum>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.restoreOpts" bundle="restore" />
		<cv-help-component
			help-text="<cv:msg key="label.db.restore.help.text" bundle="exchange"/>"></cv-help-component>
	</h1>
</div>
<form name="restoreForm" class="form-horizontal bootstrap-wrapper"
	novalidate data-cv-submit="exchDbRestoreCtrl.doRestore()"
	autocomplete="off">
	<div class="modal-body">
		<span class="serverMessage {{exchDbRestoreCtrl.restoreMessage.type}}"
			data-ng-bind="exchDbRestoreCtrl.restoreMessage.message"></span>
		<!-- Begin: Restore options -->
		<div class="form-group">
			<label for="destinationServer" class="col-xs-5"><cv:msg
					key="label.restoreTo" bundle="exchange" /></label>
			<div class="col-xs-7">
				<select id="restoreTypeSelection" name="restoreTypeSelection"
					data-ng-model="exchDbRestoreCtrl.restoreTypeSelection"
					data-ng-required="true"
					data-ng-change="exchDbRestoreCtrl.restoreTypeSelectionChanged()">
					<option value="{{exchDbRestoreCtrl.restoreTypeSameDatabase}}"><cv:msg
							key="label.restore.selection.SameDatabase" bundle="exchange" /></option>
					<option value="{{exchDbRestoreCtrl.restoreTypeAnotherDatabase}}"><cv:msg
							key="label.restore.selection.anotherDatabase" bundle="exchange" /></option>
					<option value="{{exchDbRestoreCtrl.restoreTypeOutOfPlace}}"><cv:msg
							key="label.restore.selection.outOfPlace" bundle="exchange" /></option>
				</select> <span class="help-block"
					data-ng-show="cv.restoreForm.needsAttention(restoreForm.restoreTypeSelection)">
					<cv:msg key="error.restoreTypeSelection" bundle="exchange" />
				</span>
				<!--Begin: checkbox section for Out of place restore - Without recovery selection -->
				<div class="ccol-xs-7 inline-cv-help"
					data-ng-show="(exchDbRestoreCtrl.restoreTypeSelection == exchDbRestoreCtrl.restoreTypeOutOfPlace)">
					<input id="outOfPlaceWithoutRecovery"
						name="outOfPlaceWithoutRecovery" type="checkbox"
						data-ng-model="exchDbRestoreCtrl.restoreOutOfPlaceWithoutRecovery" />
					<label for="outOfPlaceWithoutRecovery"><cv:msg
							key="label.vssRestore.outOfPlace.withoutRecovery"
							bundle="exchange"></cv:msg> <cv-help-component
							help-text='<cv:msg key="label.vssRestore.outOfPlace.withoutRecovery.help.text" bundle="exchange"/>'></cv-help-component></label>
				</div>
				<!--End: checkbox section for Out of place restore - Without recovery selection -->
			</div>
		</div>
		<!-- Begin: Destination Severs -->
		<div class="form-group">
			<label for="destinationServer" class="col-xs-5"><cv:msg
					key="label.destHost" bundle="exchange" /></label>
			<div class="col-xs-7">
				<select id="destinationServer" name="destinationServer"
					data-ng-options="ds as ds.name for ds in exchDbRestoreCtrl.destinationServerList  | orderBy: 'name' track by ds.id"
					data-ng-model="exchDbRestoreCtrl.selectedDestinationServer"
					data-ng-required="true"
					data-ng-change="exchDbRestoreCtrl.destinationServerChanged()"
					data-ng-disabled="exchDbRestoreCtrl.restoreTypeSelection === exchDbRestoreCtrl.restoreTypeSameDatabase">
					<option value=""><cv:msg
							key="placeholder.selectDestinationServer" bundle="restoreJs" /></option>
				</select> <span class="help-block"
					data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationServer)">
					<cv:msg key="error.destinationServer" bundle="restore" />
				</span>
			</div>
			<div data-ng-show="(exchDbRestoreCtrl.showMemberServer)">
				<label for="memberServer" class="col-xs-5"><cv:msg
						key="label.member.server" bundle="exchange" /></label>
				<div class="col-xs-7">
					<select id="memberServer" name="memberServer"
						data-ng-options="ds as ds.clientName for ds in exchDbRestoreCtrl.memberServerList  | orderBy: 'clientName' track by ds.clientId"
						data-ng-model="exchDbRestoreCtrl.selectedMemberServer"
						data-ng-required="exchDbRestoreCtrl.showMemberServer"
						data-ng-change="exchDbRestoreCtrl.memberServerChanged()"
						data-ng-disabled="exchDbRestoreCtrl.selectedDestinationServer === null">
						<option value=""><cv:msg
								key="placeholder.selectMemberServer" bundle="exchange" /></option>
					</select> <span class="help-block"
						data-ng-show="cv.restoreForm.needsAttention(restoreForm.memberServer)">
						<cv:msg key="error.selectMemberServer" bundle="exchange" />
					</span>
				</div>
			</div>
		</div>
		<!-- End: Destination Severs -->
		<!-- Begin: Restore to another database destination DB selection -->
		<div class="cv-modal-wrapper exdb-restore-items-grid" data-ng-show="exchDbRestoreCtrl.restoreTypeSelection === exchDbRestoreCtrl.restoreTypeAnotherDatabase">
			<cv-grid cv-grid-options="exchDbRestoreCtrl.restoreToAnotherDbAssocGridOptions" data-ng-hide="exchDbRestoreCtrl.noMoreDBsAvailableForAnotherDbRestore"></cv-grid>
		</div>
		<!-- End: Restore to another database destination DB selection -->
		<!-- Begin: Out of place Restore destination path selection -->
		<div class="cv-modal-wrapper exdb-restore-items-grid"
			data-ng-show="(exchDbRestoreCtrl.restoreTypeSelection == exchDbRestoreCtrl.restoreTypeOutOfPlace)">
			<cv-grid
				cv-grid-options="exchDbRestoreCtrl.dbOopLocationAssocGridOptions"></cv-grid>
		</div>
		<!-- End: Out of place Restore destination path selection -->
		<!-- End: Restore options -->
	</div>
	<div class="modal-footer">
		<button id="exchDbRestoreOptions_button_#5190" type="button" 
			class="btn btn-default cvBusyOnAjax setup-btn--hidden"
			data-ng-click="exchDbRestoreCtrl.cancelModel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="exchDbRestoreOptions_button_#4905" class="btn btn-primary cvBusyOnAjax" type="submit"> 
			<cv:msg key="Submit" bundle="messages" />
		</button>
	</div>
</form>
