<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvEnum name="App.ExchangeVersion"></cv:cvEnum>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.offlineDBRecovery" bundle="exchange" />
		<cv-help-component help-text="<cv:msg key="help.text.offline.db.recovery" bundle="exchange"/>"></cv-help-component>
	</h1>
</div>
<div class="bootstrap-wrapper">
<form name="offlineDbRecoveryForm" class="form-horizontal" novalidate data-cv-submit="exDbOffDbRecCtrl.doBrowseOfflineDB()" autocomplete="off">
	<div class="panel">
		<div class="panel-body">
		<span class="serverMessage {{exDbOffDbRecCtrl.serverMessage.type}}" data-ng-bind="exDbOffDbRecCtrl.serverMessage.message"></span>
		<!-- Begin: Destination Severs -->
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="destinationServer"><cv:msg key="label.rp.selectMediaAgent" bundle="exchange" />
				<cv-help-component help-text='<cv:msg key="label.rp.selectMediaAgent.help.text" bundle="exchange"/>'></cv-help-component>
			</label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<select id="destinationServer"
					name="destinationServer"
					data-ng-options="ds as ds.maName for ds in exDbOffDbRecCtrl.destinationServerList  | orderBy: 'maName' track by ds.maId"
					data-ng-model="exDbOffDbRecCtrl.selectedDestinationServer"
					data-ng-required="true"
					data-ng-change="exDbOffDbRecCtrl.destinationServerChanged()">
					<option value=""><cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs" /></option>
				</select>
				<span class="help-block" data-ng-show="exDbOffDbRecCtrl.inputAlerts.destinationServer || cv.offlineDbRecoveryForm.needsAttention(offlineDbRecoveryForm.destinationServer)">
					<cv:msg key="error.destinationServer" bundle="restore" />
				</span>
			</div>
		</div>
		<!-- End: Destination Severs -->
		<!-- Begin:Exdb location-->
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="edbPath"><cv:msg key="label.edbPath" bundle="exchange"/></label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<div class="input-group">
					<input type="text" name="edbPath" id="edbPath" data-ng-model="exDbOffDbRecCtrl.edbPath" required data-ng-pattern='pathPattern' title="{{exDbOffDbRecCtrl.edbPath}}" />
					<span class="input-group-btn">
						<button id="exchDbOfflineDBRecoveryOptions_button_#4694"  type="button" data-ng-click="exDbOffDbRecCtrl.browse()" class="btn btn-default less-margin"> 
							<cv:msg key="Browse" bundle="storage" />
						</button>
					</span>
				</div>
				<span class="help-block" data-ng-show="exDbOffDbRecCtrl.inputAlerts.edbPath || cv.offlineDbRecoveryForm.needsAttention(offlineDbRecoveryForm.edbPath)">
					<cv:msg key="error.edbPath" bundle="exchange" />
				</span>
			</div>
		</div>
		<!--  End: Exdb location -->
		</div>
	</div>
	<div class="modal-footer">
		<button id="exchDbOfflineDBRecoveryOptions_button_#9133" type="button" 
			class="btn btn-default cvBusyOnAjax setup-btn--hidden"
			data-ng-click="exDbOffDbRecCtrl.cancelModal()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="exchDbOfflineDBRecoveryOptions_button_#6525" class="btn btn-primary cvBusyOnAjax" type="submit"> 
			<cv:msg key="ContinueToRestore" bundle="exchange" />
		</button>
	</div>
</form>
</div>