
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.backupOptions" bundle="exchange"/></h1>
</div>
<div class="setup-content backup-options">
	<span class="{{exchDbBkpCtrl.serverMessage.type}} serverMessage">{{exchDbBkpCtrl.serverMessage.message}}</span>
	<span data-ng-show="!exchDbBkpCtrl.backupMsg">
		<div class="global-options remove-border-padding">
			<label><cv:msg key="label.backupLevel" bundle="exchange"/></label>
		</div>
		<div class="global-options remove-border-padding">
			<label class="element-indent-class">
				<input type="radio" ng-model="exchDbBkpCtrl.backupType" value="FULL">
				<cv:msg key="option.full" bundle="schedule"/>
			</label>
			<label class="element-indent-class">
				<input type="radio" ng-model="exchDbBkpCtrl.backupType" value="INCREMENTAL">
				<cv:msg key="option.incremental" bundle="schedule"/>
			</label>
		</div>
	</span>
	<div class="button-container">
		<button id="exchDbBackupOptions_button_#6219" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="exchDbBkpCtrl.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
		<button id="exchDbBackupOptions_button_#7998" type="submit" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}"  data-ng-click="exchDbBkpCtrl.startBackup()"><cv:msg key="OK" bundle="messages"/></button> 
	</div>
</div>
