<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<span class="setup-content">
<div class="setup-title">
	<h1><cv:msg key="heading.clientGeneral" bundle="clients"/></h1>
</div>
<div class="bootstrap-wrapper"> <!-- //max-width-600-center // -->
	<div>
		<div class="{{eExGenInfoCtrl.editExchangeGeneralInfoMessage.type}} serverMessage">{{eExGenInfoCtrl.editExchangeGeneralInfoMessage.message}}</div>
		<form name="editExchangeGeneralInfoForm" data-cv-submit="eExGenInfoCtrl.saveInfo()" novalidate autocomplete="off">
			<div class="panel panel-default no-border">
			<div class="panel-body">
				<div class="form-group min-height">
					<label class="col-xs-12 col-sm-5" for="serverName"><cv:msg key="label.clientName" bundle="clients" /></label>
					<label class="col-xs-12 col-sm-7">{{eExGenInfoCtrl.model.clientName}}</label>
				</div>
				<div class="form-group min-height">
					<label class="col-xs-12 col-sm-5" for="hostName"><cv:msg key="label.data.serverHostName" bundle="servers" /></label>
					<label class="col-xs-12 col-sm-7">
						{{eExGenInfoCtrl.model.hostName}}
					</label>
				</div>
				<div class="form-group min-height">
					<label class="col-xs-12 col-sm-5" for="jobResultDirectory"><cv:msg key="label.jobResultsDirectory" bundle="exchange" /></label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" name="jobResultDirectory"  data-ng-model="eExGenInfoCtrl.model.jobResultDirectory.path" required data-ng-pattern="eExGenInfoCtrl.networkPathPattern"/>
					<span class="help-block" data-ng-show="editExchangeGeneralInfoForm.jobResultDirectory.$error.required && cv.editExchangeGeneralInfoForm.needsAttention(editExchangeGeneralInfoForm.jobResultDirectory)"><cv:msg key="error.noJobResultsDirectory" bundle="exchange"/></span>
					<span class="help-block" data-ng-show="editExchangeGeneralInfoForm.jobResultDirectory.$error.pattern && cv.editExchangeGeneralInfoForm.needsAttention(editExchangeGeneralInfoForm.jobResultDirectory)"><cv:msg key="error.invalidNetworkPath" bundle="exchange"/></span>
					</div>
				</div>
				<div class="form-group min-height">
					<label class="col-xs-12 col-sm-5" for="jobResultsRetentionDays"><cv:msg key="label.jobResultsRetentionDays" bundle="exchange" /></label>
					<div class="col-xs-12 col-sm-7">
						<input type="number" min=0 required name="jobResultsRetentionDays"  data-ng-model="eExGenInfoCtrl.model.jobResultsRetentionDays"/>
						 <cv:msg key="label.days" bundle="exchange" />
					<span class="help-block" data-ng-show="cv.editExchangeGeneralInfoForm.needsAttention(editExchangeGeneralInfoForm.JobResultsRetentionDays)"><cv:msg key="error.invalidJobResultsRetentionDays" bundle="exchange"/></span>
					</div>
				</div>
			</div>
			</div>
			<div class="modal-footer">
				<button id="editExchangeGeneralInfo_button_#5020" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="eExGenInfoCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
				<button id="editExchangeGeneralInfo_button_#9995" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
			</div>
		</form>
	</div>
</div>
</span>
