<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div>
<div class="setup-title">
	<h1>{{title}}</h1>
</div>
<div class="setup-content addServerModal smaller-inputs" >
	<p class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
	<form name="addContentStoreMailboxForm" novalidate data-cv-submit="addContentStore()" autocomplete="off">
		<label><cv:msg key="label.displayName" bundle="exchange"/>
			<input type="text" name="name" data-ng-model="model.name" required autofocus/>
			<span class="help-block" data-ng-show="cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.name)"><cv:msg key="error.noName" bundle="exchange"/></span>
		</label>
		
		<label><cv:msg key="label.mailboxSMTPAddress" bundle="exchange"/>
			<input type="text" name="smtpAddress" data-ng-model="model.smtpAddress" required data-ng-pattern="emailPattern"/>
			<span class="help-block" data-ng-show="addContentStoreMailboxForm.smtpAddress.$error.required && cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.smtpAddress)"><cv:msg key="error.noSmtpAddress" bundle="exchange"/></span>
			<span class="help-block" data-ng-show="addContentStoreMailboxForm.smtpAddress.$error.pattern && cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.smtpAddress)"><cv:msg key="error.invalidSMTPAddress" bundle="exchange"/></span>
		</label>
		
		<label for="contentStoreServer"><cv:msg key="label.contentStoreMailServer" bundle="exchange"/>
			<div class="user-group-multi-select">
				<isteven-multi-select
		  				  input-model="clientList"
		  				  output-model="selectedClientList"
		 				  button-label="clientName"
						  item-label="clientName"
		  				  tick-property="selected"
		  				  class="isteven-multi-select user-group-select"
		  				  id="contentStoreServer"
		  				  name="contentStoreServer"
		  				  helper-elements="all none reset filter"
		  				  max-labels="2"
		  				  translation="localLang"
		  				  on-item-click="validateNodeSelection()"
		  				  on-select-none="validateNodeSelection()"
		  				  on-select-all="validateNodeSelection()"
		  				  on-reset="validateNodeSelection()">
				</isteven-multi-select>
				<span class="help-block" data-ng-show="showNodesErrorMessage "><cv:msg key="error.selectContentStoreServer" bundle="exchange"/></span>
			</div>
		</label>
		<label for="exchangePlan" class="select-label" ><cv:msg key="label.exchangePlan" bundle="exchange" />
			<select name="exchangePlan"data-ng-options="plan.planSummary.plan.planName for plan in exchangePlanList | orderBy: 'planSummary.plan.planName'" 
					data-ng-model="model.plan" required >
					<option value=""><cv:msg key="label.selectExchangePlan" bundle="exchange" /></option>
			</select>
			<span class="help-block" data-ng-show="cv.addContentStoreMailboxForm.needsAttention(addContentStoreMailboxForm.exchangePlan)"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
		</label>
		
		<div class="button-container">
			<button id="addContentStoreMailbox_button_#1833" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="addContentStoreMailbox_button_#1956" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>