<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.ediscovery">
<div id="previewNav" tabindex=0 data-ng-keydown="keyDown($event)" class="no-outline">
   <div class="setup-title ng-scope">
      <%-- This is for the preview used in request manager --%>
      <div class="row" data-ng-if="!readOnly">
         <div class="col-md-12">
            <span class="heading">
              {{taskType}}  -  {{selectedSingleRow.FileName}}
            </span>
            <span class="glyphicon glyphicon-ok margin-left-10 font-size-25" aria-hidden="true" data-ng-show="showAcceptStatusIcon" ></span>
            <span class="glyphicon glyphicon-ban-circle margin-left-10 font-size-25" aria-hidden="true" data-ng-show="showDeclineStatusIcon" ></span>		
         </div>
      </div>
      <%-- readOnly is for the preview used at places like review in data source --%>
      <div class="row" data-ng-if="readOnly">
         <div class="col-md-12">
            <span class="heading" data-ng-if="selectedSingleRow.FileName && dsType!=='dbanalysis'">
              {{selectedSingleRow.FileName}}
            </span>
            <span class="heading" data-ng-if="selectedSingleRow.ColumnName && dsType==='dbanalysis'">
              {{selectedSingleRow.ColumnName}}
            </span>
            <span class="heading crop" data-ng-if="selectedSingleRow.Subject">
              {{selectedSingleRow.Subject}}
            </span>
         </div>
      </div>
      <span class="serverMessage" data-ng-class="{{previewErrorMessage.type}}">{{previewErrorMessage.message}}</span>
   </div>
   <div class="row no-left-right-margin">
      <div class="col-md-9">
         <button id="taskPreview_button_#0295" class="mfp-arrow mfp-arrow-left button-left cvBusyOnAjax" data-ng-click='goPrevious()' ng-hide="disablePreviewPrevious"> 
         </button>
         <button id="taskPreview_button_#6073" class="mfp-arrow mfp-arrow-right button-right cvBusyOnAjax" data-ng-click='goNext()' ng-hide="disablePreviewNext"> 
         </button>				
           <cv-file-preview class="preview-content" cv-search-filter-request="cvSearchFilterRequest" is-loaded="isPreviewLoaded" email-response="emailResponse" content="previewContent" redaction-keywords="redaction.customKeywords" highlighter="highlightItem" mouseup="onRedactionTextSelection" highlighting-failed="previewHighlightingError" header="header"></cv-file-preview>
      </div>
      <div class="col-md-3 details-right-pane">
         <div class="row" data-ng-if="numSensitive.total>0 && isSensitive">
            <uib-accordion>
               <div uib-accordion-group is-open="true">
                  <uib-accordion-heading>
                     <div class="detail-header">
                        <h4 class="no-margin">
                           <span>
                              <cv:msg key="label.taskdetail.sensitivity" bundle="ediscovery" />
                           </span>
                           <span class="badge badge-wide pull-right">{{numSensitive.total}}</span>
                        </h4>
                     </div>
                  </uib-accordion-heading>
                  <div class="category-filter-buttons">
                     <label data-ng-show="numSensitive.critical>0" for="criticalSensitivity" class="btn btn-sm btn-risk risk-critical">
                        <img class="risk-icon" src="ediscovery/common/img/critical-risk-icon.svg"></img>
                        <span class="risk-btn-name">
                           <cv:msg key="label.taskDetail.critical" bundle="ediscovery" />
                        </span>
                        <input type="checkbox" data-ng-click="filterSensitivity(criticalSensitivity, 'critical')" data-ng-model="criticalSensitivity" id="criticalSensitivity" class="badgebox"><span class="risk-selected">&check;</span>
                     </label>
                     <label data-ng-show="numSensitive.high>0" for="highSensitivity" class="btn btn-sm btn-risk risk-high">
                        <img class="risk-icon" src="ediscovery/common/img/high-risk-icon.svg"></img>
                        <span class="risk-btn-name">
                           <cv:msg key="label.taskDetail.high" bundle="ediscovery" />
                        </span>
                        <input type="checkbox" id="highSensitivity" data-ng-click="filterSensitivity(highSensitivity, 'high')" data-ng-model="highSensitivity" class="badgebox"><span class="risk-selected">&check;</span>
                     </label>
                     <label data-ng-show="numSensitive.moderate>0" for="moderateSensitivity" class="btn btn-sm btn-risk risk-moderate">
                        <img class="risk-icon" src="ediscovery/common/img/moderate-risk-icon.svg"></img>
                        <span class="risk-btn-name">
                           <cv:msg key="label.taskDetail.moderate" bundle="ediscovery" />
                        </span>
                        <input type="checkbox" data-ng-click="filterSensitivity(moderateSensitivity, 'moderate')" data-ng-model="moderateSensitivity" id="moderateSensitivity" class="badgebox"><span class="risk-selected">&check;</span>
                     </label>
                  </div>
                  <uib-accordion class="text-left risk-category">
                     <div uib-accordion-group is-open="sensitivityObj.open" class="risk-type" data-ng-repeat="(sensitivityType, sensitivityObj) in sensitivityMap" data-ng-if="sensitivityObj.items.length>0 && sensitivityObj.isFiltered">
                        <uib-accordion-heading>
                           <span class="{{sensitivityObj.level}}"><img class="risk-icon" src="ediscovery/common/img/{{sensitivityObj.level}}-risk-icon.svg"></img>{{sensitivityObj.displayName}}</span>
                           <i class="pull-right glyphicon" ng-class="{'glyphicon-chevron-down': sensitivityObj.open, 'glyphicon-chevron-right': !sensitivityObj.open}"></i>
                           <span class="badge badge-wide pull-right">{{sensitivityObj.numItems}}</span>
                        </uib-accordion-heading>
                        <div class="-list">
                           <form name="{{sensitivityType}}-items">
                              <span class="alert-warning" data-ng-show="sensitivityObj.numItems>RESTRICT_NUM_ENTITIES">{{'info.listRestricted' | cvLoc : sensitivityObj.items.length : sensitivityObj.numItems}}</span>
                              <div class="checkbox" data-ng-repeat="item in sensitivityObj.items">
                                 <img class="sensitivity-icon" src="ediscovery/common/img/sensitivity-icons/{{sensitivityObj.icon}}.svg"></img>  <label data-ng-click="showHighlightText(item)" class="sensitivity-item-title" for="{{item.name + $index}}">{{item.name}}</label>
                              </div>
                           </form>
                        </div>
                     </div>
                  </uib-accordion>
                  <div class="error" data-ng-show="previewHighlightingError">{{ (redaction && redaction.enabled ? 'error.previewHighlightingRedaction' : (isEmailDataSource ? 'error.emailPreviewHighlighting' : 'error.previewHighlighting')) | cvLoc }}</div>
               </div>
            </uib-accordion>
            <hr>
             <%-- This is for the preview used in request manager --%>
            <div class="padding-left-15 padding-right-15" data-ng-if="$state.is('taskReview')">
               <cv-toggle-accordion data-ng-if="!redaction.hideToggle" click-header = "toggleRedactionMode()" accordion-label="label.enableRedaction" help-text="info.taskmanager.redactionHint" collapsed="redaction.enabled">
               <%-- <cv-toggle-accordion data-ng-if="!readOnly" toggle-label="{{'label.redaction' | cvLoc}}" toggle-name="enableRedaction" toggle-model="redaction.enabled" value="redaction.enabled"> --%>
                  <div class="form-group">
                     <div class="col-xs-12">
                        <div class="multiple-checkbox-group" data-ng-repeat="(sensitivityType, sensitivityObj) in sensitivityMap" data-ng-if="sensitivityObj.items.length>0">
                           <input id="{{sensitivityObj.name}}-checkbox" type="checkbox" ng-model="sensitivityObj.selected"/>
                           <label for="{{sensitivityObj.name}}-checkbox">{{sensitivityObj.displayName}}</label>
                        </div>
                     </div>
                  </div>
                  <div class="form-group">
                     <div class="col-xs-12 margin-bottom-15">
                        <tag-box editable="true" taglist='redaction.customKeywords' on-tag-added="onRedactionKeywordsChange"></tag-box>
                     </div>
                  </div>
                  <div class="form-group">
                     <button id="generateRedaction" class="btn btn-default btn-sm margin-left-15" data-ng-click="previewChange()" aria-label="Center Align"><cv:msg key="label.previewRedacted" bundle="ediscovery" /></button>
                  </div>
               </cv-toggle-accordion>
            </div>
         </div>
         <div data-ng-if="!readOnly" class="preview-comment-section" >
            <textarea id="declineReasonText" name="declineReasonText" class="preview-comment-text" data-ng-attr-placeholder="{{declinePlaceholderText}}" data-ng-model="taskPreview.commentReason" data-ng-model-options="{  debounce: { 'default': 0 } }"></textarea>
            <div style="margin-left: 95px;">
               <button id="taskPreview_button_#8433" class="btn btn-primary" data-ng-click="takeActionOnPreview(1, selectedSingleRow)" aria-label="Left Align"> 
                  <span class="glyphicon glyphicon-ok" aria-hidden="true"></span> 
                  <cv:msg key="label.taskpreview.accept" bundle="ediscovery" />
               </button>
               <button id="taskPreview_button_#6609" class="btn btn-primary" data-ng-click="takeActionOnPreview(0, selectedSingleRow)" aria-label="Left Align"> 
                  <span class="glyphicon glyphicon-ban-circle" aria-hidden="true"></span> 
                  <cv:msg key="label.taskpreview.decline" bundle="ediscovery" />
               </button>
            </div>
         </div>
      </div>
   </div>
</div>
</fmt:bundle>
