<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
   <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div>
   <h1 class="page-title">
      <span>{{taskInfoSummary}}</span>
   </h1>
   <div id="detailsArea">
      <div class="row">
         <div class="col-md-4">
            <cv-tile-component
               title="{{'label.taskDetail.information' | cvLoc }}">
               <div class="task-detail-info-box">
                  <ul class="list-style-secondary">
                     <li class="group" data-ng-repeat="item in informationItems track by $index"><span class="pageDetailColumn">{{item.label}}</span>
                        <span data-ng-if="item.isArray" class="pageDetailColumn">
                           <div class="task-details-fancy-tooltip wrap-cv-fancy-tooltip">
                              <cv-fancy-tooltip class="fancy-tooltip-no-break" cv-objects="item.value"></cv-fancy-tooltip>
                           </div>
                        </span>
                        <span data-ng-if="!item.isArray" class="pageDetailColumn">{{item.value}}</span>
                     </li>
                  </ul>
               </div>
            </cv-tile-component>
         </div>
         <div class="col-md-4">
            <cv-tile-component
               title="{{'label.taskDetail.entities' | cvLoc }}">
               <div class="task-detail-entity-box">
                  <ul class="list-style-secondary">
                     <li class="group" data-ng-repeat="item in entities"><span class="pageDetailColumn">{{item.label}}</span> <span
                        class="pageDetailColumn">{{item.value}}</span></li>
                  </ul>
               </div>
            </cv-tile-component>
         </div>
         <div class="col-md-4">
            <cv-tile-component
               title="{{'label.taskDetail.configuration' | cvLoc }}">
               <uib-tabset class="task-detail-tabs">
                  <uib-tab heading="{{ 'label.taskmanager.reviewers' | cvLoc }}">
                     <div class="users-list task-detail-tab-box">
                        <ul class="list-style-secondary">
                           <li class="group" data-ng-repeat="item in reviewers"><span class="user-type">
                              <label class="task-detail-user-label">{{item}}</label>
                              </span>
                           </li>
                        </ul>
                     </div>
                  </uib-tab>
                  <uib-tab heading="{{ 'label.taskmanager.approvers' | cvLoc }}">
                     <div class="users-list task-detail-tab-box">
                        <ul class="list-style-secondary">
                           <li class="group" data-ng-repeat="item in approvers"><span class="user-type">
                              <label class="task-detail-user-label">{{item}}</label>
                              </span>
                           </li>
                        </ul>
                     </div>
                  </uib-tab>
               </uib-tabset>
            </cv-tile-component>
         </div>
      </div>
      <div class="task-details-audit-table">
         <cv-grid cv-grid-options="gridOptions"></cv-grid>
      </div>
   </div>
</div>