<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
   <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
   <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
   <cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
   <div class="modal-header">
      <h1>
         <cv:msg key="label.taskmanager.configureTask" bundle="ediscovery" />
      </h1>
   </div>
   <div class="setup-content ediscovery-addasset-content task-manager-modal">
      <div class="panel panel-default">
         <div class="panel-body">
            <span class="{{serverMessage.type}} serverMessage" data-ng-bind="serverMessage.message"></span>
            <section>
               <form
                  name="addNewTaskForm"
                  novalidate
                  cv-hide-api
                  data-cv-submit="configureTaskSubmit()"
                  autocomplete="off"
                  class="edit-users-grid-form">
                  <div class="form-group">
                     <label class="col-xs-12 col-sm-3">
                        <cv:msg key="label.taskmanager.selectProject" bundle="ediscovery"/>
                     </label>
                     <div class="col-xs-11 col-sm-8">
                        <isteven-multi-select
                           input-model="clientList"
                           output-model="selectedClient"
                           button-label="clientName"
                           item-label="clientName"
                           tick-property="ticked"
                           class="isteven-multi-select"
                           selection-mode='multiple'
                           id="projectDropDown"
                           name="clientName"
                           max-labels="2"
                           translation="localLang"
                           search-property="clientName"
                           helper-elements="all filter reset"
                           on-item-click="clearOtherSelections(data)"
                           on-close="validateProject()"
                           search-limit="1">
                        </isteven-multi-select>
                     </div>
                     <div class="col-xs-1 col-sm-1 padding-top-12" data-ng-if="selectedClient.length === 1">
                        <a>
                            <span data-ng-click="openProjectDetailsModal()" class="glyphicon glyphicon-info-sign"></span>
                        </a>
                     </div>
                  </div>
                  <div class="form-group">
                     <div class="col-xs-12 col-sm-12">
                        <uib-tabset class="configure-task-tabs">
                           <uib-tab heading="<cv:msg key="label.taskmanager.reviewers" bundle="ediscovery" />
                           ">
                           <h4>
                              <cv:msg key="label.taskmanager.assignReviewers" bundle="ediscovery" />
                           </h4>
                           <div id="reviewersTab" class="no-top-margin">
                              <div class="group extra-top-padding">
                                 <div class="add-owner-users group">
                                    <input id="reviewerList">
                                 </div>
                              </div>
                              <div data-ng-if="(reviewerAssociations.usersList.length + reviewerAssociations.userGroupsList.length)===0"
                                 class="horz-center extra-top-padding">
                                 <cv:msg key="info.taskmanager.noReviewersAssigned" bundle="ediscovery" />
                              </div>
                              <div class="peopleInfos ownerInfo" data-ng-if="(reviewerAssociations.usersList.length + reviewerAssociations.userGroupsList.length) > 0">
                                 <div class="users-list limit-modal-height">
                                    <ul class="users-list__user group" data-ng-repeat="user in reviewerAssociations.usersList">
                                       <li>
                                          <span class="user-type">
                                          <label data-id="{{user.id}}" class="notify-user" data-ng-bind="user.name" title="{{user.name}}"></label>
                                          <span class="delete-row">
                                          <a href="" ng-click="removeReviewer(user, 'reviewerAssociations')" title="Delete {{user.name}}">&times;</a>
                                          </span>
                                          </span>
                                       </li>
                                    </ul>
                                    <ul class="users-list__user group" data-ng-repeat="userGroup in reviewerAssociations.userGroupsList">
                                       <li>
                                          <span class="group-type">
                                          <label data-id="{{userGroup.id}}" class="notify-user" data-ng-bind="userGroup.name" title="{{userGroup.name}}"></label>
                                          <span class="delete-row">
                                          <a href="" ng-click="removeReviewer(userGroup, 'reviewerAssociations')" title="Delete {{userGroup.name}}">&times;</a>
                                          </span>
                                          </span>
                                       </li>
                                    </ul>
                                 </div>
                              </div>
                           </div>
                           </uib-tab>
                           <uib-tab heading="<cv:msg key="label.taskmanager.approvers" bundle="ediscovery" />
                           ">
                           <h4>
                              <cv:msg key="label.taskmanager.assignApprovers" bundle="ediscovery" />
                           </h4>
                           <div id="approversTab" class="no-top-margin">
                              <div class="group extra-top-padding">
                                 <div class="add-owner-users group">
                                    <input id="approverList">
                                 </div>
                              </div>
                              <div data-ng-if="(approverAssociations.usersList.length + approverAssociations.userGroupsList.length)===0" class="horz-center extra-top-padding">
                                 <cv:msg key="info.taskmanager.noApproversAssigned" bundle="ediscovery" />
                              </div>
                              <div class="peopleInfos ownerInfo" data-ng-if="(approverAssociations.usersList.length + approverAssociations.userGroupsList.length) > 0">
                                 <div class="users-list limit-modal-height">
                                    <ul class="users-list__user group" data-ng-repeat="user in approverAssociations.usersList">
                                       <li><span class="user-type">
                                          <label data-id="{{user.id}}" class="notify-user" data-ng-bind="user.name" title="{{user.name}}"></label>
                                          <span class="delete-row">
                                          <a href="" ng-click="removeReviewer(user, 'approverAssociations')" title="Delete {{user.name}}">&times;</a>
                                          </span>
                                          </span>
                                       </li>
                                    </ul>
                                    <ul class="users-list__user group" data-ng-repeat="userGroup in approverAssociations.userGroupsList">
                                       <li>
                                          <span class="group-type">
                                          <label data-id="{{userGroup.id}}" class="notify-user" data-ng-bind="userGroup.name" title="{{userGroup.name}}"></label>
                                          <span class="delete-row">
                                          <a href="" ng-click="removeReviewer(userGroup, 'approverAssociations')" title="Delete {{userGroup.name}}">&times;</a>
                                          </span>
                                          </span>
                                       </li>
                                    </ul>
                                 </div>
                              </div>
                           </div>
                           </uib-tab>
                        </uib-tabset>
                     </div>
                  </div>
                  <div class="modal-footer">
                     <button
                        id="assignReviewers_button_#6311"
                        type="button"
                        class="btn btn-default cvBusyOnAjax setup-btn--hidden"
                        data-ng-click="cancel()">
                        <cv:msg key="Cancel" bundle="messages" />
                     </button>
                     <button
                        id="assignReviewers_button_#6302"
                        type="submit"
                        class="btn btn-primary cvBusyOnAjax">
                        <cv:msg key="Save" bundle="messages" />
                     </button>
                  </div>
               </form>
            </section>
         </div>
      </div>
   </div>
</div>

