<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.taskmanager.add" bundle="ediscovery" />
	</h1>
</div>
<div class="setup-content bootstrap-wrapper task-manager-modal">
	<span class="{{AddTaskCtrl.serverMessage.type}} serverMessage"
		data-ng-bind="AddTaskCtrl.serverMessage.message"></span>
	<form name="addNewTaskForm" cv-hide-api data-cv-submit="AddTaskCtrl.addNewTask()" autocomplete="off" class="form-horizontal">
		<div class="panel task-users-tabs">
			<div class="panel-body">
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="taskname"><cv:msg key="label.name" bundle="ediscovery"/></label>
				     <div class="col-xs-12 col-md-7 col-lg-7">
				            <input type="text" id="taskname" name="taskname" data-ng-model="AddTaskCtrl.selectedTaskName" required autofocus data-ng-pattern="/^[A-Za-z0-9_\- ]*$/" data-ng-maxlength="50" data-ng-class="{'has-error': cv.addNewTaskForm.needsAttention(addNewTaskForm.taskname)}"/>
				     </div>
				     <div class="col-md-7 col-lg-7 col-md-offset-5 col-lg-offset-5">
						<span class="help-block" data-ng-if="addNewTaskForm.taskname.$error.pattern">
							<cv:msg key="error.invalidName" bundle="ediscovery" />
						</span>
						<span class="help-block" data-ng-if="addNewTaskForm.taskname.$error.maxlength">
							<cv:msg key="error.maxlength" bundle="ediscovery" />
						</span>	
					</div>
				</div>
				 <div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="radioInput"><cv:msg key="label.type" bundle="ediscovery"/></label> 
				    <div class="col-xs-12 col-md-7 col-lg-7 ">
				    	<div class="task-radio-type">
							<div class="radio">
								<label><input name="radioInput" type="radio" data-ng-model="AddTaskCtrl.taskType" value="export"><cv:msg key="label.taskmanager.type.export" bundle="ediscovery" /></label>
							</div>
							<div class="radio">
								<label><input name="radioInput" type="radio" data-ng-model="AddTaskCtrl.taskType" value="delete"><cv:msg key="label.taskmanager.type.delete" bundle="ediscovery" /></label>
							</div>
						</div>
						<div data-ng-show="AddTaskCtrl.taskType === 'delete'">
                            <input id="deleteFromBackup" data-ng-model="AddTaskCtrl.deleteFromBackup" type="checkbox">
							<label for="deleteFromBackup"><cv:msg key="label.deleteFromBackup" bundle="ediscovery" /></label>
                        </div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="redactionMode">
						<cv-help-text help-label="<cv:msg key='label.redaction' bundle='ediscovery'/>" help-text="'<cv:msg key='info.taskmanager.redactionHint' bundle='ediscovery'/>'" />
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7 margin-top-5">
						<toggle-control id="redactionMode" ng-class="{{AddTaskCtrl.redaction.className}}" status="AddTaskCtrl.redaction.className" data-ng-click="AddTaskCtrl.toggleRedaction()" title="Enable/disable" disabled="AddTaskCtrl.taskType=='delete'"></toggle-control>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="extendedEntitySearch">
						<cv-help-text help-label="<cv:msg key='label.taskmanager.extendedEntitySearch' bundle='ediscovery'/>" help-text="'<cv:msg key='info.taskmanager.extendedEntitySearch' bundle='ediscovery'/>'" />
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7 margin-top-5">
						<toggle-control id="extendedEntitySearch" ng-class="{{AddTaskCtrl.extendedEntitySearch.className}}" status="AddTaskCtrl.extendedEntitySearch.className" data-ng-click="AddTaskCtrl.toggleExtendedEntitySearch()" title="Enable/disable"></toggle-control>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="userEmail"><cv:msg key="label.taskmanager.custodian.email" bundle="ediscovery" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7 ">
						<input type="email" id="userEmail" name="userEmail"
							data-ng-model="AddTaskCtrl.selectedEmail" placeholder='<cv:msg key="label.enter" bundle="ediscovery" /> <cv:msg key="label.taskmanager.custodian.email" bundle="ediscovery" />' data-ng-class="{'has-error': cv.addNewTaskForm.needsAttention(addNewTaskForm.userEmail)}" required />
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="addTaskMultiSelect"><cv:msg key="label.taskmanager.selectEntities" bundle="ediscovery" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7 ">
						<isteven-multi-select input-model="AddTaskCtrl.entities"
							output-model="AddTaskCtrl.selectedEntities" button-label="displayName"
							item-label="displayName" tick-property="ticked"
											on-reset="AddTaskCtrl.reset()"
											class="isteven-multi-select user-group-select"
							id="addTaskMultiSelect" name="addTaskMultiSelect"
							on-item-click="AddTaskCtrl.addEntityInput(data)" helper-elements="filter"
							translation="AddTaskCtrl.entitiesText">
						</isteven-multi-select>
					</div>
				</div>
				<hr ng-show="AddTaskCtrl.selectedEntities.length>0">
				<div class="form-group" ng-repeat="entity in AddTaskCtrl.inputEntities track by $index">
					<label data-ng-if="!entity.hidden" class="col-xs-12 col-md-5 col-lg-5" for="{{entity.entityName}}">{{entity.displayName}}</label>
					<div data-ng-if="!entity.hidden" class="col-xs-12 col-md-7 col-lg-7 ">
						<span class="task-input-dynamic"
							ng-repeat="entityInput in AddTaskCtrl.entityInputObject[entity.entityName] track by $index">
							<span ng-click="AddTaskCtrl.updateAdditionalInput(entity, $index, $index === 0)"
							data-ng-class="['btn', 'btn-default', 'icon', 'task-input-dynamic-btn', 'pull-right', {'ion-plus': $index === 0}, {'ion-minus': $index !== 0}]"
							type="button"></span> <input type="{{entity.validator.type}}"
							id="{{entity.entityName}}" name="{{entity.entityName}}"
							data-ng-model="AddTaskCtrl.entityInputObject[entity.entityName][$index]"
							placeholder='<cv:msg key="label.enter" bundle="ediscovery" /> {{entity.displayName}}'
							data-ng-required="entity.entityType != 4" data-ng-disabled="entity.entityType == 4" />
						</span>
					</div>
				</div>
				<div class="modal-footer">
					<fmt:bundle basename="localization.messages">
						<button id="addTaskModal_button_#6322" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="AddTaskCtrl.cancel()"><cv:msg key="Cancel" /></button> 
						<button id="addTaskModal_button_#8389"  type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" /></button> 
					</fmt:bundle>
				</div>
			</div>
		</div>
	</form>
</div>