<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<form name="step1" novalidate autocomplete="off" data-cv-submit="">
    <div class="">
        <div class="form-horizontal bootstrap-wrapper">
            <div class="{{model.col}}">
                <div class="panel panel-default no-border">
                    <div class="panel-body">
                        <h4 data-ng-if="model.targetApp !== model.serviceTypes.Analytics">
                            <cv:msg key="label.casemanager.general" bundle="ediscovery"/>
                        </h4>
                        <div data-ng-class="{'col-xs-12 col-md-9 col-lg-10 col-lg-offset-1': model.targetApp !== model.serviceTypes.Analytics }">
                            <div class="form-group">
                                <label class="col-xs-12 col-md-3 col-lg-3 padding-top-5" for="planName">
                                    <cv:msg key="label.profileName" bundle="profiles" />
                                </label>
                                <div class="col-xs-12 col-md-9 col-lg-9">
                                    <input type="text" name="planName"
                                        autofocus required
                                        data-ng-class="{'has-error': cv.step1.needsAttention(step1.planName)}"
                                        data-ng-model="model.planInfo.summary.plan.planName"
                                        data-ng-click="model.invalidPlanName=false"
                                        id="planName" />
                                    <span class="help-block" data-ng-show="cv.step1.needsAttention(step1.planName)">
                                        <i class="ion-alert-circled"></i>
                                        <cv:msg key="error.noProfileName" bundle="profiles" />
                                    </span>
                                    <span class="help-block" data-ng-if="model.invalidPlanName">
                                        <i class="ion-alert-circled"></i>
                                        <cv:msg key="error.nameExisted" bundle="profiles" />
                                    </span>
                                </div>
                            </div>
                            <cv-plan-dcpolicy-general
                                plan-options="model.planInfo.options"
                                ediscovery-info="model.planInfo.eDiscoveryInfo"
                                target-application="{{model.targetApp}}">
                            </cv-plan-dcpolicy-general>
                        </div>
                        <div data-ng-if="model.config[model.targetApp].entityDetection.display">
                            <h4 class="col-xs-12 no-padding padding-top-20"><cv:msg key="label.entityDetection" bundle="ediscovery"/></h4>
                            <div class="col-xs-12 col-md-9 col-lg-10 col-lg-offset-1">
                                <div class="form-group">
                                    <div class="col-lg-12">
                                        <cv-plan-ee-policy
                                            ee-policy="model.planInfo.eePolicy"
                                            ediscovery-info="model.planInfo.eDiscoveryInfo"
                                            ci-policy="model.planInfo.ciPolicy"
                                            hide-e-e-check-box="true">
                                        </cv-plan-ee-policy>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div data-ng-if="enableDCPlanSchedule && model.targetApp === model.serviceTypes.Analytics" class="padding-top-50">
                            <cv-plain-accordion accordion-label="label.dcPlanFilters" class="row">
                                <div class="col-xs-12 padding-top-20">
                                    <h4>
                                        <cv:msg key="label.contentIndexing" bundle="ediscovery"/>
                                    </h4>
                                </div>
                                <div class="col-xs-12">
                                    <cv-plan-ci-policy target-app="model.targetApp" schedule="model.planInfo.schedule"></cv-plan-ci-policy>
                                </div>
                            </cv-plain-accordion>
                        </div>
                        <div data-ng-if="enableDCPlanSchedule && model.targetApp === model.serviceTypes.FileSystem" class="col-xs-12 col-md-9 col-lg-10 col-lg-offset-1 padding-top-30">
                            <label class="col-xs-12 col-lg-3 col-md-3 padding-left-0 no-margin"><cv:msg key="label.schedule" bundle="ediscovery" /></label>
                            <div class="col-xs-12 col-lg-8 col-md-8 padding-left-10">
                                <schedule entity-type="'PLAN_ENTITY'" on-save="updateSchedule(schedule, successCallback, errorCallback)" schedule-obj="model.planInfo.schedule"
                                    entity-sub-type="model.targetApp"></schedule>
                            </div>
                            <div class="col-xs-12 col-lg-9 col-md-9 col-lg-offset-3 col-md-offset-3 padding-left-10 padding-top-5" data-ng-if="step1.$submitted && scheduleRequiredError">
                                <span class="error font-size-12">
                                    <i class="ion-alert-circled"></i>
                                    <cv:msg key="error.noSchedulesConfigured" bundle="profiles" />
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="cv-wizard-default-actions add-alert-wizard-actions row">
        <div class="col-xs-12">
            <div class="col-xs-3 col-xs-offset-6 col-md-2 col-md-offset-8">
                <cv-wizard-button data-ng-if="model.planInModal" data-cv-type="cancel" data-ng-click="$dismiss()" >
                </cv-wizard-button>
            </div>
            <div class="col-xs-3 col-md-2">
                <cv-wizard-button data-ng-if="model.targetApp !== model.serviceTypes.Analytics" data-cv-type="next">
                </cv-wizard-button>
                <cv-wizard-button data-ng-if="model.targetApp === model.serviceTypes.Analytics" data-cv-type="finish" data-cv-label="<cv:msg key='action.save' bundle='ediscovery' />">
                </cv-wizard-button>
            </div>
        </div>
    </div>
</form>
