<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.userPermissions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="permissions-filter-details-wrapper modal-dialog">
	<div class="modal-content">
		<div class="modal-header ng-scope">
			<h4><cv:msg key="label.filters" bundle="userPermissions" /></h4>
		</div>
		<div class="permissions-filter-container">
			<div class="permissions-filter-nav">
					<ul class="nav nav-pills">
	        			<li data-ng-click="permFltCtrl.showFilterContent('users')" data-ng-class="{selected:permFltCtrl.selectedFilter == 'users'}">
	        				<a>
	        					<cv:msg key="label.users" bundle="userPermissions" />
	        				</a>
	        			</li>
	        			<li data-ng-click="permFltCtrl.showFilterContent('owners')" data-ng-class="{selected:permFltCtrl.selectedFilter == 'owners'}">
	        				<a>
	        					<cv:msg key="label.owners" bundle="userPermissions" />
	        				</a>
	        			</li>
	        			<li data-ng-click="permFltCtrl.showFilterContent('extensions')" data-ng-class="{selected:permFltCtrl.selectedFilter == 'extensions'}">
	        				<a>
	        					<cv:msg key="label.extensions" bundle="userPermissions" />
	        				</a>
	        			</li>
	        			<li data-ng-click="permFltCtrl.showFilterContent('sensitiveTags')" data-ng-class="{selected:permFltCtrl.selectedFilter == 'sensitiveTags'}">
	        				<a>
	        					<cv:msg key="message.sensitiveTags" bundle="userPermissions" />
	        				</a>
	        			</li>
	      			</ul>
			</div>
			<div class="permissions-filter-content">
				<div class="user-filter-container" data-ng-if="permFltCtrl.selectedFilter == 'users'">
					<div class="permission-filters-select-btn-panel">
							<button class="btn-primary" data-ng-click="permFltCtrl.clearAllUsers()"><cv:msg key="label.clearAll" bundle="userPermissions" /></button>
					</div>
					<cv-select-2 output-model="permFltCtrl.selectedUserFilter" search-options="permFltCtrl.userFilterConfig"></cv-select-2>
					<div class="user-filter-tags-container">
						<cv-permissions-filter-tags tags-list="permFltCtrl.selectedUsersList" on-tag-removed="permFltCtrl.unSelectUser(val)"></cv-permissions-filter-tags>
					</div>
				</div>

				<div data-ng-if="permFltCtrl.selectedFilter == 'owners'">
					<cv-multi-select-panel input-list="permFltCtrl.ownersList" output-list="permFltCtrl.selectedOwnersList" name='<cv:msg key="label.owners" bundle="userPermissions" />'/>
				</div>

				<div data-ng-if="permFltCtrl.selectedFilter == 'extensions'">
					<div data-ng-if="permFltCtrl.extensionsList && permFltCtrl.extensionsList.length>0">
						<div class="permission-filters-select-btn-panel">
							<button class="btn-primary"  data-ng-click="permFltCtrl.selectAll('extensions')"><cv:msg key="label.selectAll" bundle="userPermissions" /></button>
							<button class="btn-primary"  data-ng-click="permFltCtrl.selectNone('extensions')"><cv:msg key="label.selectNone" bundle="userPermissions" /></button>
						</div>
						<div class="permission-filters-checkbox-group-wrapper">
							<div class="permission-filters-checkbox-group" data-ng-repeat="ext in permFltCtrl.extensionsList">
								<input id="{{ext.name}}" class="" type="checkbox" data-ng-model="ext.selected"/>
								<label for="{{ext.name}}">{{ext.name}}</label>
							</div>
						</div>
						<div class="permission-filters-noExtensions">
							<cv-toggle toggle-name="permission-filter-no-extension-toggle" toggle-label="<cv:msg key="label.filter.filesWithNoExtensions" bundle="userPermissions" />" toggle-model="permFltCtrl.filterNoExtensions" value="permFltCtrl.filterNoExtensions" on-click="permFltCtrl.toggleFilterNoExtensions()"></cv-toggle>
						</div>
					</div>
					<div class="permissions-filter-no-data" data-ng-if="!permFltCtrl.extensionsList || permFltCtrl.extensionsList.length==0">
						<h4><cv:msg key="message.noDataAvailable" bundle="userPermissions" /></h4>
					</div>
				</div>

				<div data-ng-if="permFltCtrl.selectedFilter == 'sensitiveTags'">
					<div class="permissions-filter-no-data" data-ng-if="!permFltCtrl.sensitiveTagsList || permFltCtrl.sensitiveTagsList.length==0">
							<h4><cv:msg key="message.noDataAvailable" bundle="userPermissions" /></h4>
					</div>
					<div data-ng-if="permFltCtrl.sensitiveTagsList && permFltCtrl.sensitiveTagsList.length>0">
						<div class="permission-filters-select-btn-panel">
								<button class="btn-primary"  data-ng-click="permFltCtrl.selectAll('sensitiveTags')"><cv:msg key="label.selectAll" bundle="userPermissions" /></button>
								<button class="btn-primary"  data-ng-click="permFltCtrl.selectNone('sensitiveTags')"><cv:msg key="label.selectNone" bundle="userPermissions" /></button>
						</div>
						<div class="permission-filters-checkbox-group-wrapper">
							<div class="permission-filters-checkbox-group" data-ng-repeat="ext in permFltCtrl.sensitiveTagsList">
								<input id="{{ext.name}}" class="" type="checkbox" data-ng-model="ext.selected"/>
								<label for="{{ext.name}}">{{ext.name}}</label>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer button-container">
				<button class="btn btn-default cvBusyOnAjax" data-ng-click="permFltCtrl.cancel()"><cv:msg key="label.cancel" bundle="userPermissions" /></button>
	        	<button class="btn btn-primary cvBusyOnAjax" data-ng-click="permFltCtrl.apply()"><cv:msg key="label.apply" bundle="userPermissions" /></button>
	    	</div>
		</div>
	</div>
</div>