<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.userPermissions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>

<div class="permissions-filter-wrapper">
	<div data-ng-if="permFltCtrl.showFilters" class="show-filters-link-wrapper">
		<h4>
			<cv:msg key="label.filters" bundle="userPermissions" />
		</h4>
		<div class="filters-options">
			<a title='<cv:msg key="title.Add" bundle="userPermissions" />' data-ng-click="permFltCtrl.addFiltersFn()" data-ng-if="!permFltCtrl.editFilters">
				<cv:msg key="title.Add" bundle="userPermissions" />
			</a>
			<a title='<cv:msg key="title.Add" bundle="userPermissions" />' data-ng-click="permFltCtrl.addFiltersFn()" data-ng-if="permFltCtrl.editFilters">
				<cv:msg key="label.edit" bundle="userPermissions" />
			</a>
			<a title='<cv:msg key="label.clearFilters" bundle="userPermissions" />' data-ng-if="permFltCtrl.editFilters" data-ng-click="permFltCtrl.clearAll()">
				<cv:msg key="label.clearAll" bundle="userPermissions" />
			</a>
		</div>
	</div>
	<div class="filter-summary" data-ng-if="permFltCtrl.editFilters">
			<div class="filter-details-container row" data-ng-if="permFltCtrl.filters.users && permFltCtrl.filters.users.length > 0">
				<label class="col-lg-1 col-md-2"><cv:msg key="label.users" bundle="userPermissions" /></label>
				<cv-permissions-filter-tags tags-list="permFltCtrl.filters.users" on-tag-removed="permFltCtrl.removeUser(val)"></cv-permissions-filter-tags>
			</div>
			<div class="filter-details-container row" data-ng-if="permFltCtrl.filters.owners && permFltCtrl.filters.owners.length > 0">
				<label class="col-lg-1 col-md-2"><cv:msg key="label.owners" bundle="userPermissions" /></label>
				<cv-permissions-filter-tags tags-list="permFltCtrl.filters.owners" on-tag-removed="permFltCtrl.removeOwner(val)"></cv-permissions-filter-tags>
			</div>
			<div class="filter-details-container row" data-ng-if="permFltCtrl.filters.extensions && permFltCtrl.filters.extensions.length > 0">
				<label class="col-lg-1 col-md-2"><cv:msg key="label.extensions" bundle="userPermissions" /></label>
				<cv-permissions-filter-tags tags-list="permFltCtrl.filters.extensions" on-tag-removed="permFltCtrl.removeExtensions(val)"></cv-permissions-filter-tags>
			</div>
			<div class="filter-details-container row" data-ng-if="permFltCtrl.filters && permFltCtrl.filters.includeFilesWithNoExtension">
				<div class="noFileExtensions">
					<cv-toggle toggle-name="permission-filter-no-extension-toggle" toggle-label="<cv:msg key="label.filter.filesWithNoExtensions" bundle="userPermissions" />" value="permFltCtrl.filters.includeFilesWithNoExtension" on-click="permFltCtrl.toggleFilterNoExtensions(data)"></cv-toggle>
				</div>
			</div>
			<div class="filter-details-container row" data-ng-if="permFltCtrl.filters.sensitiveTags && permFltCtrl.filters.sensitiveTags.length > 0">
				<label class="col-lg-1 col-md-2"><cv:msg key="message.sensitiveTags" bundle="userPermissions" /></label>
				<cv-permissions-filter-tags tags-list="permFltCtrl.filters.sensitiveTags" on-tag-removed="permFltCtrl.removeSensitiveTags(val)"></cv-permissions-filter-tags>
			</div>
			<div class="filter-details-container filter-details-no-extensions row" data-ng-if="permCtrl.filesWithNoExtensions">
				<label class="col-lg-3"><cv:msg key="message.filter.filesWithNoExtensions" bundle="userPermissions" /></label>
			</div>
	</div>
</div>
