
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div ng-controller="fileServerAssetsController as fsAsset">
    <div>
        <h1 class="page-title">{{fsAsset.model.name}}</h1>
    </div>
    <div id="detailsArea">
        <div class="row">
            <div class="col-md-6">
                <cv-tile-component data-ac-id="datasourceDetails-label_details-ediscovery" title='<cv:msg key="label.details" bundle="ediscovery"/>'>
                    <ul class="list-style-secondary">
                        <li class="group">
                            <span class="pageDetailColumn"><cv:msg key="label.type" bundle="ediscovery" /></span>
                            <span class="pageDetailColumn"><cv:msg key="label.assets.type.FILE_ENTITY" bundle="ediscovery" /></span>
                        </li>
                        <li class="group">
                            <span class="pageDetailColumn"><cv:msg key="entities.location" bundle="ediscovery" /></span>
                            <span class="pageDetailColumn">{{fsAsset.model.location}}</span>
                        </li>
                    </ul>
                </cv-tile-component>
            </div>
            <div class="col-md-6">
                <cv-tile-component data-ac-id="datasourceDetails-label_configuration-ediscovery" title='<cv:msg key="label.configuration" bundle="ediscovery"/>'>
                    <ul class="list-style-secondary">
                        <li class="group" ng-repeat="property in fsAsset.model.properties">
                            <span class="pageDetailColumn">{{property.label}}</span>
                            <span class="pageDetailColumn">{{property.propertyValue}}</span>
                        </li>
                    </ul>
                </cv-tile-component>
            </div>
        </div>
    </div>
</div>