<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.assets.database.sqlQueryAndPreview"
			bundle="ediscovery" />
	</h1>
</div>
<div class="setup-content">
	<div class="{{generalSetupMessage.type}} serverMessage">{{generalSetupMessage.message}}</div>
</div>
<div
	class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2 bootstrap-wrapper">
	<div class="row ng-scope">
		<div class="col-md-12">
			<div class="panel panel-default">
				<div class="panel-body">
					<div class="form-horizontal">
						<div class="form-group">
							<label class="col-xs-12 col-md-3 col-lg-3" for="selectTable"><cv:msg
									key="label.assets.database.table" bundle="ediscovery" /> </label>
							<div class="col-xs-12 col-md-9 col-lg-9"
								data-ng-if="databaseAssetInfo.tableList">
								<isteven-multi-select input-model="databaseAssetInfo.tableList" output-model="databaseAssetInfo.selectedTableName"
									button-label="tableName" item-label="tableName"
									tick-property="ticked"
									class="isteven-multi-select user-group-select" id="selectTable"
									name="selectTable" helper-elements="filter"
									max-labels="1" translation="selectTableText"
									disable-property="disabled"
									on-item-click="onTableSelect(data)"
									selection-mode="single"
									on-reset="validateGroupSelection()"> </isteven-multi-select>
							</div>
						</div>
					</div>
					<div class="form-horizontal">
						<div class="form-group">
							<label class="col-xs-12 col-md-3 col-lg-3" for="selectTable"><cv:msg
									key="label.assets.database.sqlQuery" bundle="ediscovery" /></label>
							<div class="col-xs-12 col-md-9 col-lg-9">
								<textarea ng-model="databaseAssetInfo.sqlQuery"
									ng-required="string" class="textarea" rows="5"></textarea>
							</div>
						</div>
					</div>
					<div class="form-horizontal" data-ng-if="databaseAssetInfo.queryPreviewInfo">
						<div class="form-group">
							<label class="col-xs-12 col-md-3 col-lg-3" for="primaryKey"><cv:msg
									key="label.assets.database.primaryKey" bundle="ediscovery" /></label>
							<div class="col-xs-12 col-md-9 col-lg-9" >
								<isteven-multi-select input-model="databaseAssetInfo.queryPreviewInfo.columnNames" output-model="databaseAssetInfo.primaryKey"
									button-label="columnName" item-label="columnName"
									tick-property="ticked"
									class="isteven-multi-select user-group-select" id="primaryKey"
									name="primaryKey" helper-elements="filter"
									max-labels="1" translation="selectColumnsText"
									disable-property="disabled"
									selection-mode="single"> </isteven-multi-select>
							</div>
						</div>
					</div>
					<div class="pull-right">
						<button id="sqlQueryDatabaseAsset_button_#3789" type="button" data-ng-click="sqlQueryPreview()" 
							class="btn btn-sm btn-default cvBusyOnAjax">
							<cv:msg key="label.preview" bundle="ediscovery" />
						</button>												
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="row ng-scope" >
		<div class="col-md-12">
			<cv-tile-component data-ng-if="databaseAssetInfo.queryPreviewInfo.columnNames.length>0"
				data-title='<cv:msg key="label.assets.database.queryPreview" bundle="ediscovery"/>'>
			<div class="panel panel-default no-border">
				<div class="panel-body">
					<div class="form-group">
						<div class="component-container">
							<cv-grid cv-grid-options="previewGridOptions"></cv-grid>
						</div>
					</div>
				</div>
			</div>
			</cv-tile-component>
		</div>
	</div>
</div>
<!-- // end  bootstrap-wrapper // -->
<div class="button-container">
	<button id="sqlQueryDatabaseAsset_button_#5967" type="button" data-ng-click="goPreviousStep()" 
		class="btn btn-primary cvBusyOnAjax">
		<cv:msg key="label.previous" bundle="ediscovery" />
	</button>
	<button id="submitForCreatePool" type="button"
		data-ng-click="saveSqlQueryTab()"
		class="btn btn-primary cvBusyOnAjax">
		<cv:msg key="label.finish" bundle="ediscovery" />
	</button>
</div>