<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.inventorymanager.add" bundle="ediscovery" />
	</h1>
</div>
<div class="setup-content">
	<span class="{{serverMessage.type}} serverMessage"
		data-ng-bind="serverMessage.message"></span>
	<section>
		<form name="addInventoryForm"
			cv-hide-api
			data-cv-submit="createInventory()" autocomplete="off"
			class="edit-users-grid-form">
			<div class="global-options remove-border-padding">
				<label for="name" class="row">
					<span class="col-xs-4"><cv:msg key="label.name" bundle="collections" /></span>
					<div class="col-xs-8 padding-left-0">
						<input type="text" id="name" name="name"
							data-ng-model="selectedInventoryName" required autofocus data-ng-pattern="/^[A-Za-z0-9_\- ]*$/" ng-maxlength="50"
							data-ng-class="{'has-error': cv.addInventoryForm.needsAttention(addInventoryForm.name)}" class="full-width" />
						<span class="help-block" data-ng-show="addInventoryForm.name.$error.pattern || addInventoryForm.name.$error.maxlength">
							{{addInventoryForm.name.$error.maxlength ? '<cv:msg key="error.maxlength" bundle="ediscovery" />' : '<cv:msg key="error.invalidName" bundle="ediscovery" />'}}
						</span>
					</div>
				</label>
			</div>
			<div class="global-options remove-border-padding">
				<label for="indexServers" class="row">
					<span class="col-xs-4"><cv:msg key="label.analyticsEngine" bundle="ediscovery" /></span>
					<div class="col-xs-8 padding-left-0">
						<isteven-multi-select
									input-model="indexServers"
									output-model="selectedIndexServers"
									button-label="indexServerClientName"
									item-label="indexServerClientName"
									tick-property="ticked"
									selection-mode="single"
									class="isteven-multi-select user-group-select"
									directive-id="indexServer"
									helper-elements="all none reset filter"
									max-labels="1"
									disable-property="disabled">
						</isteven-multi-select>
						<span class="help-block" data-ng-if="showIndexServerError"><cv:msg key="error.selectAnalyticsEngine" bundle="ediscovery"/></span>
					</div>
				</label>
			</div>
			<div class="global-options remove-border-padding">
				<label for="nameServer" class="row">
					<span class="col-xs-4"><cv:msg key="label.assets.nameserver" bundle="ediscovery"/></span>
					<div class="col-xs-8 padding-left-0">
						<isteven-multi-select
									input-model="nameServers"
									output-model="selectedNameServers"
									button-label="connectName"
									item-label="connectName"
									tick-property="ticked"
									class="isteven-multi-select user-group-select"
									directive-id="nameServer"
									helper-elements="all none reset filter"
									max-labels="1"
									translation="nameServerText"
									disable-property="disabled">
						</isteven-multi-select>
					</div>
				</label>
			</div>
			<div class="button-container">
					<button id="addInventoryModal_button_#6376" type="button"
						class="btn btn-default cvBusyOnAjax setup-btn--hidden"
						data-ng-click="cancel()">
						<cv:msg key="Cancel" bundle="messages" />
					</button>
					<button id="addInventoryModal_button_#9466" type="submit" class="btn btn-primary cvBusyOnAjax">
						<cv:msg key="Save" bundle="messages" />
					</button>
			</div>
		</form>
	</section>
</div>
