<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="setup-title">
    <h1>
		<span>
			<cv:msg key="label.update.applications" bundle="ediscovery"/>
		</span>
	</h1>
</div>
<form name="updateApplicationsForm" cv-hide-api data-cv-submit="uaCtlr.updateApplications()" autocomplete="off" novalidate class="bootstrap-wrapper form-horizontal">
	<div class="modal-body">
		<div class="form-group margin-top-10">
			<label class="col-lg-2 margin-left-0 line-height-initial" for="applications">
				<cv:msg key="label.applications" bundle="ediscovery" />
			</label>
			<div  class="col-lg-10">
				<isteven-multi-select
					input-model="uaCtlr.applications"
					output-model="uaCtlr.selectedApplications"
					button-label="displayName"
					item-label="displayName"
					tick-property="selected"
					selection-mode="multiple"
					class="isteven-multi-select user-group-select"
					helper-elements="all none filter"
					max-labels="3"
					translation="uaCtlr.localLang"
					group-property="appGroup"
					on-close="uaCtlr.onApplicationsSelection()">
				</isteven-multi-select>
				<input type="text" ng-model="uaCtlr.selectedApplications" class="display-none" name="applications" required />
				<span class="help-block" data-ng-show="updateApplicationsForm.$submitted && updateApplicationsForm.applications.$error.required">
					<cv:msg key="error.applications" bundle="ediscovery"/>
				</span>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="$dismiss()">
	    	<cv:msg key="Cancel" bundle="messages" />
	    </button>
        <button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="!uaCtlr.allowUpdate">
        	<cv:msg key="label.update" bundle="ediscovery" />
        </button>
    </div>
</form>