<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="setup-title">
    <h1>
		<span data-ng-if="!enCtlr.isReconfigure">
			<cv:msg key="label.edit.nodes" bundle="ediscovery"/>
		</span>
		<span data-ng-if="enCtlr.isReconfigure">
			<cv:msg key="label.reconfigure" bundle="ediscovery"/>
		</span>
	</h1>
</div>
<div class="setup-content">
	<section>
		<form name="editNodeForm" cv-hide-api data-cv-submit="enCtlr.saveNode()" autocomplete="off" novalidate class="bootstrap-wrapper form-horizontal">
			<div class="form-group" data-ng-if="enCtlr.errorMessage">
				<div class="text-align-center">
					<span class="server-message error" data-ng-bind="enCtlr.errorMessage">
					</span>
				</div>
			</div>
			<label class="form-group no-margin" for="name">
        		<span class="col-xs-4">
        			<cv:msg key="label.name" bundle="ediscovery"/>
        		</span>
		        <div class="col-xs-8 padding-left-0">
		            <input class="full-width" type="text" id="name" name="name" data-ng-model="enCtlr.selectedNode.displayName" disabled>
		        </div>
    		</label>
    		<label class="form-group no-margin" for="indexDirectory">
        		<span class="col-xs-4">
        			<cv:msg key="label.node.indexDirectory" bundle="ediscovery"/>
        		</span>
		        <div class="col-xs-8 padding-left-0">
		        	<input type="text" name="indexDirectory" data-ng-model="enCtlr.selectedNode.indexDirectory" disabled/>
		        </div>
    		</label>
    		<label class="form-group no-margin" for="javaMemory">
        		<span class="col-xs-4">
        			<cv:msg key="label.node.javaMemory" bundle="ediscovery"/>
        		</span>
        		<div class="col-xs-8 padding-left-0">
		            <input type="number" name="javaMemory" data-ng-model="enCtlr.selectedNode.javaMemory" class="col-lg-5" min="{{enCtlr.minJavaMemory}}" max="{{enCtlr.maxJavaMemory}}" step="1" required/>
		            <div class="help-block" data-ng-show="!enCtlr.selectedNode.javaMemory">
						<cv:msg key="error.edit.node.javaMemory" bundle="ediscovery"/>
					</div>
		        </div>
    		</label>
    		<label class="form-group no-margin" for="portNo">
        		<span class="col-xs-4">
        			<cv:msg key="label.node.port" bundle="ediscovery"/>
        		</span>
		        <div class="col-xs-8 padding-left-0">
		            <input type="number" name="portNo" data-ng-model="enCtlr.selectedNode.portNo" class="width-auto" min="1" step="1" required>
		            <span class="help-block" data-ng-show="editNodeForm.$submitted && !enCtlr.selectedNode.portNo">
						<cv:msg key="error.node.portNo" bundle="ediscovery"/>
					</span>
		        </div>
    		</label>
    		<div class="button-container">
                <button type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="$dismiss()">
                    <cv:msg key="Cancel" bundle="messages"/>
                </button>
                <button type="submit" class="btn btn-primary cvBusyOnAjax ng-scope" data-ng-if="!enCtlr.isReconfigure">
                    <cv:msg key="action.save" bundle="ediscovery"/>
                </button>
                <button type="submit" class="btn btn-primary cvBusyOnAjax ng-scope" data-ng-if="enCtlr.isReconfigure">
                    <cv:msg key="label.reconfigure" bundle="ediscovery"/>
                </button>
            </div>
		</form>
	</section>
</div>
