<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<span class="{{quickStartController.serverMessage.type}} serverMessage" data-ng-bind="quickStartController.serverMessage.message"></span>
<form name="selectProjectForm" class="form-horizontal" novalidate="" autocomplete="off">
    <div class="form-group">
        <label class="col-xs-12 col-md-4 col-lg-4" for="project">
            <cv:msg key="label.gdpr.project" bundle="ediscovery" />
        </label>
        <div class="col-xs-12 col-md-7 col-lg-7">
            <select data-ng-options="project.eDiscoveryClient.clientName for project in quickStartController.projects" id="project" name="project" data-ng-model="quickStartController.selectedProject" data-ng-class="{'has-error': cv.selectProjectForm.needsAttention(selectProjectForm.project)}" required>
                <option disabled selected hidden value="">
                    <cv:msg key="quickStart.selectAProject" bundle="ediscovery" />
                </option>
            </select>
        </div>
        <div class="col-xs-12 col-md-1 col-lg-1">
            <a>
                <span class="k-icon k-i-plus-outline cursor-pointer" data-ng-click="quickStartController.setView('addProject')"></span>
            </a>
        </div>
    </div>
</form>