<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<span class="{{quickStartController.serverMessage.type}} serverMessage" data-ng-bind="quickStartController.serverMessage.message"></span>
<form name="addProjectForm" class="form-horizontal" novalidate="" autocomplete="off">
    <div class="form-group">
        <label class="col-xs-12 col-md-4 col-lg-4" for="name">
            <cv:msg key="label.name" bundle="collections" />
        </label>
        <div class="col-xs-12 col-md-7 col-lg-7">
            <input type="text" id="name" name="name" data-ng-model="quickStartController.projectName" required autofocus data-ng-pattern="/^[A-Za-z0-9_\- ]*$/" ng-maxlength="50" data-ng-class="{'has-error': cv.addProjectForm.needsAttention(addEditClientGroupForm.name)}" />
            <span class="help-block" data-ng-show="addProjectForm.name.$error.pattern">
                <cv:msg key="error.invalidName" bundle="ediscovery" />
            </span>
            <span class="help-block" data-ng-show="addProjectForm.name.$error.maxlength">
                <cv:msg key="error.maxlength" bundle="ediscovery" />
            </span>
        </div>
    </div>
    <div class="form-group">
        <label class="col-xs-12 col-md-4 col-lg-4" for="plan">
            <cv:msg key="label.profiles" bundle="profiles" />
        </label>
        <div class="col-xs-12 col-md-7 col-lg-7">
            <select id="plan" name="plan" data-ng-model="quickStartController.selectedEdiscoveryPlan" data-ng-class="{'has-error': cv.addProjectForm.needsAttention(addProjectForm.ediscoveryPlan)}" required>
                <option disabled selected hidden value="">
                    <cv:msg key="placeholder.selectPlan" bundle="profiles" />
                </option>
                <option data-ng-repeat="plan in quickStartController.ediscoveryPlans" value="{{ plan.planId }}" data-toggle="tooltip" data-placement="right" data-ng-attr-title="{{ quickStartController.getPlanTitle(plan) }}" data-ng-disabled="{{ !plan.isValid }}">{{ plan.planName }}</option>
            </select>
            <span class="help-block" data-ng-show="showPlansErrorMessage">
                <cv:msg key="error.selectPlan" bundle="profiles"/>
            </span>
        </div>
        <div class="col-xs-12 col-md-1 col-lg-1">
            <a>
                <span class="k-icon k-i-plus-outline cursor-pointer" data-ng-click="quickStartController.showAddPlanModal()"></span>
            </a>
        </div>
    </div>
    <div class="form-group">
        <label class="col-xs-12 col-md-4 col-lg-4" for="ediscoveryInventory">
            <cv:msg key="label.inventorymanager.name" bundle="ediscovery" />
        </label>
        <div class="col-xs-12 col-md-7 col-lg-7">
            <select id="ediscoveryInventory" name="ediscoveryInventory" data-ng-model="quickStartController.selectedInventory" data-ng-change="quickStartController.selectInventory()" data-ng-options="inventoryObject.inventoryName for inventoryObject in quickStartController.inventoryObjects">
                <option disabled selected hidden value="">
                    <cv:msg key="placeholder.inventorymanager.select" bundle="ediscovery" />
                </option>
            </select>
            <span class="help-block" data-ng-show="showInventoryErrorMessage">
                <cv:msg key="error.selectPlan" bundle="profiles"/>
            </span>
        </div>
        <div class="col-xs-12 col-md-1 col-lg-1">
            <a>
                <span class="k-icon k-i-plus-outline cursor-pointer" data-ng-click="quickStartController.showAddInventoryModal()"></span>
            </a>
        </div>
    </div>
</form>
