<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="row">
    <div class="col-xs-12"><h4>Quick start</h4></div>
</div>
<div>
    <%-- Display if the app is Sensitive Data Analysis --%>
    <div class="cv-main-bar-flex vertical-center quick-row" data-ng-if="$state.is('gdpr')">
        <div class="quick-tile" data-ng-click="ediscoveryType.goToQuickStart('file');">
            <div class="quick-tile-icon">
                <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M7 17V3a.4.4 0 0 1 .3-.3H25a.6.6 0 0 1 .6.5v5.3a1 1 0 0 0 1 1h4.8a.6.6 0 0 1 .6.6v16.2h2V8.6a1.1 1.1 0 0 0-.3-.8L27.5 1a.9.9 0 0 0-.8-.3H7.3c-1.5 0-2.4.4-2.4 2V17H1.3a1.9 1.9 0 0 0-1 .3 1.3 1.3 0 0 0-.3 1v27.1a1.3 1.3 0 0 0 1.3 1.3H3L7 39V17z"/><path d="M48.4 27.2h-9.9v-7.3a2.8 2.8 0 0 0-2.5-2.7v10H14.4a3 3 0 0 0-2.5 1.7L7 39v7.3a3 3 0 0 0 3 3h27.7a3.7 3.7 0 0 0 2.7-1.8L49.7 30c.8-1.6-.1-2.8-1.3-2.8zM28.9 11.7H10.2a1.2 1.2 0 1 0 0 2.4H29a1.2 1.2 0 0 0 1.2-1.2 1.3 1.3 0 0 0-1.3-1.2z"/><path d="M30.2 20.3A1.2 1.2 0 0 0 29 19H10.2a1.2 1.2 0 0 0 0 2.5H29a1.3 1.3 0 0 0 1.2-1.2zM8.8 27.6a1.2 1.2 0 0 0 1.3 1.2h.5a4 4 0 0 1 2.8-2.5h-3.2a1.4 1.4 0 0 0-1.3 1.3z"/></svg>
                <div class="quick-tile-info"><cv:msg key="label.datasource.file" bundle="ediscovery" /></div>
            </div> 
        </div>
        <div class="quick-tile" data-ng-click="ediscoveryType.goToQuickStart('email');">
            <div class="quick-tile-icon">
                <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M46 7.2H4a4 4 0 0 0-4 4v27.6a4 4 0 0 0 4 4h42c2.3 0 4-1.9 4-3.2V12.1c0-3-1.8-4.9-4-4.9zm0 1.6a2 2 0 0 1 1.2.3L27 26.7a2 2 0 0 1-3 0L3 9.1a2.7 2.7 0 0 1 1.2-.3zm2.5 30a2.4 2.4 0 0 1-2.4 2.4H4a2.4 2.4 0 0 1-2.4-2.4V11.2a3 3 0 0 1 .1-.9l16.5 14.4L9 33.4a.8.8 0 0 0 0 1.1.8.8 0 0 0 .6.3 1 1 0 0 0 .6-.3l9.2-8.7h.1l2.7 2.3a4.7 4.7 0 0 0 6 0l2.7-2.3 9.3 8.7a.8.8 0 0 0 .6.3.8.8 0 0 0 .6-.3.9.9 0 0 0 0-1.1l-9.5-8.7 16.3-14.4a2.8 2.8 0 0 1 .2 1v27.5z"/></svg>
                <div class="quick-tile-info"><cv:msg key="label.datasource.email" bundle="ediscovery" /></div>
            </div>
        </div>
        <div class="quick-tile" data-ng-click="ediscoveryType.goToQuickStart('sharepoint');">
            <div class="quick-tile-icon">
                <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M10.6 16.7c1.9-1.2 4.2-.8 6.2-.5L17 20c-1.7-.6-3.1-1.6-5.3 0-1 2.7 2.1 3.7 3.7 5 3 1.9 3.2 6.8.5 9-2.3 1.6-5.1.9-7.4 0l-.1-3.2c1.5 1 3.7 2.7 5.4 1.2 1.4-2.3-1.3-3-2.9-4.8-3.3-2.9-3.4-8.4-.2-10.5zM44.7 20.3a3.1 3.1 0 0 0-1 .1c-1-3-2.6-5.4-6.3-6.8V13a4.6 4.6 0 0 0-4.6-4.6 5 5 0 0 0-3 1v7.2a4.5 4.5 0 0 0 3 1 4.7 4.7 0 0 0 3.7-2 10.2 10.2 0 0 1 5.2 5.8 4.6 4.6 0 0 0 0 7.2 10.2 10.2 0 0 1-5.3 5.8 4.4 4.4 0 0 0-3-2 5 5 0 0 0-2.8 1v7.3a4.5 4.5 0 0 0 2.9 1 4.6 4.6 0 0 0 4.6-4.6v-.5c2.9-1.4 5.2-3 6.4-7a3.4 3.4 0 0 0 .9 0c2.5 0 4.6-1.2 4.6-4.6s-2.8-4.7-5.3-4.7z"/><path d="M27.7 1.8l-.4-.1L.5 6.5a.6.6 0 0 0-.4.6L0 43a.5.5 0 0 0 .4.5l26.9 4.8h.4a.6.6 0 0 0 .1-.5V2.2c.1-.1 0-.3-.1-.4zm-.8 45.4L1 42.6v-35L27 2.7z"/></svg>
                <div class="quick-tile-info"><cv:msg key="label.datasource.sharepoint" bundle="ediscovery" /></div>
            </div>
        </div>
        <div class="quick-tile" data-ng-click="ediscoveryType.goToQuickStart('onedrive');">
            <div class="quick-tile-icon">
                <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M46.1 40H17.8a7 7 0 1 1 0-14h.1a8.6 8.6 0 0 1 16-4.3 7.7 7.7 0 0 1 3.8-1 7.6 7.6 0 0 1 7.5 7.5v.2a6 6 0 0 1 1.5 11.3 3 3 0 0 0-.5.2zM17.8 26.7a6.2 6.2 0 0 0 0 12.3H46l.3-.2a5.3 5.3 0 0 0-1.5-9.8c-.3 0-.4-.2-.4-.5v-.4A6.8 6.8 0 0 0 34 22.5a.3.3 0 0 1-.3 0 .6.6 0 0 1-.3-.2 7.8 7.8 0 0 0-14.7 3.5v.5a.9.9 0 0 1-.1.3.4.4 0 0 1-.4.1 1.3 1.3 0 0 1-.4.1z"/><path d="M17 25a9.7 9.7 0 0 1 17.4-4.8 8.3 8.3 0 0 1 3.4-.6h.2a10.6 10.6 0 0 0-20-3.7 7.8 7.8 0 0 0-4.3-1.3 7.7 7.7 0 0 0-7.6 7.7 8.6 8.6 0 0 0 .2 1.7 6.8 6.8 0 0 0 .5 13.5h4.4A8.2 8.2 0 0 1 9.8 33a8 8 0 0 1 7.1-8z"/></svg>
                <div class="quick-tile-info"><cv:msg key="label.datasource.onedrive" bundle="ediscovery" /></div>
            </div>
        </div>
        <div class="quick-tile" data-ng-click="ediscoveryType.goToQuickStart('db');">
            <div class="quick-tile-icon">
                <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M30.5 45.7h15.3a3.2 3.2 0 0 0 3.3-3.2V7.4a3.2 3.2 0 0 0-3.3-3.2H30.5V0L1 4v42l29.5 4zm0-39.7h15.3a1.4 1.4 0 0 1 1.4 1.4v35.1a1.4 1.4 0 0 1-1.4 1.4H30.5zM5.7 28a5 5 0 0 1-2.5-.7l.4-1.7a4.5 4.5 0 0 0 2.2.6c1 0 1.4-.4 1.4-1s-.4-1-1.5-1.3c-1.4-.6-2.4-1.5-2.4-2.9 0-1.6 1.3-2.8 3.4-2.9a5 5 0 0 1 2.2.5l-.4 1.7a4.3 4.3 0 0 0-1.9-.4c-.9 0-1.3.4-1.3.9s.5.8 1.6 1.3c1.6.6 2.4 1.5 2.4 2.9 0 1.7-1.2 3-3.6 3zM19 30l-4-1.5a1.6 1.6 0 0 0-.6-.2c-2.1-.2-4-1.8-4-5 0-2.9 1.7-5.1 4.5-5.2 3 0 4.7 2.2 4.7 5a4.8 4.8 0 0 1-2.4 4.5l2.5.7zm8.8-1.5l-6.7-.2V18h2.4v8.3h4.3z"/><path d="M14.9 19.8c-1.5 0-2.4 1.5-2.4 3.4s.9 3.3 2.4 3.3 2.4-1.4 2.4-3.4-1-3.3-2.4-3.3zM39.2 33.3c3.5 0 6.3-1.3 6.3-3v-1.7a1.2 1.2 0 0 0-.3-.8 1.3 1.3 0 0 0 .3-.7v-1.8a1.2 1.2 0 0 0-.3-.8 1.5 1.5 0 0 0 .3-.9v-1.8a1.3 1.3 0 0 0-.3-.7V21a.6.6 0 0 0 .1-.3c0-1.5-3.1-2.3-6.1-2.3s-6.2.8-6.2 2.3v.3a1.4 1.4 0 0 0-.2.8v1.8a1.7 1.7 0 0 0 .3.9 1.5 1.5 0 0 0-.3.8V27a2 2 0 0 0 .3.7 1.5 1.5 0 0 0-.3.8v1.8c0 1.6 2.8 2.9 6.4 2.9zM33.5 22c1 .8 3.4 1.3 5.7 1.3s4.6-.5 5.6-1.3v1.5c0 1-2.3 2.2-5.6 2.2s-5.7-1.2-5.7-2.2zm0 3.2c1 1 3.2 1.6 5.7 1.6s4.6-.6 5.6-1.6v1.8c0 1-2.3 2.2-5.6 2.2S33.5 28 33.5 27zm0 3.4c1 1 3.2 1.6 5.7 1.6s4.6-.6 5.6-1.6v1.7c0 1-2.3 2.3-5.6 2.3s-5.7-1.2-5.7-2.3z"/></svg>
                <div class="quick-tile-info"><cv:msg key="label.datasource.database" bundle="ediscovery" /></div>
            </div>
        </div>
        <div class="quick-tile" data-ng-click="ediscoveryType.goToQuickStart('googledrive');">
            <div class="quick-tile-icon">
                <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M50 32.2L33 3.4a.9.9 0 0 0-.7-.4H17a1 1 0 0 0-.7.4L0 30.4a.9.9 0 0 0 0 1l7.6 15.2a1 1 0 0 0 .7.4h33a.8.8 0 0 0 .8-.4l7.7-14a.3.3 0 0 0 0-.4zM1.8 31L17 5.5l6.1 11-14.6 28zm15.1.8l7-13.6 7.6 13.6zm16.6 0L24.8 16 18.4 4.7h13.4l16 27.1z"/></svg>
                <div class="quick-tile-info"><cv:msg key="label.datasource.googledrive" bundle="ediscovery" /></div>
            </div>
        </div>
        <div class="quick-tile" data-ng-click="ediscoveryType.goToQuickStart('gmail');">
            <div class="quick-tile-icon">
                <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M44.7 6H5.3A5.3 5.3 0 0 0 0 11.5v27.3a5.2 5.2 0 0 0 5.3 5.2h39.4a5.3 5.3 0 0 0 5.3-5.2V11.4A5.3 5.3 0 0 0 44.7 6zm-3.5 1.5L25 20.3 8.8 7.5zM7.4 42.2v-26l17.2 13.2a.8.8 0 0 0 .8 0l17.1-13.1v26.2h-35zm41.2-3.5a3.9 3.9 0 0 1-3.8 3.9h-.9V14.9a.7.7 0 0 0-.3-.7.7.7 0 0 0-.8.1L25 28 7.2 14.3a.7.7 0 0 0-.8 0 .7.7 0 0 0-.3.6v27.7h-.8a3.9 3.9 0 0 1-4-4V11.5a3.9 3.9 0 0 1 4-4h1.3l18 14.3a.6.6 0 0 0 .8 0L43.5 7.5h1.3a3.9 3.9 0 0 1 3.8 3.9z"/></svg>
                <div class="quick-tile-info"><cv:msg key="label.datasource.gmail" bundle="ediscovery" /></div>
            </div>
        </div>
    </div>
    <%-- Display if the app is analytics --%>
    <%-- Temporarily we will only support FS data sources for analytics --%>
    <div class="cv-main-bar-flex vertical-center quick-row" data-ng-if="$state.is('analytics')">
        <div class="quick-tile" data-ng-click="ediscoveryType.goToQuickStart('file');">
            <div class="quick-tile-icon">
                <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M7 17V3a.4.4 0 0 1 .3-.3H25a.6.6 0 0 1 .6.5v5.3a1 1 0 0 0 1 1h4.8a.6.6 0 0 1 .6.6v16.2h2V8.6a1.1 1.1 0 0 0-.3-.8L27.5 1a.9.9 0 0 0-.8-.3H7.3c-1.5 0-2.4.4-2.4 2V17H1.3a1.9 1.9 0 0 0-1 .3 1.3 1.3 0 0 0-.3 1v27.1a1.3 1.3 0 0 0 1.3 1.3H3L7 39V17z"/><path d="M48.4 27.2h-9.9v-7.3a2.8 2.8 0 0 0-2.5-2.7v10H14.4a3 3 0 0 0-2.5 1.7L7 39v7.3a3 3 0 0 0 3 3h27.7a3.7 3.7 0 0 0 2.7-1.8L49.7 30c.8-1.6-.1-2.8-1.3-2.8zM28.9 11.7H10.2a1.2 1.2 0 1 0 0 2.4H29a1.2 1.2 0 0 0 1.2-1.2 1.3 1.3 0 0 0-1.3-1.2z"/><path d="M30.2 20.3A1.2 1.2 0 0 0 29 19H10.2a1.2 1.2 0 0 0 0 2.5H29a1.3 1.3 0 0 0 1.2-1.2zM8.8 27.6a1.2 1.2 0 0 0 1.3 1.2h.5a4 4 0 0 1 2.8-2.5h-3.2a1.4 1.4 0 0 0-1.3 1.3z"/></svg>
                <div class="quick-tile-info"><cv:msg key="label.datasource.file" bundle="ediscovery" /></div>
            </div> 
        </div>
    </div>
</div>