<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.tags"></cv:cvMessages>
</script>
<div data-ng-controller="entityManagerController as entityCtrl">
	<div class="entity-manager-header">
		<h1 class="page-title">
			<span><cv:msg key="label.entitymanager" bundle="ediscovery" /></span>
		</h1>	
	<div class="page-action-item spacing-right">
				<span uib-dropdown class="uib-dropdown" on-toggle="toggled(open)">
					<a href class="uib-dropdown-toggle" uib-dropdown-toggle>
						<span class="dropdownArrow right"></span> <cv:msg key='label.entitymanager.add' bundle='ediscovery' />
					</a>
					<ul uib-dropdown-menu class="dropdown-menu menu-icons" role="menu">
						<li class="add-entity ADD_REPORT"><a data-ng-click="entityCtrl.enableCreateMode()"><span><cv:msg key="label.entitymanager.create" bundle="ediscovery"/></span></a></li>
						<li class="import-entity IMPORT_TEMPLATE">
							<a data-ng-click="entityCtrl.importEntityTemplate()"><span><cv:msg key="label.entitymanager.import" bundle="ediscovery"/></span></a>
							<input class="import-entity-input hidden" type="file" data-files-input data-ng-model="files" data-ng-change="entityCtrl.importEntity(files)" accept=".json"/>
						</li>
					</ul>					
				</span>
		</div>	
	</div>
	<div class="row entity-wrapper">
		<div class="col-lg-4 col-md-4 col-sm-5">
			<cv-tile-component loader="entityCtrl.entityListLoader" data-title='<cv:msg key="label.entitymanager.list" bundle="ediscovery" />'>
				<cv-entity-multi-select data-ng-if="entityCtrl.entityListLoader && entityCtrl.selectedEntities.length > 0" entity-list="entityCtrl.entityList" selected-entities="entityCtrl.selectedEntities" selection-mode="'single'" on-entities-select="entityCtrl.onEntitiesSelected(entities)"></cv-entity-multi-select>				
			</cv-tile-component>
		</div>
		<div class="col-lg-8 col-md-8 col-sm-7 entity-details">
			<cv-tile-component loader="entityCtrl.entityDetailsLoader" data-title='{{entityCtrl.entityManager.createNew ? "<cv:msg key="label.entitymanager.add" bundle="ediscovery" />" : entityCtrl.entityManager.entityDetails.entityName}}'>
				<div class="page-details-box-links">
						<a data-ng-if="!entityCtrl.isEntityEditMode && entityCtrl.entityManager.entityDetails && entityCtrl.entityManager.entityDetails.enabled" data-ng-click="entityCtrl.onEditEntityClick()"><cv:msg key="label.edit" bundle="ediscovery" /></a>
						<a data-ng-if="entityCtrl.entityManager.entityDetails && !entityCtrl.entityManager.createNew" data-ng-click="entityCtrl.changeEntityState(!entityCtrl.entityManager.entityDetails.enabled)">{{entityCtrl.entityManager.entityDetails.enabled ? '<cv:msg key="label.disable" bundle="ediscovery" />' : '<cv:msg key="label.enable" bundle="ediscovery" />'}}</a>
						<a data-ng-if="entityCtrl.entityManager.entityDetails && !entityCtrl.entityManager.entityDetails.isSystemDefinedEntity && !entityCtrl.entityManager.createNew" data-ng-click="entityCtrl.deleteEntity()"><cv:msg key="label.delete" bundle="ediscovery" /></a>
				</div>
				 
				<form name="entityCtrl.createEntityForm" cv-hide-api data-cv-submit="entityCtrl.createEntity()" autocomplete="off" class="entity-info-form edit-users-grid-form">
					<ul class="entity-info-list list-style-secondary" data-ng-if="entityCtrl.entityManager.entityDetails" data-ng-class="!entityCtrl.entityManager.entityDetails.enabled && !entityCtrl.entityManager.createNew && 'panel-disabled'">
						<li class="group company-detail-list" data-ng-if="entityCtrl.entityManager.createNew">
							<div class="pageDetail-three-columns-second"><cv:msg key="label.entitymanager.name" bundle="ediscovery" /></div>
							<div class="pageDetailColumn">
								<input required type="text" name="entityName" data-ng-model="entityCtrl.entityManager.entityDetails.entityName" ng-pattern="/^[\w-\s]+$/"/> 
   								 <span class="error" ng-show="entityCtrl.createEntityForm.entityName.$error.pattern"><cv:msg key="error.entitymanager.specialCharsNotAllowed" bundle="ediscovery" /></span>					
							</div>
						</li> 
						<li class="group company-detail-list" data-ng-hide="entityCtrl.entityManager.entityDetails.isSystemDefinedEntity">
							<span class="pageDetail-three-columns-second">
								<cv:msg key="label.regex" bundle="ediscovery" />
							</span> 
							<div class="pageDetailColumn" data-ng-if="!entityCtrl.isEntityEditMode">
								{{entityCtrl.entityManager.entityDetails.regularExpression.entity_regex}} </div>
							<div data-ng-if="entityCtrl.isEntityEditMode" class="pageDetailColumn" data-ng-class="{'has-error': entityCtrl.createEntityForm.entityRegex.$dirty}">
								<textarea class="form-control" name="entityRegex" data-ng-change="entityCtrl.checkRegex()" data-ng-disabled="entityCtrl.entityManager.entityDetails.parentEntityId" data-ng-model="entityCtrl.entityManager.entityDetails.regularExpression.entity_regex"></textarea>
								<div class="regex-error" data-ng-show="entityCtrl.createEntityForm.entityRegex.$dirty" data-ng-bind="entityCtrl.regexInvalidMessage"></div>
								<button type="button"  data-ng-if="!entityCtrl.entityManager.entityDetails.parentEntityId" data-ng-click="entityCtrl.regexTesterModal()" data-ng-if="entityCtrl.isEntityEditMode" class="btn btn-primary margin-top-5 regex-btn"><cv:msg key="label.entitymanager.testRegEx" bundle="ediscovery" /></button>
								<div class="serverMessage error" data-ng-if="entityCtrl.serverErrorMsg">{{entityCtrl.serverErrorMsg}}</div>	
						   </div>
						</li> 
						<li class="group company-detail-list" data-ng-hide="entityCtrl.entityManager.entityDetails.isSystemDefinedEntity">
							<div class="pageDetail-three-columns-second"><cv:msg key="label.entitymanager.derived" bundle="ediscovery" /></div>
							<div class="pageDetailColumn" data-ng-if="!entityCtrl.isEntityEditMode">
								{{entityCtrl.entityManager.entityDetails.parentEntityName}} </div>
							<div class="pageDetailColumn" data-ng-if="entityCtrl.isEntityEditMode">

								<isteven-multi-select input-model="entityCtrl.flatEntityList" output-model="entityCtrl.parentEntity" button-label="displayName" item-label="displayName" tick-property="selected" directive-id="derivedEntity" name="derivedEntity" selection-mode="single" max-labels="1" helper-elements="reset filter" on-close="entityCtrl.onDerivedEntityChange()">
								</isteven-multi-select>			
							</div>
						</li> 
						<li data-ng-hide="entityCtrl.entityManager.entityDetails.entityType === 1" class="group company-detail-list">
							<div class="pageDetail-three-columns-second"><cv:msg key="label.entitymanager.keywords" bundle="ediscovery" /></div>
							<div class="pageDetailColumn keyword-container-width-68">
								<tag-box data-ng-if="!entityCtrl.isEntityEditMode" taglist='entityCtrl.entityManager.entityDetails.entityXML.keywords' editable='entityCtrl.isEntityEditMode'></tag-box>
								<tag-box data-ng-if="entityCtrl.isEntityEditMode" taglist='entityCtrl.entityManager.entityDetails.entityXML.keywords' editable='entityCtrl.isEntityEditMode'></tag-box>
							</div>						
						</li>
						<li class="group company-detail-list" >
							<div class="pageDetail-three-columns-second"><cv:msg key="label.taskdetail.sensitivity" bundle="ediscovery" /></div>
							<div class="pageDetailColumn" data-ng-if="!entityCtrl.isEntityEditMode">
								{{'label.taskDetail.'+entityCtrl.sensitivityType[entityCtrl.entityManager.entityDetails.flags] | cvLoc}}</div>
							<div id="sensitivityElm" class="pageDetailColumn" data-ng-if="entityCtrl.isEntityEditMode">
								<label class="user full-width" for="entitySensitivity">
									<isteven-multi-select input-model="entityCtrl.sensitivityList" output-model="entityCtrl.sensitivity" button-label="displayName" item-label="displayName" tick-property="selected" directive-id="entitySensitivity" name="entitySensitivity" selection-mode="single" max-labels="1" helper-elements="reset filter" on-close="entityCtrl.onSensitivityChange()">
									</isteven-multi-select>											
								</label>													
							</div>
						</li> 
						<li class="group company-detail-list">
							<div class="pageDetail-three-columns-second"><cv:msg key="label.entitymanager.category" bundle="ediscovery" /></div>
							<div class="pageDetailColumn" data-ng-if="!entityCtrl.entityManager.createNew">
								{{entityCtrl.entityManager.entityDetails.categoryName}} </div>
							<div class="pageDetailColumn" data-ng-if="entityCtrl.entityManager.createNew">
								<cv:msg key="label.entitymanger.category.customEntity" bundle="ediscovery" />					
							</div>
						</li> 
						
					</ul>
					<div class="button-container" data-ng-if="entityCtrl.isEntityEditMode || entityCtrl.entityManager.createNew">
						<button id="entityManager_button_#7268" type="button" 
							class="btn btn-default cvBusyOnAjax setup-btn--hidden"
							data-ng-click="entityCtrl.onCancel()">
							<cv:msg key="Cancel" bundle="messages" />
						</button>
						<button id="entityManager_button_#7073" type="submit" class="btn btn-primary cvBusyOnAjax"> 
							<cv:msg key="Save" bundle="messages" />
						</button>
				
					</div>
				</form>
			</cv-tile-component>
		</div>
	</div>
</div>
