<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
    <cv:cvMessages bundle="localization.tags"></cv:cvMessages>
</script>
<form name="trainClassifierForm" novalidate autocomplete="off" data-cv-submit="">
    <div class="bootstrap-wrapper no-padding">
        <div class="panel panel-default no-border">
            <div class="panel-body">
                <div class="text-align-center padding-bottom-50">
                    <span>
                        <cv:msg key="info.classifiermanager.wizardstep3.detail" bundle="ediscovery" />
                    </span>
                </div>
                <div class="form-group padding-bottom-5">
                    <div class="row">
                        <div class="col-md-3 col-md-offset-2">
                            <label>
                                <cv:msg key="label.entitymanager.name" bundle="ediscovery"/>
                            </label>
                        </div>
                        <div class="col-md-5">
                            <label>{{trainClassifierCtrl.model.classifierObj.entityName}}</label>
                        </div>
                    </div>
                </div>
                <div class="form-group padding-bottom-5">
                    <div class="row">
                        <div class="col-md-3 col-md-offset-2">
                            <label>
                                <cv:msg key="label.description" bundle="ediscovery"/>
                            </label>
                        </div>
                        <div class="col-md-5">
                            <label>{{trainClassifierCtrl.model.classifierObj.description}}</label>
                        </div>
                    </div>
                </div>
                <div data-ng-if="trainClassifierCtrl.sourceApplication === 1">
                    <div class="form-group padding-bottom-20">
                        <div class="row">
                            <div class="col-md-3 col-md-offset-2">
                                <label>
                                    <cv:msg key="label.classifiermanager.sampleDocuments" bundle="ediscovery"/>
                                </label>
                            </div>
                            <div class="col-md-7">
                                <tag-box taglist='trainClassifierCtrl.trainingSamples' editable='false'></tag-box>
                            </div>
                        </div>
                    </div>
                </div>
                <div data-ng-if="trainClassifierCtrl.sourceApplication === 2">
                    <div class="form-group padding-bottom-5">
                        <div class="row">
                            <div class="col-md-3 col-md-offset-2">
                                <label>
                                    <cv:msg key="label.classifierWizard.cases" bundle="ediscovery"/>
                                </label>
                            </div>
                            <div class="col-md-7">
                                <tag-box taglist='trainClassifierCtrl.cases' editable='false'></tag-box>
                            </div>
                        </div>
                    </div>
                    <div class="form-group padding-bottom-20">
                        <div class="row">
                            <div class="col-md-3 col-md-offset-2">
                                <label>
                                    <cv:msg key="label.tags" bundle="tags"/>
                                </label>
                            </div>
                            <div class="col-md-7">
                                <tag-box taglist='trainClassifierCtrl.tags' editable='false'></tag-box>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>