<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
    <cv:cvMessages bundle="localization.tags"></cv:cvMessages>
</script>
<form name="classifierTrainDataForm" novalidate autocomplete="off" data-cv-submit="">
    <div class="bootstrap-wrapper no-padding">
        <div class="panel panel-default no-border">
            <div class="panel-body">
                <div class="text-align-center padding-bottom-50">
                    <span data-ng-if="trainingUploadCtrl.selectedSourceApp[0].id === 1">
                        <cv:msg key="info.classifiermanager.wizardstep2.sdg.detail" bundle="ediscovery" />
                    </span>
                    <span data-ng-if="trainingUploadCtrl.selectedSourceApp[0].id === 2">
                        <cv:msg key="info.classifiermanager.wizardstep2.casemanager.detail" bundle="ediscovery" />
                    </span>
                </div>
                <div class="form-group padding-bottom-10" data-ng-hide="!trainingUploadCtrl.enableCaseManagerDetails">
                    <div class="row">
                        <div class="col-md-3 col-md-offset-2">
                            <label>
                                <cv:msg key="label.classifierWizard.sourceApplication" bundle="ediscovery"/>
                            </label>
                        </div>
                        <div class="col-md-5">
                            <isteven-multi-select
                                directive-id="classifierWizardSourceApp"
                                input-model="trainingUploadCtrl.sourceApplications"
                                output-model="trainingUploadCtrl.selectedSourceApp"
                                button-label="appName"
                                item-label="appName"
                                tick-property="selected"
                                selection-mode="single"
                                helper-elements="filter"
                                min-search-length="3"
                                search-property="appName"
                                max-labels="1"
                                translation="trainingUploadCtrl.localLang"
                                output-properties="id">
                            </isteven-multi-select>
                        </div>
                    </div>
                </div>
                <div data-ng-if="trainingUploadCtrl.selectedSourceApp[0].id === 1">
                    <div class="form-group padding-bottom-20">
                        <div class="row">
                            <div class="col-md-3 col-md-offset-2">
                                <label>
                                    <cv:msg key="label.classifiermanager.sampleDocuments" bundle="ediscovery"/>
                                </label>
                            </div>
                            <div class="col-md-5">
                                <cv-file-upload 
                                    cv-enable-multi-select="false"
                                    cv-allowed-file-types=".zip"
                                    cv-uploaded-files="{{trainingUploadCtrl.uploadedFiles}}"
                                    cv-upload-info="trainingUploadCtrl.uploadFileInfo"
                                    cv-on-complete="trainingUploadCtrl.onUploadComplete(filesInfo)"
                                    cv-is-uploading="trainingUploadCtrl.isUploadInProgress"
                                    cv-upload-limit-mb="500">
                                </cv-file-upload>
                            </div>
                        </div>
                    </div>
                </div>
                <div data-ng-if="trainingUploadCtrl.selectedSourceApp[0].id === 2">
                    <div class="form-group padding-bottom-10">
                        <div class="row">
                            <div class="col-md-3 col-md-offset-2">
                                <label>
                                    <cv:msg key="label.classifierWizard.cases" bundle="ediscovery"/>
                                </label>
                            </div>
                            <div class="col-md-5">
                                <isteven-multi-select
                                    directive-id="classifierWizardCasesSelection"
                                    input-model="trainingUploadCtrl.caseList"
                                    output-model="trainingUploadCtrl.selectedCases"
                                    button-label="clientName"
                                    item-label="clientName"
                                    tick-property="selected"
                                    selection-mode="multiple"
                                    helper-elements="all none filter reset"
                                    min-search-length="3"
                                    search-property="clientName"
                                    max-labels="1"
                                    translation="trainingUploadCtrl.localLang"
                                    output-properties="clientGUID clientId clientName">
                                </isteven-multi-select>
                                <input type="text" ng-model="trainingUploadCtrl.selectedCases" name="selectedCase" style="display:none" required />
                                <span class="help-block" data-ng-if="classifierTrainDataForm.$submitted && classifierTrainDataForm.selectedCase.$error.required">
                                    <cv:msg key="error.noCaseSelected" bundle="ediscovery" />
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group padding-bottom-20">
                        <div class="row">
                            <div class="col-md-3 col-md-offset-2">
                                <label>
                                    <cv:msg key="label.tags" bundle="tags"/>
                                </label>
                            </div>
                            <div class="col-md-5">
                                <isteven-multi-select
                                    directive-id="classifierWizardTagsSelection"
                                    input-model="trainingUploadCtrl.tagsList"
                                    output-model="trainingUploadCtrl.selectedTags"
                                    button-label="name"
                                    item-label="name"
                                    tick-property="selected"
                                    selection-mode="multiple"
                                    helper-elements="all none filter reset"
                                    min-search-length="3"
                                    search-property="name"
                                    max-labels="1"
                                    translation="trainingUploadCtrl.localLang"
                                    group-property="msGroup"
                                    output-properties="tagId name">
                                </isteven-multi-select>
                                <input type="text" ng-model="trainingUploadCtrl.selectedTags" name="selectedTag" style="display:none" required />
                                <span class="help-block" data-ng-if="classifierTrainDataForm.$submitted && classifierTrainDataForm.selectedTag.$error.required">
                                    <cv:msg key="error.noTagSelected" bundle="ediscovery" />
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>
    <div class="cv-wizard-default-actions add-alert-wizard-actions row">
        <div class="col-xs-12">
            <div class="col-xs-3 col-xs-offset-6 col-md-2 col-md-offset-8">
                <cv-wizard-button data-cv-type="previous"
                        data-cv-disabled="trainingUploadCtrl.isUploadInProgress">
                </cv-wizard-button>
            </div>
            <div class="col-xs-3 col-md-2">
                <cv-wizard-button data-cv-type="next"
                        data-cv-disabled="trainingUploadCtrl.isUploadInProgress">
                </cv-wizard-button>
            </div>
        </div>
    </div>
</form>