<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<span><cv:msg key="label.classifiermanager.edit" bundle="ediscovery"/></span>
	</h1>
</div>
<div>
    <form name="editClassifierForm" cv-hide-api novalidate autocomplete="off" data-cv-submit="editController.saveClassifier()" class="bootstrap-wrapper form-horizontal">
        <div class="modal-body">
            <div class="form-group">
                <div class="row">
                    <div class="col-md-3 col-md-offset-1">
                        <label for="classifierName">
                            <cv:msg key="label.entitymanager.name" bundle="ediscovery" />
                        </label>
                    </div>
                    <div class="col-md-7">
                        <input type="text" autofocus name="classifierName" data-ng-model="editController.classifierDisplayName" required data-ng-pattern="/^[\w-\s]+$/">
                        <span class="help-block" data-ng-if="editClassifierForm.$submitted && editClassifierForm.classifierName.$error.required">
                            <cv:msg key="error.entitymanager.name.required" bundle="ediscovery"/>
                        </span>
                        <span class="error" data-ng-if="editClassifierForm.classifierName.$error.pattern">
                            <cv:msg key="error.entitymanager.specialCharsNotAllowed" bundle="ediscovery" />
                        </span>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="row">
                    <div class="col-md-3 col-md-offset-1">
                        <label for="classifierDescription">
                            <cv:msg key="label.description" bundle="ediscovery"/>
                        </label>
                    </div>
                    <div class="col-md-7">
                        <textarea placeholder="<cv:msg key='info.classifiermanager.createclassifier.description' bundle='ediscovery' />" data-ng-model="editController.classifierDescription"></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="editController.closeModal()"><cv:msg key="action.cancel" bundle="profiles" /></button>
            <button type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles" /></button>
        </div>
    </form>
</div>