<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div id="customClassifierDetails" ng-controller = "ClassifierDetailsController as classifierDetailsCtrl">
    <div id="classifierDetailsContainer" ng-if="classifierDetailsCtrl.detailsAvailable">
        <div id="classifierDetailsHeader" class="row">
            <div class="col-md-12">
                <span>
                    <h1 class="page-title">
                        <div class="float-left">
                            <span ng-bind="classifierDetailsCtrl.classifierDetails.displayName"></span>
                        </div>
                    </h1>
                </span>
            </div>
        </div>
        <div id="classifierDetailsArea">
            <div class="row">
                <div class="col-md-6">
                    <cv-tile-component data-ac-id="classifierDetails-label_general-ediscovery" title='<cv:msg key="label.general" bundle="ediscovery"/>'>
                        <div>
                            <ul class="list-style-secondary" data-ng-class="!classifierDetailsCtrl.classifierDetails.enabled && 'classifier-panel-disable'">
                                <li class="group">
                                    <span class="pageDetailColumn"><cv:msg key="label.contentAnalyzer" bundle="ediscovery" /></span>
                                    <span class="pageDetailColumn">{{classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.CAUsedInTraining.cloudName}}</span>
                                </li>
                                <li class="group">
                                    <span class="pageDetailColumn"><cv:msg key="label.description" bundle="ediscovery" /></span>
                                    <span class="pageDetailColumn">{{classifierDetailsCtrl.classifierDetails.description}}</span>
                                </li>
                                <li class="group">
                                    <span class="pageDetailColumn"><cv:msg key="label.createdOn" bundle="ediscovery" /></span>
                                    <span class="pageDetailColumn">{{classifierDetailsCtrl.classifierDetails.createdTime ? (classifierDetailsCtrl.classifierDetails.createdTime * 1000 | date:"hh:mm a on MMMM dd, yyyy") : ('label.NA' | cvLoc)}}</span>
                                </li>
                                <li class="group">
                                    <span class="pageDetailColumn"><cv:msg key="label.classifier.lastTrained" bundle="ediscovery" /></span>
                                    <span class="pageDetailColumn">{{classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.CAUsedInTraining.lastModelTrainTime ? (classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.CAUsedInTraining.lastModelTrainTime * 1000 | date:"hh:mm a on MMMM dd, yyyy") : ('label.NA' | cvLoc)}}</span>
                                </li>
                            </ul>
                        </div>
                        <div class="page-details-box-links">
                            <a href data-ng-click="classifierDetailsCtrl.editClassifier()" data-ng-if="classifierDetailsCtrl.classifierDetails.enabled">
                                <cv:msg key="label.edit" bundle="ediscovery" />
                            </a>
                            <a href data-ng-click="classifierDetailsCtrl.toggleClassifierState()">
                                {{classifierDetailsCtrl.classifierDetails.enabled ? '<cv:msg key="label.disable" bundle="ediscovery" />' : '<cv:msg key="label.enable" bundle="ediscovery" />'}}
                            </a>
                        </div>
                    </cv-tile-component>
                </div>
                <div class="col-md-6">
                    <cv-tile-component data-ac-id="classifierDetails-label_training-ediscovery" title='<cv:msg key="label.training" bundle="ediscovery"/>'>
                        <div>
                            <ul class="list-style-secondary" data-ng-class="!classifierDetailsCtrl.classifierDetails.enabled && 'classifier-panel-disable'">
                                <li class="group">
                                    <span class="pageDetailColumn"><cv:msg key="label.classifier.accuracy" bundle="ediscovery" /></span>
                                    <span class="pageDetailColumn">
                                        <span ng-class="classifierDetailsCtrl.accuracyFont">
                                            {{classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.classifierAccuracy ? ((classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.classifierAccuracy * 100).toFixed(0) + '%') : ('label.NA' | cvLoc)}}
                                        </span>
                                    </span>
                                </li>
                                <li class="group">
                                    <span class="pageDetailColumn"><cv:msg key="label.classifier.totalSamples" bundle="ediscovery" /></span>
                                    <span class="pageDetailColumn">{{classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.totalSamples ? (classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.totalSamples) : ('label.NA' | cvLoc)}}</span>
                                </li>
                                <li class="group">
                                    <span class="pageDetailColumn"><cv:msg key="label.classifier.trainingSamplesUsed" bundle="ediscovery" /></span>
                                    <span class="pageDetailColumn">{{classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.trainingSamplesUsed ? (classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.trainingSamplesUsed) : ('label.NA' | cvLoc)}}</span>
                                </li>
                                <li class="group">
                                    <span class="pageDetailColumn"><cv:msg key="label.classifier.validationSamplesUsed" bundle="ediscovery" /></span>
                                    <span class="pageDetailColumn">{{classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.validationSamplesUsed ? (classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.validationSamplesUsed) : ('label.NA' | cvLoc)}}</span>
                                </li>
                                <li class="group">
                                    <span class="pageDetailColumn"><cv:msg key="label.status" bundle="ediscovery" /></span>
                                    <span class="pageDetailColumn">
                                        <div class="classifier-progress progress width-70-percentage" ng-Class="classifierDetailsCtrl.progressCss">
                                            <div class="progress-bar full-width color-white" ng-class="classifierDetailsCtrl.trainingStatusCss">
                                                {{classifierDetailsCtrl.trainingStatus}}
                                            </div>
                                        </div>
                                        <div ng-if="classifierDetailsCtrl.classifierErrorMsg">
                                            <span class="text-warning font-size-12">
                                                {{classifierDetailsCtrl.classifierErrorMsg}}
                                            </span>
                                        </div>
                                    </span>
                                </li>
                                <li class="group">
                                    <span class="pageDetailColumn"><cv:msg key="label.classifiermanager.sampleDocuments" bundle="ediscovery" /></span>
                                    <span class="pageDetailColumn">
                                        <cv-file-upload 
                                            cv-enable-multi-select="false"
                                            cv-allowed-file-types=".zip"
                                            cv-upload-info="classifierDetailsCtrl.uploadFileInfo"
                                            cv-on-complete="classifierDetailsCtrl.onUploadComplete(filesInfo)"
                                            cv-is-uploading="classifierDetailsCtrl.isUploadInProgress"
                                            cv-disable-upload="classifierDetailsCtrl.disableUpload"
                                            cv-upload-limit-mb="500">
                                        </cv-file-upload>
                                    </span>
                                </li>
                            </ul>
                        </div>
                        <div class="page-details-box-links">
                            <a href ng-click="classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.trainingStatus === 2 ? classifierDetailsCtrl.cancelTraining() : classifierDetailsCtrl.trainClassifier()" data-ng-if="classifierDetailsCtrl.classifierDetails.enabled">
                                {{(classifierDetailsCtrl.classifierDetails.entityXML.classifierDetails.trainingStatus === 2 ? 'label.classifier.cancelTraining' : 'header.classifiermanager.startTraining') | cvLoc}}
                            </a>
                        </div>
                    </cv-tile-component>
                </div>
            </div>
        </div>
    </div>
</div>