<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
</script>
<form name="permissionsConfirmModal" novalidate autocomplete="off">
	<div class="setup-title">
		<h1><cv:msg key="title.applyPermissions" bundle="userPermissions" /></h1>
	</div>


	<div class="bootstrap-wrapper">
		<div class="form-group">
			<div class="col-xs-12"><h4><span data-ng-bind="permCtrl.url"></span></h4></div>
		</div>
		<div class="form-group">
		<table class="permissions-confirm-table table table-striped">
			<thead>
			<tr class="permissions-modal-table-row">
			<th class="permissions-modal-table-cell"><cv:msg key="label.user" bundle="userPermissions" /></th>
			<th class="permissions-modal-table-cell1"><cv:msg key="label.permissionsAdded" bundle="userPermissions" /></th>
			<th class="permissions-modal-table-cell1"><cv:msg key="label.permissionsRevoked" bundle="userPermissions" /></th>
			</tr>
			</thead>
			<tbody>
			<tr class="permissions-modal-table-row" data-ng-repeat="(key,value) in permCtrl.users">
			<td class="permissions-modal-table-row">{{key}}</td>
			<td class="permissions-modal-table-row">{{value.added}}</td>
			<td class="permissions-modal-table-row">{{value.revoked}}</td>
			</tr>
			</tbody>
		</table>
		</div>
	</div>
	<div data-ng-if="permCtrl.showInProgress">
		<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
			<cv:msg key="message.apply.permissions" bundle="userPermissions" />
	</div>
	<div class="modal-footer">
		<button id="permissionsApplyConfirmModal_button_#7864" type="button" class="btn btn-default cvBusyOnAjax"
			data-ng-click="permCtrl.cancel()">
			<cv:msg key="action.cancel" bundle="profiles" />
		</button>
		<button id="permissionsApplyConfirmModal_button_#5473" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="permCtrl.save()">
			<cv:msg key="action.confirm" bundle="userPermissions" />
		</button>
	</div>
</form>