<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.tags"></cv:cvMessages>
</script>
<%-- Hidden report for facets --%>
<div
	data-ng-if="!fsCtrl.filterSearchConfig.disableFacetFilters && fsCtrl.isLoadReportForFilters"
	data-ng-hide="true"
	id="ng-app"
	data-ng-app="reports"
	data-ng-controller="reportsCtrl"
	data-ng-init="init(fsCtrl.reportsObj.searchViewId, fsCtrl.reportsObj.searchViewName, null, null, fsCtrl.reportsObj.queryString, fsCtrl.filterAcrossReports)"
>
	<div
		data-ng-hide="true"
		id="pageDiv"
		data-ng-controller="pageController"
		class="maskLayer"
		data-ng-class="{'isMasked':masked}"
	>
		<div
			id="pageDiv"
			data-ng-hide="true"
			data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"
		></div>
	</div>
</div>
<%-- Hidden directive to listen to events and manage filters applied across reports --%>
<report-filters data-ng-if="fsCtrl.filterAcrossReports" data-ng-hide="true" components="fsCtrl.reportFiltersComponents" data-data-sets="fsCtrl.reportFiltersDataSets"></report-filters>
<div class="page-content ediscovery-lookup-content">
	<span class="serverMessage {{ fsCtrl.errorMessage.type }}">{{ fsCtrl.errorMessage.message }}</span>
	<section>
		<div class="row">
			<div class="filter-facet" data-ng-class="fsCtrl.facetConfig.length > 0 ? 'col-md-2 no-right-padding':'collapse' ">
				<div id="taskFacets" data-ng-app="reports">
					<ul id="reportArea">
						<li data-ng-if="fsCtrl.taskFacets" data-component-type="FACET"  comp="{{fsCtrl.componentId}}" >
							<cvfacet config="fsCtrl.taskFacets" type="'component'" page="fsCtrl.page" filters="fsCtrl.page.body.filters"
	                         filter-mode="'viewer'" report-mode="'viewer'" datasets="fsCtrl.dataSets"></cvfacet>
	                     </li>
					</ul>
				</div>				
			</div>
			<div data-ng-class="fsCtrl.facetConfig.length > 0 ? 'col-md-10':'col-md-12'">
				<div class="row ediscovery-lookup-title" data-ng-if="fsCtrl.enableSearchInput && fsCtrl.errorMessage.type !== 'error'">
					<div class="col-xs-12 col-md-12 col-lg-12">
						<div class="row">
							<div
								data-ng-class="fsCtrl.enableAdvancedSearch ? 'col-lg-6 col-md-6 col-xs-6':'col-lg-9 col-md-9 col-xs-9'"
								class="search-input"
							>
								<div class="review-items-search">
									<form class="input" data-ng-submit="onSearch(searchQuery)">
										<input
											type="text"
											id="searchInputFilterSearch"
											data-ng-model-options="{ debounce : 1000}"
											data-ng-model="fsCtrl.searchText"
											data-ng-change="fsCtrl.onSearchChanged(fsCtrl.searchText)"
											autofocus
											data-ng-attr-placeholder="{{ fsCtrl.searchPlaceHolder }} {{
												fsCtrl.selectedSearchOption.displayName
											}}"
										/>
									</form>
								</div>
							</div>
							<div class="col-lg-3 col-md-3 col-xs-3">
								<div class="form-group lookup-search-select">
									<select
										id="dataColumn"
										name="dataColumn"
										data-ng-model="fsCtrl.selectedSearchOption"
										data-ng-change="fsCtrl.onSearchChanged(fsCtrl.searchText)"
										data-ng-options="searchOption.displayName for searchOption in fsCtrl.searchOptions"
									>
									</select>
								</div>
							</div>
							<div class="col-lg-3 col-md-3" data-ng-if="fsCtrl.enableAdvancedSearch">
								<a
									class="btn btn-primary advanced-search-button pull-right"
									data-ng-click="fsCtrl.doAdvancedSearch()"
									>{{ 'label.advancedsearch' | cvLoc }}</a
								><a
									class="btn filter-button"
									data-ng-if="fsCtrl.filtersEnabled"
									data-ng-class="fsCtrl.showFilters ? 'gdpr-filter-on btn-primary' : 'btn-default'"
									data-ng-click="fsCtrl.showFilters = !fsCtrl.showFilters"
									title="{{ 'reportFilter.showFilters' | cvLoc }}"
									><span class="k-icon k-i-filter"></span
								></a>
							</div>
						</div>
						<div class="pull-right margin-right-15">
							<span
								class="lookup-search-link"
								data-ng-show="fsCtrl.dataSchema && fsCtrl.lookupItems.length == 0 && fsCtrl.dsType == 'file'"
							>
								<a data-ng-click="fsCtrl.addLookupItems()"
									><cv:msg key="label.addFileServerDataSource" bundle="ediscovery"
								/></a>
							</span>
						</div>
					</div>
					<div class="col-xs-12 gdpr-chips" data-ng-if="fsCtrl.filtersEnabled" data-ng-show="fsCtrl.showFilters">
						<div id="reviewFilters" data-ng-app="reports">
							<ul id="reportArea">
								<li data-ng-if="fsCtrl.filterComponent" data-component-type="FACET"  comp="{{fsCtrl.componentId}}" >
									<cvfacet config="fsCtrl.filterComponent" type="'component'" page="fsCtrl.page" filters="fsCtrl.page.body.filters"
			                         filter-mode="'viewer'" report-mode="'viewer'" datasets="fsCtrl.dataSets"   get-data="getData()"
			                         set-all-components-intialized="setAllComponentsIntialized(component)" data-ng-hide="fsCtrl.filterSearchConfig.disableFacetFilters"></cvfacet>
			                     </li>
							</ul>
						</div>
					</div>
				</div>
				<cv-kendo-grid data-cv-grid-options="fsCtrl.gridOptions"></cv-kendo-grid>			
			</div>
		</div>
	</section>
</div>
