<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="user-access">
	<ul class="nav nav-tabs access-tabs reports-nav" role="tablist">
		<li class="nav-item active" data-ng-class="{'active': userAccessCtrl.selectedTab == 'accessHistory'}" data-ng-if="userAccessCtrl.accessMap">
			<a class="nav-link" data-toggle="tab" role="tab" data-ng-click="userAccessCtrl.selectedTab = 'accessHistory'">{{'label.accessedBy' | cvLoc}}</a>
		</li>
		<li class="nav-item" data-ng-class="{'active': userAccessCtrl.selectedTab == 'modificationHistory'}" data-ng-if="userAccessCtrl.modificationMap">
			<a class="nav-link" data-toggle="tab" role="tab" data-ng-click="userAccessCtrl.selectedTab = 'modificationHistory'">{{'label.modifiedBy' | cvLoc}}</a>
		</li>
	</ul>
</div>
<div data-ng-if="userAccessCtrl.selectedTab !== 'modificationHistory'">
	<uib-accordion class="text-left risk-category">
	<div uib-accordion-group is-open="sensitivityObj.open"
		class="risk-type"
		data-ng-repeat="(key, users) in userAccessCtrl.accessMap">
		<uib-accordion-heading> <span
			class="{{sensitivityObj.level}}"><span class="risk-icon glyphicon glyphicon-user"></span>{{key}}</span>
			<i class="pull-right glyphicon"
				ng-class="{'glyphicon-chevron-down': sensitivityObj.open, 'glyphicon-chevron-right': !sensitivityObj.open}"></i>
			<span class="badge badge-wide pull-right">{{users.length}}</span>
		</uib-accordion-heading>
		<div class="file-list">
			<form name="{{sensitivityObj.name}}-items">
				<div data-ng-repeat="time in users track by $index">
					<span class="glyphicon glyphicon-time"></span>
					<label class="sensitivity-item-title" for="{{time + $index}}">{{time | date:"MM/dd/yy, hh:mm a"}}</label>
				</div>
			</form>
		</div>
	</div>
	</uib-accordion>
</div>
<div data-ng-if="userAccessCtrl.selectedTab === 'modificationHistory'">
	<uib-accordion class="text-left risk-category">
	<div uib-accordion-group is-open="sensitivityObj.open"
		class="risk-type"
		data-ng-repeat="(key, users) in userAccessCtrl.modificationMap">
		<uib-accordion-heading> <span
			class="{{sensitivityObj.level}}"><span class="risk-icon glyphicon glyphicon-user"></span>{{key}}</span>
			<i class="pull-right glyphicon"
				ng-class="{'glyphicon-chevron-down': sensitivityObj.open, 'glyphicon-chevron-right': !sensitivityObj.open}"></i>
			<span class="badge badge-wide pull-right">{{users.length}}</span>
		</uib-accordion-heading>
		<div class="file-list">
			<form name="{{sensitivityObj.name}}-items">
				<div data-ng-repeat="time in users track by $index">
					<span class="glyphicon glyphicon-time"></span>
					<label class="sensitivity-item-title" for="{{time + $index}}">{{time | date:"MM/dd/yy, hh:mm a"}}</label>
				</div>
			</form>
		</div>
	</div>
	</uib-accordion>
</div>