<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
    <h1><cv:msg key="label.editFileServer" bundle="ediscovery" /></h1>
</div>
<div>
    <div class="{{errorMessage.type}} serverMessage">{{ errorMessage.message }}</div>
    <form name="editFileServerForm" cv-hide-api data-cv-submit="save()" novalidate autocomplete="off" id="editFileServerForm" class="bootstrap-wrapper form-horizontal">
        <div class="modal-body">
            <div class="form-group">
                <label class="col-xs-12 col-md-4 col-lg-4" for="displayName"><cv:msg key="label.displayName" bundle="ediscovery" /></label>
                <div class="col-xs-12 col-md-8 col-lg-8">
                    <input type="text" name="displayName" id="displayName" data-ng-model="model.displayName" required />
                    <span class="help-block" data-ng-show="cv.editFileServerForm.needsAttention(editFileServerForm.displayName)"><cv:msg key="error.displayName" bundle="ediscovery" /></span>
                </div>
            </div>
            <div class="form-group" data-ng-if="model.showLogin">
                <label class="col-xs-12 col-md-4 col-lg-4" for="userName"><cv:msg key="label.userName" bundle="ediscovery" /></label>
                <div class="col-xs-12 col-md-8 col-lg-8">
                    <input type="text" name="userName" id="userName" data-ng-model="model.username" required />
                    <span class="help-block" data-ng-show="cv.editFileServerForm.needsAttention(editFileServerForm.userName)"><cv:msg key="error.userName" bundle="ediscovery" /></span>
                </div>
            </div>
            <div class="form-group" data-ng-if="model.showLogin">
                <label class="col-xs-12 col-md-4 col-lg-4" for="password"><cv:msg key="label.password" bundle="ediscovery" /></label>
                <div class="col-xs-12 col-md-8 col-lg-8">
                    <input type="password" name="password" id="password" data-ng-model="model.password" required />
                    <span class="help-block" data-ng-show="cv.editFileServerForm.needsAttention(editFileServerForm.password)"><cv:msg key="error.password" bundle="ediscovery" /></span>
                </div>
            </div>
            <div class="form-group" data-ng-if="model.showDirectoriesPath">
                <label class="col-xs-12 col-md-4 col-lg-4" for="directoryPath"><cv:msg key="label.directoryPath" bundle="ediscovery" /></label>
                <div class="col-xs-12 col-md-8 col-lg-8">
                    <textarea id="directoryPath" name="directoryPath" data-ng-attr-placeholder="{{ getPlaceholderText() }}" data-ng-model="model.includedirectoriespath" data-ng-pattern="filePathValidation" data-ng-model-options="{ updateOn: 'blur' }" required></textarea>
                    <span class="help-block" data-ng-show="cv.editFileServerForm.needsAttention(editFileServerForm.directoryPath)">{{ directoryPathError }}</span>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button id="editFileServer_button_#3999" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="$dismiss()"><cv:msg key="Cancel" bundle="messages" /></button> 
            <button id="editFileServer_button_#9841" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button> 
        </div>
    </form>
</div>