<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
    <cv:cvMessages bundle="localization.setup"></cv:cvMessages>
</script>
<div data-ng-controller="ediscoveryLanding as ediscoveryController" class="ediscovery-landing-page">
    <div><h1><cv:msg key="label.ediscovery" bundle="ediscovery" /></h1></div>
    <div class="row">
        <div class="col-sm-12"><h3>{{'label.fileStorageOptimization' | cvLoc}}</h3></div>
        <div class="col-sm-12 col-md-6 col-lg-4" data-ng-if="ediscoveryController.isRegistryKeyEnabled('enableAnalyticsApp')">
            <div class="landing-page-tile cv-main-bar-flex vertical-center" data-ng-click="ediscoveryController.navigate('FSO')">
                <div class="landing-page-tile-icon">
                    <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M32.4 0h-27v50h39.2V12.2zm.5 2.8l8.8 8.9H33zm10 36.5v9H7.1V1.7h24.1v11.6H43z"/><path d="M25.6 21.8H19V15a.4.4 0 0 0-.3-.3h-.1a7.5 7.5 0 1 0 7.4 7.4.4.4 0 0 0-.3-.4z"/><path d="M20.6 12.7a.4.4 0 0 0-.4.4v7a.4.4 0 0 0 .3.4h7a.4.4 0 0 0 .5-.3 7.5 7.5 0 0 0-7.4-7.5zM40 17.7h-8.6c-.3 0-.4.2-.4.6s.1.5.4.5H40c.2 0 .4-.2.4-.5s-.1-.6-.4-.6zM40 21.6h-8.6c-.3 0-.4.3-.4.6s.1.6.4.6H40c.2 0 .4-.3.4-.6s-.1-.6-.4-.6zM40 25.6h-8.6c-.3 0-.4.2-.4.5s.1.6.4.6H40c.2 0 .4-.3.4-.6s-.1-.5-.4-.5zM19.8 35h-8.6c-.3 0-.4.1-.4.5s.1.5.4.5h8.6c.2 0 .4-.2.4-.5s-.2-.6-.4-.6zM19.8 38.8h-8.6c-.3 0-.4.3-.4.6s.1.5.4.5h8.6c.2 0 .4-.2.4-.5s-.2-.6-.4-.6zM19.8 42.7h-8.6c-.3 0-.4.2-.4.6s.1.5.4.5h8.6c.2 0 .4-.2.4-.5s-.2-.6-.4-.6zM28.3 33.1h-2.7a.4.4 0 0 0-.4.4v11a.4.4 0 0 0 .4.4h2.7a.4.4 0 0 0 .5-.4v-11a.4.4 0 0 0-.4-.4zm-.4 11H26v-6.3h1.9zm0-7H26v-3.2h1.9zM40 35.9h-2.7a.4.4 0 0 0-.4.3v8.3a.4.4 0 0 0 .4.4H40a.4.4 0 0 0 .4-.4v-8.2a.4.4 0 0 0-.4-.4zm-.4 8.2h-1.9v-2.8h2zm0-3.6h-1.9v-3.8h2zM34.2 38.6h-2.7a.4.4 0 0 0-.4.4v5.5a.4.4 0 0 0 .3.4h2.8a.4.4 0 0 0 .4-.4V39a.4.4 0 0 0-.3-.4zm-2.4.8h2V42h-2zm2 4.7h-2v-1.2h2z"/></svg>
                </div>
                <div class="landing-page-tile-info">
                    <h4>{{'label.analytics' | cvLoc}}</h4>
                    <p>{{'label.analytics.description' | cvLoc}}</p>
                </div>
            </div>
        </div>
        <div class="col-sm-12 col-md-6 col-lg-4">
            <div class="landing-page-tile cv-main-bar-flex vertical-center" data-ng-click="ediscoveryController.navigate('ENTITLEMENT_MANAGER')">
                <div class="landing-page-tile-icon">
                    <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M50,33.9a6.9,6.9,0,1,0-13.373,2.371l-2.768.014.112,2.945-6.933,6.859.112,3.28.559.634,4.66-.075.037-2.237,2.2-.11V44.6l3.018-.112.075-1.416,3.169.036.171-2.626A6.9,6.9,0,0,0,50,33.9Zm-5.317-3.691A2.287,2.287,0,1,1,42.4,32.492,2.287,2.287,0,0,1,44.683,30.206Z"/><path d="M24.121,48.55H6.616V9.333H17.672l17.846,18.23A9.886,9.886,0,0,1,36.557,26.5l-3.7-3.778H37.65V21.228H31.394l-3.272-3.345h9.522V16.4H26.672L23.394,13.05H37.65V11.561H21.939L18.3,7.845H11.633V5.989H41.366V24.16a9.935,9.935,0,0,1,1.484-.148V4.5H22.672L18.3.039H5.122v50h19.05l-.02-.571ZM6.616,1.522H17.683L20.589,4.5H10.144V7.839l-.005.011H6.616Z"/></svg>
                </div>
                <div class="landing-page-tile-info">
                <h4>{{'label.userPermissions' | cvLoc}}</h4>
                    <p>{{'label.userPermissions.description' | cvLoc}}</p>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12"><h3>{{'label.dataGovernance' | cvLoc}}</h3></div>
        <div class="col-sm-12 col-md-6 col-lg-4">
            <div class="landing-page-tile cv-main-bar-flex vertical-center" data-ng-click="ediscoveryController.navigate('SDG')">
                <div class="landing-page-tile-icon">
                    <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M35.1 0H23.5a8.3 8.3 0 0 0-8.1 7.1H9a8.3 8.3 0 0 0-8.3 8.3v26.3A8.3 8.3 0 0 0 9 50h21.4a8.2 8.2 0 0 0 7.8-5.6 16.6 16.6 0 0 1-2.4-.5 5.9 5.9 0 0 1-5.5 3.7H9a6 6 0 0 1-6-6V15.6a6 6 0 0 1 6-6h21.4a6 6 0 0 1 5.8 4.8l2.4-.5a8.3 8.3 0 0 0-8.2-6.6H17.8a6 6 0 0 1 5.8-4.8h11.5a6 6 0 0 1 5.9 6v12a16 16 0 0 1 2.4.3V8.3A8.3 8.3 0 0 0 35 0z"/><path d="M7.8 18.6h15.8v1.8H7.8zM7.8 27.1H20v1.8H7.8zM7.8 35.5H20v1.8H7.8zM7.8 43.4h15.8v1.8H7.8zM45.5 40.8a2.3 2.3 0 0 0 3.3-3.3l-6.6-6.7a2.3 2.3 0 0 0-2.3-.5l-2-2a7.8 7.8 0 0 0 1.1-2 .7.7 0 0 1-.3-.2l-3.5-3.5-.2-.3a9 9 0 0 0-2.7 2 9.4 9.4 0 0 0-2 2.6l.5.2 3.4 3.5a1 1 0 0 1 .3.3 8.3 8.3 0 0 0 1.8-1.1l2 2a2.5 2.5 0 0 0 .7 2.4zM30.4 27.4H30a1.6 1.6 0 0 0-.9.3 1.5 1.5 0 0 0-.4.7.5.5 0 0 0 .2.6l2.4 2.4 1 1a.6.6 0 0 0 .5.2 1.6 1.6 0 0 0 .9-.4 1.3 1.3 0 0 0 .4-1 .3.3 0 0 0-.1-.3zM39.4 25.9a1.6 1.6 0 0 0 1-.4c.4-.4.5-1 .1-1.3l-1.1-1.1-2.3-2.3a.6.6 0 0 0-.5-.2 1.5 1.5 0 0 0-.8.4 1.3 1.3 0 0 0-.4 1.1v.2l3.5 3.5a.3.3 0 0 0 .2 0zM33 36.3h-7v1.3h7v-1.3zM27.7 38H26c-1.7.2-3 .8-3 2.8h13c0-2-1.2-2.6-3-2.8z"/></svg>
                </div>
                <div class="landing-page-tile-info">
                    <h4>{{'label.gdpr' | cvLoc}}</h4>
                    <p>{{'label.gdpr.description' | cvLoc}}</p>
                </div>
            </div>
        </div>        
        <div class="col-sm-12 col-md-6 col-lg-4">
            <div class="landing-page-tile cv-main-bar-flex vertical-center" data-ng-click="ediscoveryController.navigate('TASK_MANAGER')">
                <div class="landing-page-tile-icon">
                     <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 64 64" xml:space="preserve"><style>.st0{fill:none}</style><path class="st0" d="M55.2 49.9c0-.5.4-.9.9-.9h3.3c-.4-5.1-4.5-9.3-9.7-9.7v3.2c0 .5-.4.9-.9.9s-.8-.3-.8-.8v-3.3c-5.2.4-9.3 4.5-9.7 9.7h3.3c.5 0 .9.4.9.9s-.4.8-.9.8h-3.3c.4 5.1 4.6 9.3 9.7 9.7v-3.3c0-.5.4-.9.9-.9s.9.4.9.9v3.3c5.2-.4 9.3-4.5 9.7-9.7h-3.3c-.6.1-1-.3-1-.8zm-.1-2.7c0 .2-.2.4-.4.5l-5 3.2c-.1.1-.3.1-.5.1s-.4-.1-.6-.2l-6.3-5.7c-.2-.2-.3-.4-.3-.6 0-.2.1-.5.2-.6.3-.4.9-.4 1.2-.1l5.8 5.3 4.4-2.8c.4-.3.9-.1 1.2.3.3.2.3.4.3.6zM15.9 43.5H8.6v10h9.9v-10h-2.6z"/><path d="M24.3 16.6h13.5c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H24.3c-.5 0-.8.4-.8.8s.4.8.8.8zM24.3 21.4h18.4c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H24.3c-.5 0-.8.4-.8.8s.4.8.8.8zM24.4 30.9c-.5 0-.8.4-.8.8s.4.8.8.8h13.5c.5 0 .8-.4.8-.8s-.4-.8-.8-.8H24.4zM43.6 36.4c-.1-.4-.4-.6-.8-.6H24.4c-.5 0-.8.4-.8.8s.4.8.8.8h17.1c.7-.4 1.4-.7 2.1-1zM24.4 49h10c0-.6.1-1.1.2-1.6H24.4c-.5 0-.8.4-.8.8s.3.8.8.8zM24.4 53.9H35c-.2-.5-.3-1.1-.4-1.6H24.4c-.5 0-.8.4-.8.8s.3.8.8.8z"/><path d="M5.6 60.4c-.6 0-1.1-.6-1.1-1.3V4.9c0-.7.5-1.3 1.1-1.3h41.3c.6 0 1.1.6 1.1 1.3v30.5h1.4V4.9c0-1.6-1.1-2.9-2.6-2.9H5.6C4.2 2 3 3.3 3 4.9v54.2C3 60.7 4.2 62 5.6 62h35.9c-.8-.5-1.5-1-2.2-1.6H5.6z"/><path d="M16 11.1V9.8H8.7c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3h10c.7 0 1.3-.6 1.3-1.3v-3.3h-1.3v3.3h-10v-10H16z"/><path d="M23.1 10c-.3-.4-.8-.4-1.1-.1L15.8 16l-2.2-2.2c-.1-.1-.3-.2-.5-.2s-.4.1-.5.2c-.1.1-.2.3-.2.5s.1.4.2.5l2.7 2.7c.1.1.3.2.5.2s.4-.1.5-.2L23 11c.1-.1.2-.3.2-.5s0-.4-.1-.5zM20 33.9h-1.3v3.3h-10v-10H16v-1.3H8.7c-.7 0-1.3.6-1.3 1.3v10c0 .7.6 1.3 1.3 1.3h10c.7 0 1.3-.6 1.3-1.3v-3.3z"/><path d="M23.2 26.5c0-.2-.1-.3-.2-.5-.3-.3-.8-.3-1.1 0l-6.1 6.1-2.2-2.2c-.1-.1-.3-.2-.5-.2s-.4.1-.5.2c-.1.1-.2.3-.2.5s.1.4.2.5l2.7 2.7c.1.1.3.2.5.2s.4-.1.5-.2l6.7-6.7c.2 0 .2-.2.2-.4zM18.5 42.2H8.6c-.5 0-1 .3-1.2.8-.1.2-.1.3-.1.5v10c0 .7.6 1.3 1.3 1.3h10c.4 0 .7-.1.9-.4.2-.2.4-.6.4-.9v-10c-.1-.7-.6-1.3-1.4-1.3zm0 8v3.3H8.6v-10h10v6.7zM48.8 37.8v.5-.5c-6.7 0-12.2 5.4-12.2 12.1S42.1 62 48.8 62C55.5 62 61 56.6 61 49.9c0-6.6-5.5-12.1-12.2-12.1zm.9 22.6v-3.3c0-.5-.4-.9-.9-.9s-.8.5-.8 1v3.3c-5.2-.4-9.3-4.5-9.7-9.7h3.3c.5 0 .9-.4.9-.8s-.4-.9-.9-.9h-3.3c.4-5.2 4.6-9.3 9.7-9.7v3.3c0 .5.4.9.9.9s.9-.4.9-.9v-3.2c5.2.4 9.3 4.5 9.7 9.7h-3.3c-.5 0-.9.4-.9.9s.4.8.9.8h3.3c-.5 5-4.7 9.1-9.8 9.5z"/><path d="M53.8 46.3l-4.4 2.8-5.8-5.3c-.4-.3-.9-.3-1.2.1-.2.2-.2.4-.2.6 0 .2.1.4.3.6l6.3 5.7c.2.1.4.2.6.2.2 0 .3 0 .5-.1l5-3.2c.2-.1.3-.3.4-.5 0-.2 0-.5-.1-.6-.5-.4-1-.5-1.4-.3z"/></svg>
                </div>
                <div class="landing-page-tile-info">
                    <h4>{{'label.taskmanager' | cvLoc}}</h4>
                    <p>{{'label.taskmanager.description' | cvLoc}}</p>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12"><h3>{{'label.ediscoveryCompliance' | cvLoc}}</h3></div>
        <div class="col-sm-12 col-md-6 col-lg-4">
            <div class="landing-page-tile cv-main-bar-flex vertical-center" data-ng-click="ediscoveryController.navigate('COMPLIANCE_SEARCH')">
                <div class="landing-page-tile-icon">
                    <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 95 95"><path d="M13.8 54.41V19.73h19.9l49.34 50.4v20.19H47.79c.02 1.07.06 1.82.13 2.68h37.8V54.98l-6.7-6.84V11.03H42.7L34.83 3H11.11v51.46m9.03-37.4H13.8V5.67h19.92l5.23 5.35h-18.8v6.02zm56.2 42.4l-15.3-15.64h8.62v-2.68H58.4l-5.89-6.02h17.14v-2.68H49.9L44 26.42h25.66v-2.68H41.38l-6.55-6.69h-12v-3.34h53.52v45.75zm6.7 6.83l-4.01-4.1V51.98l4 4.1v10.21z"/><path fill="none" d="M27.73 57.83h-.01l-.38.1.4-.09v-.01z"/><path d="M50.7 67.58h-4.06c-.35-1.17-.83-2.3-1.44-3.37l2.9-2.9c.62-.61.62-1.61 0-2.23l-3.95-3.95a1.6 1.6 0 0 0-2.22 0l-2.96 2.95a16.28 16.28 0 0 0-3.32-1.36v-4.2c0-.87-.7-1.57-1.57-1.57h-5.6c-.87 0-1.58.7-1.57 1.57v4.17c-1.17.32-2.3.78-3.36 1.35l-2.92-2.92a1.6 1.6 0 0 0-2.22 0l-3.96 3.96a1.57 1.57 0 0 0 0 2.22l2.84 2.84a15.57 15.57 0 0 0-1.49 3.44h-3.95c-.87 0-1.57.7-1.57 1.57v5.6c0 .87.7 1.57 1.57 1.57h3.83c.33 1.26.82 2.47 1.44 3.6l-2.67 2.68a1.57 1.57 0 0 0 0 2.22l3.96 3.96c.6.6 1.62.6 2.22 0l2.62-2.63c1.15.66 2.38 1.17 3.65 1.52v3.71c0 .87.71 1.56 1.58 1.56h5.6c.86 0 1.57-.7 1.57-1.56v-3.73c1.26-.37 2.47-.88 3.61-1.54l2.67 2.66c.58.6 1.63.6 2.22 0l3.96-3.95c.61-.61.61-1.6 0-2.22l-2.75-2.75a15.8 15.8 0 0 0 1.4-3.53h3.94c.87 0 1.58-.7 1.58-1.57v-5.6c0-.86-.71-1.57-1.58-1.57zm-22.98-9.75h.01v.01l-.4.1c.14-.04.26-.08.39-.1zm3.81 24.33a9.64 9.64 0 0 1-9.62-9.63c0-5.3 4.32-9.62 9.62-9.62 5.3 0 9.63 4.32 9.63 9.62a9.64 9.64 0 0 1-9.63 9.63z"/><path d="M31.53 65.41a7.13 7.13 0 1 0 .01 14.26 7.13 7.13 0 0 0 0-14.26z"/></svg>
                </div>
                <div class="landing-page-tile-info">
                    <h4>{{'label.complianceSearch' | cvLoc}}</h4>
                    <p>{{'label.complianceSearch.description' | cvLoc}}</p>
                </div>
            </div>
        </div>
        <%-- Case manager has been enabled for SP15. To disable it again based on a key, use data-ng-if="ediscoveryController.isFeatureEnabled('enableCaseManager')" --%>
        <div class="col-sm-12 col-md-6 col-lg-4">
            <div class="landing-page-tile cv-main-bar-flex vertical-center" data-ng-click="ediscoveryController.navigate('CASE_MANAGER')">
                <div class="landing-page-tile-icon">
                    <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M35.1 0H23.5a8.3 8.3 0 0 0-8.1 7.1H9a8.3 8.3 0 0 0-8.3 8.3v26.3A8.3 8.3 0 0 0 9 50h21.4a8.2 8.2 0 0 0 7.8-5.6 16.6 16.6 0 0 1-2.4-.5 5.9 5.9 0 0 1-5.5 3.7H9a6 6 0 0 1-6-6V15.6a6 6 0 0 1 6-6h21.4a6 6 0 0 1 5.8 4.8l2.4-.5a8.3 8.3 0 0 0-8.2-6.6H17.8a6 6 0 0 1 5.8-4.8h11.5a6 6 0 0 1 5.9 6v12a16 16 0 0 1 2.4.3V8.3A8.3 8.3 0 0 0 35 0z"/><path d="M7.8 18.6h15.8v1.8H7.8zM7.8 27.1H20v1.8H7.8zM7.8 35.5H20v1.8H7.8zM7.8 43.4h15.8v1.8H7.8zM45.5 40.8a2.3 2.3 0 0 0 3.3-3.3l-6.6-6.7a2.3 2.3 0 0 0-2.3-.5l-2-2a7.8 7.8 0 0 0 1.1-2 .7.7 0 0 1-.3-.2l-3.5-3.5-.2-.3a9 9 0 0 0-2.7 2 9.4 9.4 0 0 0-2 2.6l.5.2 3.4 3.5a1 1 0 0 1 .3.3 8.3 8.3 0 0 0 1.8-1.1l2 2a2.5 2.5 0 0 0 .7 2.4zM30.4 27.4H30a1.6 1.6 0 0 0-.9.3 1.5 1.5 0 0 0-.4.7.5.5 0 0 0 .2.6l2.4 2.4 1 1a.6.6 0 0 0 .5.2 1.6 1.6 0 0 0 .9-.4 1.3 1.3 0 0 0 .4-1 .3.3 0 0 0-.1-.3zM39.4 25.9a1.6 1.6 0 0 0 1-.4c.4-.4.5-1 .1-1.3l-1.1-1.1-2.3-2.3a.6.6 0 0 0-.5-.2 1.5 1.5 0 0 0-.8.4 1.3 1.3 0 0 0-.4 1.1v.2l3.5 3.5a.3.3 0 0 0 .2 0zM33 36.3h-7v1.3h7v-1.3zM27.7 38H26c-1.7.2-3 .8-3 2.8h13c0-2-1.2-2.6-3-2.8z"/></svg>
                </div>
                <div class="landing-page-tile-info">
                    <h4>{{'label.casemanager' | cvLoc}}</h4>
                    <p>{{'label.casemanager.description' | cvLoc}}</p>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12"><h3>{{'label.categories.settings' | cvLoc}}</h3></div>
        <div class="col-sm-12 col-md-6 col-lg-4">
            <a href="#/inventoryManager">
                <div class="landing-page-tile cv-main-bar-flex vertical-center">
                    <div class="landing-page-tile-icon">
                          <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50">
                        <path d="M50 30.2v-.1a.4.4 0 0 0-.3-.5l-6-2.9V15.5a.6.6 0 0 0-.4-.5l-8.6-3.6V5.5a.4.4 0 0 0-.3-.5L25.7.8h-.5L16.6 5l-.1.1-.2.1v6.1l-9 3.8a.6.6 0 0 0-.4.5v11l-6.6 3H0v10.9a.6.6 0 0 0 .3.4l8.6 5h.7l4-2.3.1.1 11.9 5.5h.4l11-5.3 3.5 2h.6l8.6-4.9a.6.6 0 0 0 .3-.5V30.2zM33.5 11.6a.3.3 0 0 0 0 .3v3.6l-7.5 4.3v-9l7.5-4.3zM17.3 6.3l7.6 4.3v9.2l-7.6-4.3zM9.4 34.5l-7.7-4.3 7.5-3.5 7.6 3.5zm.4 1.1l7.6-4.3v9L10 44.5zm15.9 12.6l-11-5.1 3.5-2a.6.6 0 0 0 .3-.5V30.1a.5.5 0 0 0-.3-.5l-8.7-4.1h-.4L8 26V16l8.2-3.5v3.3a.5.5 0 0 0 .3.5l8.6 4.8h.7l8.6-4.9a.5.5 0 0 0 .3-.4v-3.3l7.8 3.4v10.3l-1.5-.7h-.5L32 29.7h-.4v10.8a.6.6 0 0 0 .3.5l4 2.3zm14.4-3.6L37.5 43a.5.5 0 0 0-.5-.3l-4.5-2.5V31l7.6 4.3zm.8-10L33.2 30l7.5-3.5 7.6 3.5z"/></svg>
                        <path d="M21.55 38.65H8.75a.79.79 0 0 0-.8.8.86.86 0 0 0 .8.8h12.9a.86.86 0 0 0 .8-.8.88.88 0 0 0-.9-.8zM21.55 31.45H8.75a.86.86 0 0 0-.8.8.79.79 0 0 0 .8.8h12.9a.86.86 0 0 0 .8-.8.88.88 0 0 0-.9-.8zM21.55 24.15H8.75a.8.8 0 1 0 0 1.6h12.9a.86.86 0 0 0 .8-.8.88.88 0 0 0-.9-.8zM21.55 17H8.75a.8.8 0 1 0 0 1.6h12.9a.86.86 0 0 0 .8-.8.88.88 0 0 0-.9-.8z"/>
                        <path d="M36.05 25.85V9.75a3.93 3.93 0 0 0-3.9-4h-4.1v-.9a1.58 1.58 0 0 0-1.6-1.6H24v-.8a2.21 2.21 0 0 0-2.2-2.4h-5a2.43 2.43 0 0 0-2.4 2.4v.8H12a1.58 1.58 0 0 0-1.6 1.6v.8h-4a3.93 3.93 0 0 0-4 3.9v34.7a3.93 3.93 0 0 0 3.9 4h23.1a11.67 11.67 0 0 0 6.1 1.7 12 12 0 0 0 12.2-12v-.1a12.09 12.09 0 0 0-11.65-12zM12 4.85h3.2a.77.77 0 0 0 .8-.7v-1.7a.77.77 0 0 1 .7-.8h4.9a.86.86 0 0 1 .8.8v1.6a.77.77 0 0 0 .7.8h3.3v5.6H12zm-5.7 41.9a2.35 2.35 0 0 1-2.4-2.3V9.75a2.35 2.35 0 0 1 2.3-2.4h4.1v3.2a1.58 1.58 0 0 0 1.6 1.6h14.5a1.58 1.58 0 0 0 1.6-1.6v-3.3h4a2.43 2.43 0 0 1 2.4 2.4v16.1a12.24 12.24 0 0 0-11.1 12 12 12 0 0 0 3.8 8.9zm29.3 1.4A10.2 10.2 0 1 1 45.75 38a10.24 10.24 0 0 1-10.2 10.15z"/><path d="M40.15 38.49h-3.7v-5.6a.82.82 0 0 0-.8-.9h-.1a1.06 1.06 0 0 0-1 .9v6.6a.82.82 0 0 0 .8.9h4.8a.9.9 0 0 0 .9-.9.92.92 0 0 0-.9-1zM27.17 20.25a.8.8 0 0 1-.55-.22L25 18.56a.8.8 0 1 1 1.09-1.17l.95.89L29.73 15a.82.82 0 0 1 1.13-.12A.81.81 0 0 1 31 16l-3.21 4a.85.85 0 0 1-.57.3zM27.32 27.32a.82.82 0 0 1-.55-.22l-1.57-1.47a.79.79 0 0 1 0-1.13.8.8 0 0 1 1.13 0l.95.89 2.64-3.28A.82.82 0 0 1 31 22a.81.81 0 0 1 .12 1.13L27.94 27a.85.85 0 0 1-.57.3z"/></svg>
                    </div>
                    <div class="landing-page-tile-info">
                        <h4>{{'label.inventorymanager' | cvLoc}}</h4>
                        <p>{{'label.inventorymanager.description' | cvLoc}}</p>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-sm-12 col-md-6 col-lg-4">
            <a href="#/entityManager">
                <div class="landing-page-tile cv-main-bar-flex vertical-center">
                    <div class="landing-page-tile-icon">
                          <svg class="svg-primary-fill" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><path d="M37.6 37.5v10.8H1.7V1.7h24.2v11.6h11.7V19a8.5 8.5 0 0 1 1.6-.3v-6.5L27.1 0H0v50h39.2V37.9a8.5 8.5 0 0 1-1.6-.4zM27.6 3l8.8 8.8h-8.8z"/><circle cx="17.4" cy="10.7" r="3.2"/><circle cx="20" cy="27.7" r="3.2"/><circle cx="15.1" cy="40.3" r="3.2"/><path d="M12.5 11.5h-8a.8.8 0 0 1 0-1.6h8a.8.8 0 1 1 0 1.6zM9 20.3H4.7a.8.8 0 0 1 0-1.6H9a.8.8 0 1 1 0 1.6zM21.3 20.3h-4a.8.8 0 1 1 0-1.6h4a.8.8 0 0 1 0 1.6zM14.4 28.5H8.8a.8.8 0 0 1 0-1.6h4.6a.8.8 0 0 1 0 1.6zM19 35.1H4.7a.8.8 0 0 1 0-1.6H19a.8.8 0 0 1 0 1.6zM10 41.8H8.3a.8.8 0 0 1 0-1.6H10a.8.8 0 1 1 0 1.6zM27.5 41.8h-6a.8.8 0 1 1 0-1.6h6a.8.8 0 0 1 0 1.6z"/><circle cx="13.1" cy="19.5" r=".8"/><circle cx="4.8" cy="41" r=".8"/><circle cx="22.1" cy="34.3" r=".8"/><circle cx="4.8" cy="27.7" r=".8"/><path d="M49.6 21l-6.8-2.5h-.3L35.6 21a.4.4 0 0 0-.3.4v4.8c0 6.3 1 8.6 7.1 11.7h.4C49 34.7 50 32.5 50 26.2v-4.9a.4.4 0 0 0-.4-.3zM42 23.5h.1a2 2 0 0 1 .4 0 2 2 0 0 1 2 2 2 2 0 0 1-1.6 2 1.8 1.8 0 0 1-.4 0 2 2 0 0 1-.5-4zm4.2 7a1 1 0 0 1-1 1H40a1 1 0 0 1-.9-1v-.2a1.8 1.8 0 0 1 .9-1.6 5 5 0 0 1 5.5 0 1.8 1.8 0 0 1 .9 1.6zM19 39.1l-.4-.8.8-.4.4.8zm1.6-.8l-.4-.8.8-.4.4.8zm1.6-.8l-.4-.8.8-.4.4.8zm1.6-.8l-.4-.8.8-.4.4.8zm1.6-.8L25 35l.8-.5.4.8zm1.7-.9l-.4-.8.8-.4.4.8zm1.6-.8l-.4-.8.8-.4.4.8zm1.6-.8l-.4-.8.8-.4.4.8zm1.6-.8l-.4-.8.8-.5.4.8zm1.6-.9L33 31l.8-.4.4.8zM35 31l-.4-.8h.1l.4.7zM34.2 28.3h-.7v-1h.7zm-1.6 0h-.9v-1h.9zm-1.8 0h-.9v-1h.9zm-1.8 0h-.9v-1h.9zm-1.8 0h-.9v-1h.9zm-1.8 0h-.9v-1h.9zM34 26.5l.5-.7zm-.8-.6l-.6-.6.6-.7.7.6zM32 24.6l-.6-.6.6-.7.7.7zm-1.3-1.2l-.6-.6.6-.7.7.6zm-1.3-1.2l-.6-.7.6-.6.6.6zM28 20.9l-.7-.6.7-.6.6.6zm-1.3-1.2l-.7-.6.6-.7.7.7zm-1.3-1.2l-.7-.7.6-.6.7.6zM24 17.2l-.7-.6.6-.6.7.6zM22.8 16l-.7-.6.6-.7.7.7zm-1.3-1.2l-.7-.7.6-.6.7.6z"/></svg>
                    </div>
                    <div class="landing-page-tile-info">
                        <h4>{{'label.entitymanager' | cvLoc}}</h4>
                        <p>{{'label.entitymanager.description' | cvLoc}}</p>
                    </div>
                </div>
            </a>
        </div>
    </div>
</div>
