<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-xs-12 col-md-12 col-lg-12 data-source-setup">
		<div class="padding-bottom-10">
			<h1 class="page-title">
				{{::setup.title}}
				<cv-help-component help-text="{{setup.helpText}}"></cv-help-component>
			</h1>
			<span class="margin-left-10" data-ng-if="(setup.steps[setup.getCurrentStep()].name === ('label.selectFileServer' | cvLoc) || setup.steps[setup.getCurrentStep()].name === ('label.selectClientGroup' | cvLoc)) && inventoryActiveJob">
				<span class="spinner-sm inline-block vertical-middle"></span>
				<span class="margin-left-5"><cv:msg key="label.assets.dataCollectionJobRunning" bundle="ediscovery" /></span>
			</span>
			<a class="page-action-item margin-0 margin-right-10" data-ng-if="(setup.steps[setup.getCurrentStep()].name === ('label.selectFileServer' | cvLoc) || setup.steps[setup.getCurrentStep()].name === ('label.selectClientGroup' | cvLoc))&& !inventoryActiveJob" data-ng-click="refreshInventory()">{{'label.refreshInventory' | cvLoc}}</a>
			<ul class="steps group text-center create-profile-steps" data-setup-steps>
				<li style="width: 50%;" data-ng-repeat="mystep in setup.steps" data-ng-class="{'current': setup.getCurrentStep() == $index, 'done': setup.getCurrentStep() > $index}">
					<span class="step-name">{{mystep.name}}</span>
				</li>
			</ul>
		</div>
		<div class="setup-panel">
			<div class="set-up-page">
				<div data-ng-repeat="step in setup.steps track by $index" data-ng-show="setup.getCurrentStep() === $index" data-ng-class="step.removePanel? '':'panel panel-default'"><div cv-static-include="{{step.template}}"></div></div>
			</div>
		</div>
		<div class="button-container margin-top-20 margin-bottom-20">
			<button id="dataSourceSetup_button_#4344" class="btn btn-default" 
				data-ng-click="setup.previousStep()">
				{{setup.previousStepName}}
			</button>
			<button id="dataSourceSetup_button_#7143" class="btn btn-primary" 
				data-ng-if="setup.getCurrentStep()<=setup.steps.length"
				data-ng-click="setup.nextStep()"
				data-ng-disabled="setup.stepValidator()">
				{{setup.nextStepName}}
			</button>
		</div>
	</div>
</div>