<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.ediscovery">
<div>
	<div class='setup-title'>
		<h1><cv:msg key="label.addFileServerDataSource" bundle="ediscovery" /> </h1>
	</div>
	<span class="serverMessage" data-ng-class="{{errorMessage.type}}">{{errorMessage.message}}</span>
	<div class="setup-content ediscovery-addasset-content">
		<form name="addFileServerForm" novalidate cv-hide-api data-cv-submit="save()" autocomplete="off" id="addFileServerForm" class="edit-users-grid-form">
			<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
			<div class="global-options remove-border-padding">
				<label for="name" class="row">
					<span class="col-xs-4 padding-top-5"><fmt:message key="label.displayName" /></span>
					<div class="col-xs-8">
						<input  class="full-width" type="text" id="name" name="name" data-ng-model="model.name" data-ng-class="{'has-error': cv.addFileServerForm.needsAttention(addFileServerForm.name)}" required autofocus />
					</div>
						<span class="help-block" data-ng-show="cv.addFileServerForm.needsAttention(addFileServerForm.name)"><fmt:message key="error.name" /></span>
				</label>
			</div>
			<div class="global-options remove-border-padding">
				<label for="domainName" class="row">
					<span class="col-xs-4 padding-top-5">
							<cv-help-text help-time="10" help-direction="bottom-left" help-text="'<cv:msg key='info.fqdn' bundle='ediscovery'/>'"
							help-label="<cv:msg key="label.fqdn" bundle="ediscovery" />"></cv-help-text>
					</span>
					<div class="col-xs-8">
						<input  class="full-width" type="text" id="domainName" placeholder="<cv:msg key='placeholder.fqdn' bundle='ediscovery' />" name="domainName" data-ng-model="model.domainName" ng-model-options="{ updateOn: 'blur' }" data-ng-class="{'has-error': cv.addFileServerForm.needsAttention(addFileServerForm.domainName)}" />
					</div>
				</label>
			</div>
			<div class="global-options remove-border-padding">
				<label for="ipAddress" class="row">
					<span class="col-xs-4 padding-top-5"><fmt:message key="label.ipAddress" /></span>
					<div class="col-xs-8">
						<input  class="full-width" type="text" id="ipAddress" name="ipAddress" data-ng-model="model.ipAddress" data-ng-pattern="/\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b/" data-ng-class="{'has-error': cv.addFileServerForm.needsAttention(addFileServerForm.ipAddress)}" required />
					</div>
					<span class="help-block" data-ng-show="cv.addFileServerForm.needsAttention(addFileServerForm.ipAddress)"><fmt:message key="error.ipAddress" /></span>

				</label>
			</div>
			<div class="global-options remove-border-padding">
				<label for="osTypeWINDOWS" class="row">
					<span class="col-xs-4 padding-top-5">
						<cv:msg key="label.osType" bundle="serversJs"/>
					</span>
					<div class="col-xs-8">
					<isteven-multi-select
					directive-id="operatingSystem"
					input-model="osTypes"
					output-model="model.selectedOSType"
					button-label="name"
					item-label="name"
					selection-mode="single"
					tick-property="selected"
					translation="localLang"
					helper-elements="filter"
					search-property="name"
					min-search-length="1"
					is-required="true">
					</isteven-multi-select>

					</div>
				</label>
			</div>
 			<div class="global-options remove-border-padding">
				<label for="country" class="row">
					<span class="col-xs-4 padding-top-5">
						<cv:msg key="label.countryName" bundle="ediscovery"/>
					</span>
					<div class="col-xs-8">
						<isteven-multi-select
						directive-id="country"
						input-model="inventoryCountries"
						output-model="selectedCountriesStub"
						button-label="countryName"
						item-label="countryName"
						selection-mode="single"
						tick-property="selected"
						translation="localLang"
						helper-elements="filter"
						search-property="countryName"
						min-search-length="1"
						on-item-click="assignCountry(data)"
						is-required="(createInventory || (createDataSource && selectedFileServers.length == 1))">
						</isteven-multi-select>
						<input type="text" id="country" ng-model="selectedCountriesStub" name="country" style="display:none" data-ng-required="(createInventory || (createDataSource && selectedFileServers.length == 1))" />
					</div>
					<span class="help-block" data-ng-if="cv.addFileServerForm.needsAttention(addFileServerForm.country)">
					<cv:msg key="error.selectCountry" bundle="ediscovery" />
					</span>
				</label>
			</div>
			<div class='button-container'>
				<button id="addFileServerInventory_button_#5907" type='button' class='btn cvBusyOnAjax' data-ng-click='cancel()'><cv:msg key="Cancel" bundle="messages"/></button> 
				<button id="addFileServerInventory_button_#1540" type='submit' class='btn btn-primary cvBusyOnAjax' ><cv:msg key="Save" bundle="messages"/></button> 
			</div>
		</form>
	</div>
</div>
</fmt:bundle>
