<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
        <cv:msg key="label.complianceSearch.preference" bundle="ediscovery"></cv:msg>
    </h1>
</div>
<div class="bootstrap-wrapper">
	<p class="{{model.error.type}} serverMessage" data-ng-bind="model.error.message"></p>
	<form name="preferenceForm" id="preferenceForm" cv-hide-api data-cv-submit="model.onSave()" novalidate autocomplete="off">
		<div>
			<div class="form-group">
				<label for="searchEngine" class="col-xs-12 col-md-4 col-lg-4">
					<cv:msg key="label.searchEngine" bundle="ediscovery" /></label>
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<isteven-multi-select 
					input-model="model.indexServers"
					output-model="model.selectedIndexServer"
					button-label="engineName"
					item-label="engineName"
					tick-property="ticked"
					selection-mode="single"
					group-property="msGroup"
					class="isteven-multi-select user-group-select"
					id="searchEngine"
					name="searchEngine"
					max-labels="3"
					translation="model.entitiesText"
					helper-elements="{{model.helperElements}}" 
					>
				</isteven-multi-select>
				<input type="text" ng-model="model.selectedIndexServer" name="inputIndexServer" style="display:none" required />
				<div data-ng-show="cv.preferenceForm.needsAttention(preferenceForm.searchEngine)">
					<span class="help-block" data-ng-show="preferenceForm.inputIndexServer.$error.required">
						<cv:msg key="error.getAnalyticsEngine" bundle="ediscovery" />
					</span>
				</div>
				</div>
			</div>
			<div class="form-group" data-ng-if="model.applicationTypes" >
				<label for="applicationType" class="col-xs-12 col-md-4 col-lg-4">
					<cv:msg key="label.complianceSearch.defaultSearchView" bundle="ediscovery" /></label>
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
				<isteven-multi-select 
                    html-template="true"
                    input-model="model.applicationTypes"
                    output-model="model.targetApp"
                    button-label="name"
                    item-label="name"
                    tick-property="ticked"
                    group-property="msGroup"
                    class="isteven-multi-select search-type-select"
                    id="applicationType"
                    name="applicationType"
                    max-labels="3"
                    translation="model.entitiesText"
                    selection-mode="single"
                    on-close="model.onApplicationTypeChanged()"
                    helper-elements="{{model.helperElements}}" 
                    >
                </isteven-multi-select>
				<input type="text" ng-model="model.targetApp" name="targetApp" style="display:none" required />
				<div data-ng-show="cv.preferenceForm.needsAttention(preferenceForm.targetApp)">
					<span class="help-block" data-ng-show="preferenceForm.targetApp.$error.required">
						<cv:msg key="error.getAnalyticsEngine" bundle="ediscovery" />
					</span>
				</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
            <button id="preferenceModal_button_#8590" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="exchange"/></button> 
			<button id="preferenceModal_button_#3010" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="model.cancel()"><cv:msg key="action.cancel" bundle="exchange"/></button> 
		</div>
	</form>
</div>
