<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
        <cv:msg key="label.casemanager.manageTags" bundle="ediscovery"></cv:msg>
    </h1>
</div>
<div class="padding-15">
	<div class="details-right-pane">
		<div class="deail-header">
			<h4 class="padding-10 margin-10">
				<span><cv:msg key="label.tags" bundle="tags" /></span>
				<span class="badge badge-wide pull-right">{{model.groupedTags.length}}</span>
			</h4>
		</div>
		<uib-accordion>
			<div uib-accordion-group is-open="status.open" data-ng-repeat="tag in model.groupedTags track by $index" class="review-page-tag-accordion">
				<uib-accordion-heading>
					<span class="case-review-page-tag no-margin" data-ng-mouseenter="hover = true" data-ng-mouseleave="hover = false">
						{{tag.name}}
						<span class="glyphicon glyphicon-remove review-page-tag-remove-icon" data-ng-if="hover" data-ng-click="model.onRemoveTag(tag, $event)"></span>
					</span>
					<i class="pull-right glyphicon" ng-class="{'glyphicon-chevron-down': status.open, 'glyphicon-chevron-right': !status.open}"></i>
					<span class="badge badge-wide pull-right">{{tag.files.length}}</span>
				</uib-accordion-heading>
				<ul class="review-page-tag-list">
					<li data-ng-repeat="file in tag.files">
						<span class="glyphicon glyphicon-file padding-right-5"></span>
						<span>{{file.name}}</span>
					</li>
				</ul>
			</div>
		</uib-accordion>
		<div class="pull-right padding-right-10 margin-top-10">
			<a href="" data-ng-click="model.onRemoveAllTags()"><cv:msg key="label.removeAll" bundle="profiles" /></a>
		</div>
	</div>
</div>
