<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div data-ng-if="model.bReadOnly">
    {{model.name}}
</div>
<div data-ng-if="!model.bReadOnly">
     <div class="form-group">
         <label class="col-xs-12 col-lg-2 col-md-2" for="keyword">
             <cv:msg
                     key="label.casemanager.keyword" bundle="ediscovery" />
         </label>
         <div class="col-xs-12 col-lg-10 col-md-10">
             <input type="text" name="keyword"
                 autofocus
                 data-ng-model="model.keyword"
                 data-ng-change="model.onKeywordChange()"
                 ng-model-options="{ updateOn: 'blur' }"
                 id="keyword" />
         </div>
     </div>
    <div id="filterArea">
        <uib-accordion close-others="false" class="search-filter-accordion text-left" data-ng-if="model.filterGroups.length > 0" data-ng-show="model.isFilterAdded()">
            <div uib-accordion-group class="search-filter-accordion-group" data-ng-repeat="filterGroup in model.filterGroups" data-ng-show="filterGroup.addedFilters.length > 0" data-ng-init="filterGroup.isOpen=true" is-open="filterGroup.isOpen">
                <div uib-accordion-heading>
                    <i class="glyphicon float-right"
                        data-ng-class="filterGroup.isOpen ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right'"></i>
                    <span>{{filterGroup.text}} ({{filterGroup.addedFilters.length}}) </span>
                </div>
                <div class="cv-flex form-group" data-ng-show="filterGroup.addedFilters.length > 1 && filterGroup.interGroupOperators.length > 0">
                    <label for="interOperatorDropdown" class="margin-left-15">
                            {{'label.casemanager.interGroupOp'| cvLoc }}
                    </label>
                    <div>
                        <select id="interOperatorDropdown" class="margin-left-15" data-ng-model="filterGroup.selectedInterGroupOperator" data-ng-change="filterGroup.onInterGroupFilterChange()"
                            data-ng-options="operator as operator.text for operator in filterGroup.interGroupOperators">
                        </select>
                    </div>
                </div>
                <div class="form-group" data-ng-repeat="addedFilter in filterGroup.addedFilters track by $index">
                        <label class="col-xs-12 col-lg-2 col-md-2" for="ctrl-{{$index}}">
                            {{addedFilter.text}}
                        </label>
                        <div data-ng-if="addedFilter.type === 'text'" class="col-xs-12 col-lg-8 col-md-8">
                                <input type="text" name="ctrl-text-{{$index}}"
                                    autofocus
                                    data-ng-change="filterGroup.onChange(addedFilter)"
                                    data-ng-model="addedFilter.value"
                                    ng-model-options="{ updateOn: 'blur' }"
                                    id="ctrl-{{$index}}" />
                        </div>
                        <div data-ng-if="addedFilter.type === 'number'" class="col-xs-12 col-lg-8 col-md-8">
                                <input name="ctrl-number-{{$index}}"
                                    type="number" id="ctrl-{{$index}}-from" class="full-width"
                                    autofocus
                                    data-ng-change="filterGroup.onChange(addedFilter)"
                                    data-ng-min="addedFilter.min"
                                    data-ng-max="addedFilter.max"
                                    data-ng-model="addedFilter.value"
                                    ng-model-options="{ updateOn: 'blur' }"
                                    id="ctrl-{{$index}}" />
                        </div>
                        <div data-ng-if="addedFilter.type === 'textarea'" class="col-xs-12 col-lg-9 col-md-9">
                                <textarea name="ctrl-textarea-{{$index}}"
                                    row="10"
                                    autofocus
                                    data-ng-change="filterGroup.onChange(addedFilter)"
                                    data-ng-model="addedFilter.value"
                                    ng-model-options="{ updateOn: 'blur' }"
                                    id="ctrl-{{$index}}" ></textarea>
                                <div class="text-align-center margin-top-10">
                                    <span><a data-ng-click="filterGroup.validateQuery()">{{'label.casemanager.filter.validateQuery' | cvLoc}}</a></span>
                                </div>
                                <div class="margin-top-5">
                                    <span class="{{filterGroup.queryOutput.type}} serverMessage" data-ng-bind="filterGroup.queryOutput.message"></span>
                                </div>
                        </div>
                        <div data-ng-if="addedFilter.type === 'usersuggest'" class="col-xs-12 col-lg-8 col-md-8">
                            <cv-user-suggestions id="ctrl-{{$index}}" users="addedFilter.value" on-change="filterGroup.onSuggestTextChange(addedFilter,value)" />
                        </div>
                        <div data-ng-if="addedFilter.type === 'usergroupssuggest'" class="col-xs-12 col-lg-8 col-md-8">
                            <cv-user-suggestions id="ctrl-{{$index}}" users="addedFilter.value" on-change="filterGroup.onSuggestTextChange(addedFilter,value)" />
                            <div>
                                <input id="expandGroups" type="checkbox" data-ng-model="addedFilter.expandUserGroups" data-ng-change="addedFilter.onExpandGroupsChanged()" >
                                <label for="expandGroups">{{'label.casemanager.expandGroups'|cvLoc}}</label>
                            </div>
                        </div>
                        <div data-ng-if="addedFilter.type === 'select'" class="col-xs-12 col-lg-8 col-md-8">
                            <isteven-multi-select
                                input-model="addedFilter.selectionItems"
                                output-model="addedFilter.selectedItem"
                                button-label="text"
                                item-label="text"
                                tick-property="ticked"
                                selection-mode="single"
                                group-property="msGroup"
                                class="isteven-multi-select user-group-select"
                                id="selection-{{$index}}"
                                name="selection-{{$index}}"
                                on-item-click="filterGroup.onChange(addedFilter)"
                                max-labels="3"
                                translation="filterGroup.entitiesText"
                                helper-elements="{{filterGroup.helperElements}}"
                                >
                            </isteven-multi-select>
                        </div>
                        <div data-ng-if="addedFilter.type === 'timerange'" class="col-xs-12 col-lg-8 col-md-8">
                            <time-range start-date="addedFilter.startDate" end-date="addedFilter.endDate" on-change="filterGroup.onTimeFilterChange(addedFilter,startDate,endDate)"></time-range>
                        </div>
                        <div data-ng-if="addedFilter.type === 'numberrange'" class="col-xs-12 col-lg-8 col-md-8">
                            <div class="row margin-left-15">
                                <div class="col-lg-6 padding-0">
                                    <input type="number" id="ctrl-{{$index}}-from" class="full-width" data-ng-model="addedFilter.startValue" data-ng-change="filterGroup.onChange(addedFilter)">
                                </div>
                                <div class="col-lg-6">
                                    <input type="number" id="ctrl-{{$index}}-to" class="full-width" data-ng-model="addedFilter.endValue" data-ng-change="filterGroup.onChange(addedFilter)">
                                </div>
                            </div>
                        </div>
                        <div data-ng-if="addedFilter.type === 'match'">
                            <div class="col-xs-12 col-lg-5 col-md-5">
                                    <input type="text" name="ctrl-{{$index}}"
                                        autofocus
                                        data-ng-model="addedFilter.value"
                                        data-ng-change="filterGroup.onChange(addedFilter)"
                                        ng-model-options="{ updateOn: 'blur' }"
                                        id="ctrl-match-{{$index}}" />
                            </div>
                            <div class="col-xs-12 col-lg-3 col-md-3">
                                    <select data-ng-model="addedFilter.selectedMatchOption" data-ng-attr-title="{{addedFilter.selectedMatchOption.text}}"
                                    data-ng-change="filterGroup.onChange(addedFilter)" data-ng-options="option as option.text for option in addedFilter.matchOptions">
                                    </select>
                            </div>
                        </div>
                        <div>
                            <select data-ng-if="addedFilter.operators.length > 1" id="ctrl-{{$index}}-operatorDropdown" data-ng-model="addedFilter.selectedOperator" data-ng-change="filterGroup.onOperatorChange(addedFilter)"
                                data-ng-options="operator as operator.text for operator in addedFilter.operators" class="search-filter-operator">
                            </select>
                            <label data-ng-if="addedFilter.operators.length === 1" class="margin-left-5 margin-right-10 case-operator-label">{{addedFilter.selectedOperator.text}}</label>
                            <span><a data-ng-click="filterGroup.removeFilter(addedFilter.index)"
                                    title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{addedFilter.text | trimFolderName}}"><span class="glyphicon glyphicon-remove"></span></a></span>
                        </div>
                </div>
            </div>
        </uib-accordion>
            <%-- <div class="form-group margin-bottom-0" data-ng-show="!model.isFilterAdded()">
                <div class="cv-flex horizontal-center margin-top-30" ng-bind-html="model.noFilterSvg">
                </div>
                <h4 class="cv-flex horizontal-center margin-bottom-0">
                    {{'label.noFiltersAdded' | cvLoc }}
                </h4>
            </div> --%>
        <div class="form-group margin-top-20">
            <label class="col-xs-12 col-lg-2 col-md-2 " for="criteria">
                <cv:msg
                        key="label.casemanager.addCriteria" bundle="ediscovery" />
            </label>
            <div class="col-xs-12 col-lg-10 col-md-10">
                <isteven-multi-select
                html-template="true"
                input-model="model.uiFilters"
                output-model="model.selectedFilters"
                button-label="text"
                item-label="text"
                tick-property="ticked"
                group-property="msGroup"
                class="isteven-multi-select search-filter"
                id="queryFilter"
                name="queryFilter"
                max-labels="3"
                translation="model.entitiesText"
                on-close="model.addFilters()"
                helper-elements="{{model.helperElements}}"
                >
                </isteven-multi-select>
            </div>
        </div>
    </div>
</div>
