<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.eca.create" bundle="ediscovery"/></h1>
</div>
<div class="setup-content server-plan" data-ng-controller="userAndGroupInviteController">
	<span class="server-message {{createEcaMessage.type}}">{{earlyCaseAssessmentInfo.errorMessage}}</span>
	<form name="createEarlyCaseAssessmentForm" cv-hide-api data-cv-submit="createEarlyCaseAssessment()" novalidate autocomplete="off">
		
		<!-- // name // -->
		<div class="global-options remove-border-padding">	
			<label for="assessmentName"><cv:msg key="label.name" bundle="ediscovery" />
				<input type="text" name="assessmentName" data-ng-model="earlyCaseAssessmentInfo.name" id="assessmentName" data-autoselect="{{autoSelect}}" autofocus /> 
			</label>	
		</div>
		
		<!-- // description // -->
		<div class="global-options remove-border-padding">	
			<label for="assessmentDescription"><cv:msg key="label.description" bundle="ediscovery" />
				<input type="text" name="assessmentDescription" data-ng-model="earlyCaseAssessmentInfo.description" id="assessmentDescription" data-autoselect="{{autoSelect}}" autofocus /> 
			</label>	
		</div>
		
		<!-- // Select survey // -->	
		<div class="global-options remove-border-padding">
			<label for="assessmentSurvey" class="select-label"><cv:msg key="label.eca.survey" bundle="ediscovery"/>
			 	<select id=assessmentSurvey name="assessmentSurvey" data-ng-model="earlyCaseAssessmentInfo.selectedEcaTemplate"
					data-ng-options="survey.title for survey in ecaTemplates">
					<option value=""><cv:msg key="placeholder.eca.selectSurvey" bundle="ediscovery"/></option>
				</select>
			</label>
		</div>
		
		
		<!-- // Adding participants to the survey // -->	
		<h4><cv:msg key="label.eca.participants" bundle="ediscovery"/></h4>	
		<div class="global-options remove-border-padding">
			<div id="emailErrorMessage" class="invite-error-message error serverMessage"><cv:msg key="error.validEmailError" bundle="alertsJs"/></div>
			<div class="user-invite-dailog" data-ng-class="{'invite-setup-background-dlo': setup}">
				<div class="add-users group plan-usergroup-invite">
						<input id="userList">
				</div>
				<div class="added-users plan-invite-user-modal">
					<div class="peopleInfos ownerInfo">
							<div class="users-list">
								<ul class="users-list__user group" data-ng-repeat="user in userList.userList">
									<li>
										<span class="user-type">
											<input type="checkbox" data-ng-model="user.id2" id="user_{{user.name}}" name="user_{{user.name}}">
											<label title="{{user.text}}" for="user_{{user.name}}"  class="notify-user" data-id="{{user.name}}">{{user.text}}</label>
											<span title="Remove {{user.name}}" class="delete-row" ng-click="deleteUser(user)">&times;</span>
									 	</span>
									</li>
								</ul>
								<ul class="users-list__user group" data-ng-repeat="group in userList.userGroupList">
									<li>
										<span class="group-type">
											<input type="checkbox" data-ng-model="group.id2" id="group_{{group.name}}" name="group_{{group.name}}">
											<label title="{{group.text}}" for="group_{{group.name}}" class="notify-user" data-id="{{group.name}}">{{group.text}}</label>
											<span title="Remove {{group.name}}" class="delete-row" ng-click="deleteUser(group)">&times;</span>
									 	</span>
									</li>
								</ul>
								<ul class="users-list__user group" class="notify-user" data-ng-repeat="egroup in userList.externalGroupList">
									<li>
										<span class="group-type">
											<input type="checkbox" data-ng-model="egroup.id2" id="egroup_{{egroup.name}}" name="egroup_{{egroup.name}}">
											<label title="{{egroup.text}}" for="egroup_{{egroup.name}}" class="notify-user" data-id="{{egroup.name}}">{{egroup.text}}</label>
											<span title="Remove {{egroup.name}}" class="delete-row" ng-click="deleteUser(egroup)">&times;</span>
									 	</span>
									</li>
								</ul>
								<ul class="users-list__user group" data-ng-repeat="ngroup in userList.nonGalaxyUserList">
									<li>
										<span class="email-type">
											<input type="checkbox" data-ng-model="ngroup.id2" id="ngroup_{{ngroup.name}}" name="ngroup_{{ngroup.name}}">
											<label title="{{ngroup.text}}" for="ngroup_{{ngroup.name}}" class="notify-user" data-id="{{ngroup.name}}">{{ngroup.text}}</label>
											<span title="Remove {{ngroup.name}}" class="delete-row" ng-click="deleteUser(ngroup)">&times;</span>
									 	</span>
									</li>
								</ul>
								<ul data-ng-if="userList.externalGroupList.length > 0 || userList.userGroupList.length > 0 || userList.userList.length > 0">
									<li class="invite-user-modal-message">
										<cv:msg key="label.sendToEmail" bundle="profiles"/>
									</li>
								</ul>
							</div>
					</div>
				</div>
			</div>
		</div>
		<div class="button-container">
				<button id="earlyCaseAssessment_button_#7546" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
				<button id="earlyCaseAssessment_button_#2430" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="disableNext" data-ng-click="createAssessment()"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>