
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div id="definitionArea" >
<span class="{{model.errorMessage.type}} serverMessage" data-ng-bind="model.errorMessage.message"></span>
		<uib-accordion close-others="false" class="text-left">
			<div uib-accordion-group data-ng-repeat="step in model.steps" is-open="step.isOpen">
				<div uib-accordion-heading>
					<div class="row">
						<i class="glyphicon definition-arrow"
							data-ng-class="step.isOpen ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right'"></i>
						<span class="step-text">{{step.name}}</span>
					</div>
				</div>
					<div data-ng-if="step.step == 0" >
						<div>
						<div class="form-group">
								<div class="col-xs-12 col-lg-2 col-md-2">
									<label class="" for="definitionName"><cv:msg
											key="label.casemanager.definitionName" bundle="ediscovery" /></label>
								</div>
								<div class="col-xs-12 col-lg-10 col-md-10">
									<input type="text" name="definitionName"
										autofocus required data-ng-pattern="/^[A-Za-z0-9_\- ]*$/" ng-maxlength="50"
										data-ng-model="model.definitionName"
										id="definitionName" />
										<div data-ng-show="submitController.needsAttention(formController.definitionName)">
											<span class="help-block" data-ng-show="formController.definitionName.$error.required">
												<cv:msg key="label.casemanager.error.definitionName" bundle="ediscovery" />
											</span>
											<span class="help-block" data-ng-show="formController.definitionName.$error.pattern">
												<cv:msg key="error.invalidName" bundle="ediscovery" />
											</span>
											<span class="help-block" data-ng-show="formController.definitionName.$error.maxlength">
												<cv:msg key="error.maxlength" bundle="ediscovery" />
											</span>
                            			</div>
								</div>
							</div>
							<div class="form-group">
								<label for="dataType" class="col-xs-12 col-lg-2 col-md-2">
									<cv:msg key="label.casemanager.solution" bundle="ediscovery" />
								</label>
								<div class="col-xs-12 col-lg-10 col-md-10">
									<isteven-multi-select
										required
										input-model="model.solutions"
										output-model="model.selectedSolutions"
										on-close="model.showRequiredInputs(model.selectedSolutions)"
										button-label="name"
										item-label="name"
										tick-property="ticked"
										group-property="msGroup"
										class="isteven-multi-select user-group-select"
										id="dataType"
										name="dataType"
										max-labels="3"
										disable-property="disabled"
										translation="model.entitiesText"
										helper-elements="{{model.helperElements}}"
										>
									</isteven-multi-select>
									<div>
										<span class="help-block" data-ng-bind="model.solutionsErrorMessage"></span>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label for="dataCollection" class="col-xs-12 col-lg-2 col-md-2">
									<cv:msg key="label.ingestion" bundle="ediscovery" />
								</label>
								<div class="col-xs-12 col-lg-10 col-md-10">
									<isteven-multi-select
										required
										input-model="model.ingestionMode"
										output-model="model.selectedIngestionMode"
										button-label="text"
										item-label="text"
										tick-property="ticked"
										group-property="msGroup"
										selection-mode="single"
										class="isteven-multi-select user-group-select"
										id="dataCollection"
										name="dataCollection"
										max-labels="3"
										translation="model.entitiesText"
										helper-elements="{{model.helperElements}}"
										>
									</isteven-multi-select>
								</div>
							</div>
						</div>
					</div>
					<div data-ng-if="step.step == 1" >
						<cv-add-file-servers  file-servers="model.selectedFileServers"/>
					</div>
					<div data-ng-if="step.step == 2" >
						<cv-add-users class="col-lg-8 col-md-8" custodians="model.custodiansList" grid-title="{{model.custodianTitle}}" is-users-deleted="model.custodiansDeleted" show-asset="model.showAsset" read-only="{{model.readOnly}}" />
					</div>
					<div data-ng-if="step.step == 3">
						<div>
							<span class="help-block" data-ng-bind="model.filtersErrorMessage"></span>
						</div>
						<cv-search-filters name="model.definitionName" app-type="model.appType" on-load="model.onFiltersLoaded(filterInstance)" read-only="false" search-request="model.additionalCriteria"></cv-search-filters>
					</div>
			</div>
		</uib-accordion>
	</div>