<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="padding-bottom-0" data-ng-controller="CaseDetailsController as caseDetails">
	<div id="mainWrapper" class="row" >
		<cv-changename obj='caseDetails.changeNameObj' service-method='changeServerName.do' class="float-left case-title">
		</cv-changename>
		<span class="{{caseDetails.error.type}} server-message" data-ng-bind="caseDetails.error.message"></span>
		<%-- <span class="page-action-item">
			<a class="job-text" data-ng-click="caseDetails.goToSearchPage()" data-ng-if="caseDetails.enableCaseSearch" >{{'label.search' | cvLoc}}</a>
			<a class="job-text" data-ng-click="caseDetails.submitCollectionJob()" >{{'label.casemanager.submitCollectionJob' | cvLoc}}</a>
			<a data-ng-href="{{caseDetails.jobHistoryUrl}}" >{{'label.casemanager.viewJobHistory' | cvLoc}}</a>
		</span> --%>
		<a class="page-action-item margin-0 margin-right-20" data-ng-if="caseDetails.dashboardPage" data-ng-click="caseDetails.refreshDashboard()">{{'label.refresh' | cvLoc}}</a>
	</div>
	<cv-tab-nav></cv-tab-nav>
	<div id="detailsArea" data-ng-if="caseDetails.detailsPage">
		<div class="row">
			<div class="col-md-6">
				<cv-tile-component data-ac-id="casemanagerDetails-label_configuration-ediscovery" title='<cv:msg key="label.casemanager.general" bundle="ediscovery"/>'>
					<ul class="list-style-secondary">
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.type" bundle="ediscovery" />
							</span>
							<span class="pageDetailColumn" title="{{caseDetails.caseTypeText }}">{{caseDetails.caseTypeText }} <cv-help-component data-ng-show="caseDetails.isReviewSetCase()" help-text="<cv:msg key="label.casemanager.reviewsetNote" bundle="ediscovery" />"></cv-help-component></span>

						</li>
						<li class="group"><span class="pageDetailColumn"><cv:msg
									key="label.casemanager.createdBy" bundle="ediscovery" /></span> <a
							class="pageDetailColumn" data-ng-if="caseDetails.clientOwner.userId"
							data-ng-href="#/users/{{caseDetails.clientOwner.userId}}"
							title="{{caseDetails.clientOwner.userName}}">{{caseDetails.clientOwner.userName}}</a>
							<span data-ng-if="!caseDetails.clientOwner.userId">{{caseDetails.clientOwner.userName}}</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.createdOn" bundle="ediscovery" />
							</span>
							<span class="pageDetailColumn" data-ng-if="caseDetails.ediscoveryClientDetails" title="{{caseDetails.ediscoveryClientDetails.eDiscoveryClientInfo.installDate * 1000 | date }}">{{caseDetails.ediscoveryClientDetails.eDiscoveryClientInfo.installDate * 1000 | date }}
							</span>
						</li>
						<li class="group" data-ng-if="caseDetails.ediscoveryClientDetails">
							<span class="pageDetailColumn"><cv:msg key="label.description" bundle="ediscovery" /> </span>
							<cv-tile-edit value="caseDetails.currentDescription" enable-edit="true" edit-func="caseDetails.editDescription()" title="{{caseDetails.currentDescription}}">
								<textarea id="description" name="description"
									placeholder='<cv:msg key="placeholder.description" bundle="ediscovery" />'
									data-ng-model="caseDetails.ediscoveryClientDetails.eDiscoveryClientInfo.description"> </textarea>
							</cv-tile-edit>
						</li>
					</ul>
				</cv-tile-component>
			</div>
			<div class="col-md-6">
				<cv-tile-component data-ac-id="casemanagerDetails-label_configuration-ediscovery" 	title='<cv:msg key="label.casemanager.infrastructure" bundle="ediscovery"/>'>
					<ul class="list-style-secondary">
						<li class="group"><span class="pageDetailColumn" title='<cv:msg
									key="label.casemanager.dcPlan" bundle="ediscovery" />'><cv:msg
									key="label.casemanager.dcPlan" bundle="ediscovery" /><cv-help-component help-text="<cv:msg key="info.casemanager.dcPlan" bundle="ediscovery" />"></cv-help-component></span> <a
							class="pageDetailColumn" data-ng-href="#/profileDetails/{{caseDetails.ediscoveryClientDetails.eDiscoveryClientInfo.plan.planId}}" title="{{caseDetails.ediscoveryClientDetails.eDiscoveryClientInfo.plan.planName}}">{{caseDetails.ediscoveryClientDetails.eDiscoveryClientInfo.plan.planName}}</a></li>
						<li class="group" data-ng-if="caseDetails.planReadOnlyMode">
							<span class="pageDetailColumn" title='<cv:msg
									key="label.casemanager.serverPlan" bundle="ediscovery" />'><cv:msg
									key="label.casemanager.serverPlan" bundle="ediscovery" /><cv-help-component help-text="<cv:msg key="info.casemanager.serverPlan" bundle="ediscovery" />"></cv-help-component></span>
							<span class="pageDetailColumn">
								<a  data-ng-href="#/profileDetails/{{caseDetails.selectedServerPlan.plan.planId}}" title="{{caseDetails.selectedServerPlan.plan.planName}}">{{caseDetails.selectedServerPlan.plan.planName}}</a>
								<a data-ng-if="!caseDetails.isCaseClosed" href  class="horizontal-link-button" data-ng-click="caseDetails.resetSettings()" title=""><i class="glyphicon glyphicon-pencil"></i></a>
							</span>
						</li>
						<li class="group" data-ng-if="!caseDetails.planReadOnlyMode">
							<span class="pageDetailColumn"><cv:msg
									key="label.casemanager.serverPlan" bundle="ediscovery" /></span>
							<span class="pageDetailColumn form-group">
							<isteven-multi-select
									required
									input-model="caseDetails.serverPlans"
									output-model="caseDetails.selectedPlan"
									button-label="name"
									item-label="name"
									tick-property="ticked"
									selection-mode="single"
									group-property="msGroup"
									class="isteven-multi-select user-group-select half-width"
									id="serverPlan"
									name="serverPlan"
									max-labels="3"
									translation="caseDetails.entitiesText"
									helper-elements="{{caseDetails.helperElements}}"
									on-item-click="caseDetails.onServerPlanSelect()"
									>
								</isteven-multi-select>
								<span data-ng-if="!caseDetails.planReadOnlyMode" data-ng-disabled="caseDetails.updateInProgress" >
									<a class="horizontal-link-button padding-left-0" href data-ng-click="caseDetails.updateServerPlan()" title="{{'action.save' | cvLoc}}">
        								<i class="glyphicon glyphicon-ok"></i>
        							</a>
									<a href data-ng-click="caseDetails.resetSettings()" title="{{'action.cancel' | cvLoc}}">
										<i class="glyphicon glyphicon-remove"></i>
									</a>
								</span>
							</span>

						</li>
					</ul>
				</cv-tile-component>
			</div>
		</div>
		<div class="row">
			<div class="col-md-6 case-details-statistics" >
				<cv-tile-component data-ac-id="casemanagerDetails-label_configuration-ediscovery" 	title='<cv:msg key="label.statistics" bundle="ediscovery"/>'>
				<table class="col-xs-12">
				<thead>
					<tr>
					<th></th>
						<th><cv:msg key="label.size" bundle="ediscovery" /></th>
						<th><cv:msg key="label.documents" bundle="ediscovery" /></th>
						<th><cv:msg key="label.casemanager.indexed" bundle="ediscovery" /></th>

					</tr>
				</thead>
				<tbody>
					<tr data-ng-if="caseDetails.isEmailCase()">
						<td><b><cv:msg key="label.casemanager.appType_137" bundle="ediscovery" /></b></td>
						<td>{{caseDetails.stats[0].value}}</td>
						<td>{{caseDetails.stats[1].value}}</td>
						<td>{{caseDetails.stats[2].value}}</td>
					</tr>
					<tr data-ng-if="caseDetails.isFileSystemCase()">
						<td><b><cv:msg key="label.casemanager.appType_33" bundle="ediscovery" /></b></td>
						<td>{{caseDetails.stats[3].value}}</td>
						<td>{{caseDetails.stats[4].value}}</td>
						<td>{{caseDetails.stats[5].value}}</td>
					</tr>
				</tbody>
				</table>
					<%-- <ul class="list-style-secondary">
						<li class="group">
							<span class="pageDetailColumn" data-ng-bind="caseDetails.stats[0].title">
							</span>
							<span class="pageDetailColumn">{{caseDetails.stats[0].value}}
							</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn" data-ng-bind="caseDetails.stats[1].title">
							</span>
							<span class="pageDetailColumn">{{caseDetails.stats[1].value}}
							</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.casemanager.indexed" bundle="ediscovery" />
							</span>
							<span class="pageDetailColumn">{{caseDetails.stats[2].value}}
							</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.size" bundle="ediscovery" />
							</span>
							<span class="pageDetailColumn">{{caseDetails.stats[3].value}}
							</span>
						</li>
						<li class="group">
							<span class="pageDetailColumn"><cv:msg key="label.casemanager.custodians" bundle="ediscovery" />
							</span>
							<span class="pageDetailColumn">{{caseDetails.ediscoveryClientDetails.eDiscoveryClientInfo.numberOfCustodians}}
							</span>
						</li>
					</ul> --%>
				</cv-tile-component>
			</div>
			<div class="col-md-6">
				<cv-security-component entity-type='caseDetails.entityType' generic-entity = 'caseDetails.genericEntity' associations='caseDetails.formattedSecurityAssociations' associations-loaded='caseDetails.associationsLoaded' data-show-Owners='true' >
				</cv-security-component>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<cv-kendo-grid class="case-inline-grid" data-cv-grid-options="caseDetails.definitionGridOptions"></cv-kendo-grid>
			</div>
		</div>
	</div>
	<div id="searchArea" data-ng-if="caseDetails.searchPage" data-ng-disabled="caseDetails.inProgress">
		<%-- <view-tabs view-tabs="caseDetails.viewTabs" selected-tab="caseDetails.selectedTab"></view-tabs> --%>
		<cv-search-preview search-params="caseDetails.searchParams"on-load="caseDetails.onLoad(searchInstance)" in-progress="caseDetails.inProgress" data-ng-if="caseDetails.selectedTab === 'list'" height="caseDetails.height" > </cv-search-preview>
		<%-- <div id="reportArea" data-ng-if="caseDetails.selectedTab === 'dashboard'">
			<div id="ng-app" data-ng-app="reports" data-ng-if="caseDetails.reportInfo.queryString"
				data-ng-controller="reportsCtrl"
				data-ng-init="init(undefined, caseDetails.reportInfo.searchViewName, null, null, caseDetails.reportInfo.queryString)">
				<div id="pageDiv" data-ng-controller="pageController"
					class="maskLayer" data-ng-class="{'isMasked':masked}">
					<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
				</div>
			</div>
		</div> --%>
	</div>
	<div id="reportArea" data-ng-if="caseDetails.dashboardPage">
		<div id="ng-app" data-ng-app="reports" data-ng-if="caseDetails.reportInfo.queryString"
			data-ng-controller="reportsCtrl"
			data-ng-init="init(undefined, caseDetails.reportInfo.searchViewName, null, null, caseDetails.reportInfo.queryString)">
			<div id="pageDiv" data-ng-controller="pageController"
				class="maskLayer" data-ng-class="{'isMasked':masked}">
				<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
			</div>
		</div>
	</div>
</div>