<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<div data-ng-controller="CaseDefinitionController as caseDefinition">
<h1 class="page-title">
	<span data-ng-if="caseDefinition.definitionId == 0">{{'label.casemanager.definition' | cvLoc }}</span>
	<span data-ng-if="caseDefinition.definitionId != 0">{{caseDefinition.inputData.definitionName}}</span>
</h1>
<span class="{{caseDefinition.errorMessage.type}} server-message" data-ng-bind="caseDefinition.errorMessage.message"></span>
<div id="mainSection" class="bootstrap-wrapper">
	<form name="definitionForm" autocomplete="off" class="form-horizontal" novalidate cv-hide-api data-cv-submit="caseDefinition.saveDefinition()">
	<div class="col-lg-10 col-lg-offset-1">
		<cv-case-definition input-param="caseDefinition.inputData" on-load="caseDefinition.onDefinitionLoaded(definitionInstance)" ></cv-case-definition>
		<div class="button-container">
			<button id="caseDefinition_button_#6683" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="caseDefinition.cancel()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="caseDefinition_button_#0224" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="caseDefinition.isCaseClosed">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</div>
</form>
</div>
</div>