<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
        <cv:msg key="label.add" bundle="ediscovery"></cv:msg> {{model.caseTypeText}}
    </h1>
</div>
<div class="bootstrap-wrapper">
	<view-tabs view-tabs="model.viewTabs" selected-tab="model.selectedTab" ></view-tabs>
	<p class="{{model.error.type}} serverMessage" data-ng-bind="model.error.message"></p>
	<form name="addToCaseForm" id="addToCaseForm" cv-hide-api data-cv-submit="model.onSave()" novalidate autocomplete="off">
        <div data-ng-if="model.selectedTab === 'existing'">
			<div class="form-group">
				<label for="dataType" class="col-xs-12 col-lg-4 col-md-4">
					{{model.caseTypeText}} <cv:msg key="label.casemanager.lowerCase" bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-lg-8 col-md-8">
					<isteven-multi-select
						required
						input-model="model.eDiscoveryClients"
						output-model="model.selectedCase"
						button-label="name"
						item-label="name"
						tick-property="ticked"
						selection-mode="single"
						group-property="msGroup"
						class="isteven-multi-select user-group-select"
						id="dataType"
						name="dataType"
						max-labels="3"
						translation="model.entitiesText"
						helper-elements="{{model.helperElements}}"
						on-item-click="model.onCaseSelect()"
						>
					</isteven-multi-select>
					<input type="text" ng-model="model.selectedCase" name="inputCase" style="display:none" required />
					<div data-ng-show="cv.addToCaseForm.needsAttention(addToCaseForm.inputCase)">
						<span class="help-block" data-ng-show="addToCaseForm.inputCase.$error.required">
							<cv:msg key="error.emptyCase" bundle="ediscovery" />
						</span>
					</div>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="clientName" >
					<cv-help-text help-label="label.casemanager.definitionName" help-text="helpText.definitionName" />
				</label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" id="definitionName" name="definitionName" data-ng-model="model.definitionName" required data-ng-pattern="/^[a-zA-Z0-9_-]*$/" ng-maxlength="50" />
					<div data-ng-show="cv.addToCaseForm.needsAttention(addToCaseForm.definitionName)">
						<span class="help-block" data-ng-show="addToCaseForm.definitionName.$error.required">
							<cv:msg key="error.emptyName" bundle="ediscovery" />
						</span>
						<span class="help-block" data-ng-show="addToCaseForm.definitionName.$error.pattern">
							<cv:msg key="error.casemanager.noAppName" bundle="ediscovery" />
						</span>
						<span class="help-block" data-ng-show="addToCaseForm.definitionName.$error.maxlength">
							<cv:msg key="error.maxlength" bundle="ediscovery" />
						</span>
					</div>
				</div>
			</div>
		</div>
		<div id="newCase" data-ng-if="model.selectedTab === 'new'">
				<div class="form-group">
                    <label class="col-xs-12 col-md-4 col-lg-4" for="clientName" >
                        <cv:msg key="label.name" bundle="collections" />
                    </label>
                    <div class="col-xs-12 col-md-8 col-lg-8">
                        <input type="text" id="clientName" name="clientName" data-ng-model="model.caseClientName" required autofocus data-ng-pattern="/^[a-zA-Z0-9_-]*$/" ng-maxlength="50" />
                        <div data-ng-show="cv.addToCaseForm.needsAttention(addToCaseForm.clientName)">
                            <span class="help-block" data-ng-show="addToCaseForm.clientName.$error.required">
                                <cv:msg key="error.emptyName" bundle="ediscovery" />
                            </span>
                            <span class="help-block" data-ng-show="addToCaseForm.clientName.$error.pattern">
                                <cv:msg key="error.casemanager.noAppName" bundle="ediscovery" />
                            </span>
                            <span class="help-block" data-ng-show="addToCaseForm.clientName.$error.maxlength">
                                <cv:msg key="error.maxlength" bundle="ediscovery" />
                            </span>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="ediscoveryPlan" class="col-xs-12 col-md-4 col-lg-4">
                        <cv:msg key="label.casemanager.dcPlan" bundle="ediscovery" />
                    </label>
                    <div class="col-xs-12 col-md-8 col-lg-8">
						<isteven-multi-select
						html-template="true"
						input-model="model.ediscoveryPlans"
						output-model="model.selectedEdiscoveryPlan"
						button-label="planName"
						item-label="plan.isValid ? planName : template"
						tick-property="ticked"
						selection-mode="single"
						group-property="msGroup"
						disable-property="disabled"
						class="isteven-multi-select user-group-select edit-users-grid-form"
						id="ediscoveryPlan"
						name="ediscoveryPlan"
						max-labels="3"
						translation="model.entitiesText"
						helper-elements="{{model.helperElements}}"
						>
					</isteven-multi-select>
					<input type="text" ng-model="model.selectedEdiscoveryPlan" name="inputEdiscoveryPlan" class="display-none" required />
					<div data-ng-show="cv.addToCaseForm.needsAttention(addToCaseForm.ediscoveryPlan)">
						<span class="help-block" data-ng-show="addToCaseForm.inputEdiscoveryPlan.$error.required">
							<cv:msg key="error.emptyDCPlan" bundle="ediscovery" />
						</span>
					</div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="plans" class="col-xs-12 col-md-4 col-lg-4">
                        <cv:msg key="label.casemanager.serverPlan" bundle="ediscovery" />
                    </label>
                    <div class="col-xs-12 col-md-8 col-lg-8">
						<isteven-multi-select
						input-model="model.serverPlans"
						output-model="model.selectedServerPlan"
						button-label="name"
						item-label="name"
						tick-property="ticked"
						selection-mode="single"
						group-property="msGroup"
						class="isteven-multi-select user-group-select"
						id="serverPlan"
						name="serverPlan"
						max-labels="3"
						translation="model.entitiesText"
						helper-elements="{{model.helperElements}}"
						>
					</isteven-multi-select>
					<input type="text" ng-model="model.selectedServerPlan" name="inputServerPlan" style="display:none" required />
                        <div data-ng-show="cv.addToCaseForm.needsAttention(addToCaseForm.inputServerPlan)">
                            <span class="help-block" data-ng-show="addToCaseForm.inputServerPlan.$error.required">
                                <cv:msg key="error.emptyServerPlan" bundle="ediscovery" />
                            </span>
                        </div>
                    </div>
                </div>
		</div>
		  <div class="form-group" data-ng-if="model.holdTypes.length != 0">
                    <label for="plans" class="col-xs-12 col-md-4 col-lg-4">
                        <cv:msg key="label.casemanager.solution" bundle="ediscovery" />
                    </label>
                    <div class="col-xs-12 col-md-8 col-lg-8">
						<isteven-multi-select
						input-model="model.holdTypes"
						output-model="model.selectedHoldType"
						button-label="name"
					 	  item-label="name"
						tick-property="ticked"
						selection-mode="single"
						group-property="msGroup"
						class="isteven-multi-select user-group-select"
						id="holdType"
						name="holdType"
						max-labels="3"
						translation="model.entitiesText"
						helper-elements="{{model.helperElements}}"
						>
					</isteven-multi-select>
					<input type="text" ng-model="model.selectedHoldType" name="inputHoldType" style="display:none" required />
                        <div data-ng-show="cv.addToCaseForm.needsAttention(addToCaseForm.inputHoldType)">
                            <span class="help-block" data-ng-show="addToCaseForm.inputHoldType.$error.required">
                                <cv:msg key="error.emptySolution" bundle="ediscovery" />
                            </span>
                        </div>
                    </div>
            </div>
			<div class="form-group">
				<label for="selectionRange" class="col-xs-12 col-lg-4 col-md-4">
					<cv:msg key="label.casemanager.selectionRange" bundle="ediscovery" />
				</label>
				<div class="col-xs-12 col-lg-8 col-md-8">
					<isteven-multi-select
						required
						input-model="model.selectionRanges"
						output-model="model.selectedRange"
						button-label="text"
						item-label="text"
						tick-property="ticked"
						selection-mode="single"
						group-property="msGroup"
						class="isteven-multi-select user-group-select"
						id="selectionRange"
						name="selectionRange"
						max-labels="3"
						translation="model.entitiesText"
						helper-elements="{{model.helperElements}}"
						>
					</isteven-multi-select>
					<input type="text" ng-model="model.selectedRange" name="inputRange" style="display:none" required />
					<div data-ng-show="cv.addToCaseForm.needsAttention(addToCaseForm.inputRange)">
						<span class="help-block" data-ng-show="addToCaseForm.inputRange.$error.required">
							<cv:msg key="error.emptySelectionRange" bundle="ediscovery" />
						</span>
					</div>
				</div>
			</div>
                <div class="form-group">
                    <label for="dataCollection" class="col-xs-12 col-lg-4 col-md-4">
                        <cv:msg key="label.ingestion" bundle="ediscovery" />
                    </label>
                    <div class="col-xs-12 col-lg-8 col-md-8">
                        <isteven-multi-select
                            required
                            input-model="model.ingestionMode"
                            output-model="model.selectedIngestionMode"
                            button-label="text"
                            item-label="text"
                            tick-property="ticked"
							selection-mode="single"
                            group-property="msGroup"
                            class="isteven-multi-select user-group-select"
                            id="dataCollection"
                            name="dataCollection"
                            max-labels="3"
                            translation="model.entitiesText"
                            helper-elements="{{model.helperElements}}"
                            >
                        </isteven-multi-select>
                    </div>
                </div>
		<div class="modal-footer">
            <button id="addToCaseModal_button_#8739" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="exchange"/></button>
			<button id="addToCaseModal_button_#2279" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="model.cancel()"><cv:msg key="action.cancel" bundle="exchange"/></button>
		</div>
	</form>
</div>
