<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>

<h1 class="page-title">
	<span data-ng-if="!clientGroupDetailsCtrl.gettingDetails">{{ clientGroupDetailsCtrl.clientGroup.displayName }}</span>
	<span data-ng-if="clientGroupDetailsCtrl.gettingDetails">{{ 'Loading' | cvLoc }}<img src="./img/loading.gif"></img></span>
</h1>

<div id="detailsArea" data-ng-if="!clientGroupDetailsCtrl.gettingDetails">
	<div id="projectDetails">
		<div class="row">
			<div class="col-md-6">
				<cv-tile-component title="{{ 'label.configuration' | cvLoc }}">
					<ul class="list-style-secondary">
						<li class="group">
                            <span class="pageDetailColumn">
                                <cv:msg key="label.totalDocs" bundle="ediscovery" />
                            </span>
                            <span class="pageDetailColumn">
                                {{ clientGroupDetailsCtrl.clientGroup.totalDocuments }}
                            </span>
                        </li>
						<li class="group">
                            <span class="pageDetailColumn">
                                <cv:msg key="label.schedule" bundle="ediscovery" />
                            </span>
                            <span class="pageDetailColumn" data-ng-if="clientGroupDetailsCtrl.clientGroup">
                                <schedule entity-id="clientGroupDetailsCtrl.clientGroup.id" entity-type="clientGroupDetailsCtrl.entityType" entity-name="clientGroupDetailsCtrl.clientGroup.hostName" />
                            </span>
						</li>
					</ul>
				</cv-tile-component>
			</div>
		</div>

		<cv-kendo-grid data-cv-grid-options="clientGroupDetailsCtrl.clientsGridOptions"></cv-kendo-grid>
	</div>
</div>
