<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<div data-ng-init="init()">
	<div class="setup-title">
		<h1>{{headerText}}</h1>
	</div>
		<span class="{{userGroupMessage.type}} serverMessage text-center col-xs-12">{{userGroupMessage.message}}</span>
		<form name="addUserGroupForm" novalidate data-cv-submit="addUserGroupSubmit()" autocomplete="off" class="bootstrap-wrapper form-horizontal edit-users-grid-form">
			<div class="modal-body">
				<div data-ng-if="model.userGroupId === 0 && showGroupTypeSelection" class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="userGroupType"><cv:msg key="label.type" bundle="users" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<label class="multiple-radio-group">
							<input type="radio" id="localUserGroup" data-ng-model="model.serviceType" value="LOCAL" name="userGroupType" data-ng-change="setModalType()">
							<cv:msg key="label.localGroup" bundle="users" />
						</label>
						<label class="multiple-radio-group">
							<input type="radio" id="externalUserGroup" data-ng-model="model.serviceType" value="ACTIVE_DIRECTORY" name="userGroupType" data-ng-change="setModalType()">
							<cv:msg key="label.nameServers.AD" bundle="users" />
						</label>
					</div>
				</div>
				<!-- // group name // -->
				<div class="form-group"  data-ng-if="model.localGroup">
					<label for="userGroupName" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.groupName" bundle="users" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="text" name="userGroupName" data-ng-model="model.newUserGroupName" id="userGroupName" required  data-ng-readonly="checkReadonly('userGroupName')"  data-cv-focus="!checkReadonly('userGroupName')"/>
						<span class="help-block" data-ng-show="cv.addUserGroupForm.needsAttention(addUserGroupForm.userGroupName) || showError"><cv:msg key="error.groupName" bundle="users" /></span>
					</div>
				</div>
				<!-- Group name for AD group edit mode  -->
				<div class="form-group"  data-ng-if="model.ADGroup && editMode">
					<label for="userGroupName" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.groupName" bundle="users" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<label type="text" name="userGroupName" id="userGroupName" >{{model.userGroupName}}</label>
					</div>
				</div>
				<!-- Email for AD group edit mode  -->
				<div class="form-group"  data-ng-if="model.ADGroup && editMode && model.email">
					<label for="email" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.email" bundle="users" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7 input-group">
						<label type="text" name="email" id="email" >{{model.email}}</label>
					</div>
				</div>
				<!-- Select External Group as Group Name -->
				<div class="form-group" data-ng-show="model.ADGroup && !editMode">
					<label for="ADGroupName" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.groupName" bundle="users" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<div class="user-group-suggestion-single-select-wrapper" >
							<input title="{{model.newUserGroupName}}" type="text"
								id="userGroupList"
								name="ADGroupName"
							 	autocomplete="off"
							 	class="add-user-type"
							 	data-ng-model="model.selectedGroupName"
							 	data-ng-required="model.ADGroup && !editMode" />
						</div>
						<span class="help-block" data-ng-if="cv.addUserGroupForm.needsAttention(addUserGroupForm.ADGroupName)"><cv:msg key="error.groupName" bundle="users" /></span>
					</div>
				</div>
				<!-- Associate local group AD group  -->
				<div class="form-group" data-ng-if="model.ADGroup">
					<label class="col-xs-12 col-md-5 col-lg-5" for="userGroupType"><cv:msg key="label.localGroup" bundle="users"/>
							<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<isteven-multi-select
		   				  input-model="groups"
		   				  output-model="model.selectedGroups"
		  				  button-label="name"
		  				  item-label="name"
		   				  tick-property="selected"
		   				  class="isteven-multi-select user-group-select"
		   				  id="userGroupType"
		   				  name="userGroupType"
		   				  helper-elements="all none reset filter"
		   				  max-labels="1"
		   				  translation="localLang"
		   				  disable-property="disabled">
						</isteven-multi-select>
					</div>
				</div>
				<!-- // group description // -->
				<div class="form-group" data-ng-if="!checkReadonly('userGroupName')">
					<label for="groupDesc" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="label.groupDesc" bundle="users" />
						<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<textarea data-enable-grammarly="false" data-ng-readonly="checkReadonly('userGroupName')" name="groupDesc" id="groupDesc" data-ng-model="model.description"></textarea>
					</div>
				</div>
				<div data-ng-if="model.plan">
					<cv-plan-migration user-info="model" is-modal=true show-tile=true server-msg="userGroupMessage"></cv-plan-migration>
				</div>
				<!-- // quota enabled // -->
				<input type="checkbox" name="quotaEnabled" id="quotaEnabled" data-ng-model="model.enforceFSQuota" />
				<label for="quotaEnabled"><cv:msg key="label.quotaEnabled" bundle="users" /></label>
				<!-- // quota limit // -->
				<div class="form-group" data-ng-if= "model.enforceFSQuota">
					<label for="quotaLimit" class="col-xs-12 col-md-5 col-lg-5 cv-label usergroup-quota-nomargin-label"><cv:msg key="label.quotaLimit" bundle="users" />
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="number" min="1" name="quotaLimit" data-ng-model="model.quotaLimitInGB" id="quotaLimit"  class="usergroup-quota-input" /> <cv:msg key="label.gb" bundle="users"/>
						<span class="help-block" data-ng-show="cv.addUserGroupForm.needsAttention(addUserGroupForm.quotaLimit) || showError"><cv:msg key="error.quotaLimit" bundle="users" /></span>
					</div>
				</div>
				<!-- // group enabled // -->
				<div data-ng-if="showEnableCheckBox">
					<input type="checkbox" name="groupEnabled" id="groupEnabled" data-ng-model="model.enabled"  data-ng-disabled="checkReadonly('enabled')"/>
					<label for="groupEnabled"><cv:msg key="label.groupEnabled" bundle="users" /></label>
				</div>
				<!-- // TwoFactorAuthentication // -->
				<div data-ng-if="model.showTFA && model.enableTwoFactorAuthentication && model.enableTwoFactorAuthentication !== 'DISABLED_AT_COMPANY'">
					<input type="checkbox" id="enableTwoFactorAuthentication" data-ng-model="model.enableTwoFactorAuthentication" data-ng-true-value = "'ON'" data-ng-false-value = "'OFF'"/>
					<label for="enableTwoFactorAuthentication"><cv:msg key="label.enableTwoFactorAuthentication" bundle="users"/></label>
				</div>
				<div data-ng-if="model.isBlackListedDefined">
					<input type="checkbox" id="isBlackListed" data-ng-model="model.isBlackListed" />
					<label for="isBlackListed" class="cv-label">
						<cv-help-text id="BlackListed" help-label="label.isBlackListed" help-text="label.isBlackListedHelpText" />
					</label>
				</div>
				<!-- // Invite users // commented as ther is no backend support to invite users for local groups
				<div class="cv-modal-wrapper no-pad" data-ng-if="showInviteUsers">
					<input type="checkbox" name="inviteUsers" id="inviteUsers" data-ng-model="model.autoInviteNewMembers" />
					<label class="checkbox-label" for="inviteUsers">Automatically invite new users</label>
				</div>
				-->
			</div>
			<div class="modal-footer">
				<button id="addUserGroupModal_button_#6925" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()" data-ng-disabled="disableButtonsonSubmitAdd">
					<cv:msg key="action.cancel" bundle="users" />
				</button>
				<button id="addUserGroupModal_button_#4070" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="disableButtonsonSubmitAdd">
					<cv:msg key="action.save" bundle="users" />
				</button>
			</div>
		</form>
</div>