<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.usersJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.users">
	<div class="setup-title">
		<h1>{{editSmtp.smtp ? '<fmt:message key="pageHeader.editSmtp"></fmt:message>' : '<fmt:message key="pageHeader.addSmtp" />'}}</h1>
	</div>
	<div class="setup-content">
		<span class="server-message {{editSmtp.serverMessage.type}}">{{editSmtp.serverMessage.message}}</span>
		<span data-ng-if="!addAssociatedSmtpForm.smtp.$error.pattern" class="server-message {{editSmtp.emptySMTPMessage.type}}">{{editSmtp.emptySMTPMessage.message}}</span>
		<form name="addAssociatedSmtpForm" novalidate data-cv-submit="editSmtp.save()" autocomplete="off" class="edit-users-grid-form">
			<div class="global-options remove-border-padding" >
				<label for="smtp">
					<cv-call-out placement="top" html-template="editSmtp.identityServerSMTPAddressDocTemplate" label=" <fmt:message key="label.associatedSMTP" />" trigger="mouseenter">
					</cv-call-out>
					<input type="text" id="smtp" name="smtp"  data-ng-model="editSmtp.associatedSmtp" data-ng-required="editSmtp.requiredSMTP" data-ng-pattern="editSmtp.smtpPattern" placeholder="<fmt:message key="placeholder.smtpAddress"/>" maxlength="100" />
					<span class="help-block left-align-to-input" data-ng-show="cv.addAssociatedSmtpForm.needsAttention(addAssociatedSmtpForm.smtp)"><fmt:message key="error.smtpAddress"/></span>
				</label>
			</div>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
			  		<button id="addEditSmtp_button_#9370" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="editSmtp.close()"><cv:msg key="Cancel" /></button> 
			  		<button id="addEditSmtp_button_#6422" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Save"/></button> 
			  	</fmt:bundle>
			</div>
		</form>
	</div>
</fmt:bundle>