<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.usersJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.users">
	<div data-ng-controller="identityRedirectRuleAddEditController as irc"
		data-ng-init="irc.init(addRuleModal.identityRedirectRule, addRuleModal.identityRedirectRulesArray)">
		<div class="setup-title">
			<h1>
				{{addRuleModal.identityRedirectRule ? '
				<fmt:message key="pageHeader.editIdentityRule"></fmt:message>
				' : '
				<fmt:message key="pageHeader.addIdentityRule" />
				'}}
			</h1>
		</div>
		<form name="addRedirectRuleForm" novalidate
			data-ng-submit="irc.saveRule(addRuleModal.identityRedirectRulesArray, addRuleModal.rowIndex, addRuleModal.submit, addRuleModal.successCallback, addRuleModal.failureCallback)"
			autocomplete="off" class="form-horizontal edit-users-grid-form">
			<div class="modal-body">
				<div class="setup-content no-padding"><span class="server-message {{addRuleModal.serverMessage.type}}">{{addRuleModal.serverMessage.message}}</span></div>
				<div class="setup-content no-padding">
					<span data-ng-if="irc.redirectRuleMessage"
					class="server-message {{irc.redirectRuleMessage.type}}">{{irc.redirectRuleMessage.message}}</span>
				</div>
				<div class="bootstrap-wrapper">
					<!-- For Edit : disable chosen domain -->
					<div data-ng-if="addRuleModal.identityRedirectRule"
						class="form-group">
						<label class="col-sm-5"
							data-ng-if="addRuleModal.identityRedirectRule" for="name">
							<cv-call-out placement="top" html-template="irc.identityServerDomainNameDocTemplate" label=" <fmt:message key="label.domainName" />" trigger="mouseenter">
							</cv-call-out>
						</label>
						<div class="col-sm-7">
							<input disabled type="url" id="name" name="name"
								data-ng-model="irc.identityRedirectRule.companyAlias" required
								maxlength="100" />
						</div>
					</div>
					<!-- For Add-->
					<div data-ng-if="!addRuleModal.identityRedirectRule"
						class="form-group">
						<label class="col-sm-5">
							<cv-call-out placement="top" html-template="irc.identityServerDomainNameDocTemplate" label=" <fmt:message key="label.domainName" />" trigger="mouseenter">
							</cv-call-out>
								<span data-ng-if="addRuleModal.isCreatedForCommcell" class="optional-text"><cv:msg key="label.optional"
									bundle="subscriptions" />
									</span>
						</label>
						<!-- For commcell app, the domain name is optional.-->
						<div data-ng-required="irc.selectedDomain.domainName"
							class="col-sm-7">
							<cv-editable-select data-cv-model="irc.selectedDomain"
								dropdown-options="irc.nameServerData"
								dropdown-item-label="domainName" showSearchBar="true"
								dropdown-place-holder="<fmt:message key="label.selectACompanyAlias"/>">
							</cv-editable-select>
						</div>
					</div>
					<div class="form-group">
						<label for="newSMTP" class="col-sm-5">
							<cv-call-out placement="top" html-template="irc.identityServerSMTPAddressDocTemplate" label=" <fmt:message key="label.associatedSMTP" />" trigger="mouseenter">
							</cv-call-out>
						</label>
						<div class="col-sm-7">
							<div class="input-group">
								<input data-ng-model="irc.newSMTPAddress" id="newSMTP"
									placeholder="<fmt:message key="placeholder.smtpAddress"/>"
									name="newSMTP"
									data-ng-pattern="irc.smtpPattern"
									data-ng-change="irc.validateSMTPAddress(irc.newSMTPAddress, true)"
									maxlength="100" type="text" /><span class="input-group-btn">
									<button id="addEditIdentityRedirectRuleModal_button_#0297" data-ng-disabled="addRedirectRuleForm.newSMTP.$invalid || irc.duplicateSMTP" type="button" 
										data-ng-click="irc.addSMTPAddress(irc.newSMTPAddress)"
										class="btn btn-primary">
										<fmt:message key="label.add" />
									</button>
								</span>
							</div>
							<span class="help-block"
								data-ng-if="addRedirectRuleForm.newSMTP.$invalid"><i class="ion-alert-circled"></i><fmt:message
									key="error.smtpAddress" /></span>
							<span class="help-block"
								data-ng-if="irc.duplicateSMTP && addRedirectRuleForm.newSMTP.$valid"><i class="ion-alert-circled"></i><fmt:message
									key="error.duplicatedSMTP" /></span>
						</div>
					</div>
				</div>
				<hr />
				<cv-grid cv-grid-options="irc.gridOptions"></cv-grid>
			</div>
			<div class="modal-footer">
				<fmt:bundle basename="localization.messages">
					<button id="addEditIdentityRedirectRuleModal_button_#0505" type="button" 
						class="btn btn-default cvBusyOnAjax setup-btn--hidden"
						data-ng-click="addRuleModal.close()">
						<cv:msg key="Cancel" />
					</button>
					<button id="addEditIdentityRedirectRuleModal_button_#0356" data-ng-disabled="addRuleModal.isCreatedForCommcell === false && !irc.selectedDomain.domainName" 
						type = "submit" class="btn btn-primary cvBusyOnAjax">
						<cv:msg key="Save" />
					</button>
				</fmt:bundle>
			</div>
		</form>
	</div>
</fmt:bundle>